/* #define DEBUG */

#include <stdio.h>
#include "gmon.h"
#include "gmon_out.h"
#include <sys/uio.h>

#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

struct gmon_mcount_struct {
  long long gmon_mcount_count;
  long long gmon_mcount_off;
  long long gmon_mcount_busy;
  long long gmon_mcount_error;
  long long gmon_mcount_toolowpc;
  long long gmon_mcount_toohighpc;
};

static struct gmonparam gmonparam;	/* userland gmonparam information */
#define NARCS_PER_WRITEV	32

/* ------------------------------------------------------------------------ */
/* File uClinux/linux/arch/mipsnommu/head.S */
/*         .global _gmonparam_ptr */
/* _gmonparam_ptr: .word   _gmonparam; */
/*                 .word   _gmon_mcount_struct; */

#define	_gmonparam_ptr		0x80100008
#define	_gmon_mcount_struct	0x8010000c

/* ------------------------------------------------------------------------ */

static void write_kernel_call_graph (fd)
int fd;
{
  u_char tag = GMON_TAG_CG_ARC;
  int from_index, to_index, from_len;
  u_long frompc;
  struct iovec iov[2 * NARCS_PER_WRITEV];
  int nfilled;
  struct gmon_cg_arc_record raw_arc[NARCS_PER_WRITEV]; 

  for (nfilled = 0; nfilled < NARCS_PER_WRITEV; ++nfilled) {
    iov[2 * nfilled].iov_base = &tag;
    iov[2 * nfilled].iov_len = sizeof (tag);

    iov[2 * nfilled + 1].iov_base = &raw_arc[nfilled];
/*     iov[2 * nfilled + 1].iov_len = sizeof (struct gmon_cg_arc_record __attribute__ ((packed))); */
    iov[2 * nfilled + 1].iov_len = sizeof (struct gmon_cg_arc_record);
  }

  nfilled = 0;
  from_len = gmonparam.fromssize / sizeof (*gmonparam.froms);
  for (from_index = 0; from_index < from_len; ++from_index) {
    if (gmonparam.froms[from_index] == 0)
      continue;

    frompc = gmonparam.lowpc;
    frompc += (from_index * gmonparam.hashfraction * sizeof (*gmonparam.froms));
    for (to_index = gmonparam.froms[from_index];
	 to_index != 0;
	 to_index = gmonparam.tos[to_index].link) {
      struct arc {
	char *frompc;
	char *selfpc;
	long long timediff;
	unsigned int timeminimum;
	unsigned int timemaximum;
	long long performance_count;
	unsigned int performance_count_minimum;
	unsigned int performance_count_maximum;
	int32_t count;
      } __attribute__ ((packed)) arc;

      arc.frompc = (char *) frompc;
      arc.selfpc = (char *) gmonparam.tos[to_index].selfpc;
      arc.timediff = gmonparam.tos[to_index].timediff;
      arc.timeminimum = gmonparam.tos[to_index].timeminimum;
      arc.timemaximum = gmonparam.tos[to_index].timemaximum;
      arc.performance_count = gmonparam.tos[to_index].performance_count;
      arc.performance_count_minimum = gmonparam.tos[to_index].performance_count_minimum;
      arc.performance_count_maximum = gmonparam.tos[to_index].performance_count_maximum;
      arc.count  = gmonparam.tos[to_index].count;
#ifdef DEBUG
fprintf(stderr, "to_index=%d frompc=%p selfpc=%p count=%d timediff=%qd min=%qd max=%qd\n", to_index, arc.frompc, arc.selfpc, arc.count, arc.timediff, arc.timeminimum, arc.timemaximum);
fprintf(stderr, "\tperformance_count=%qd min=%qd max=%qd\n", arc.performance_count, arc.performance_count_minimum, arc.performance_count_maximum);
#endif
      memcpy (raw_arc + nfilled, &arc, sizeof (raw_arc [0]));
/* fprintf(stderr, "sizeof (raw_arc [0])=%d, sizeof (struct gmon_cg_arc_record)=%d sizeof(arc)=%d\n", sizeof (raw_arc [0]), sizeof (struct gmon_cg_arc_record __attribute__ ((aligned (__alignof__ (char *))))), sizeof (arc)); */

      if (++nfilled == NARCS_PER_WRITEV) {
	if (writev (fd, iov, 2 * nfilled) <0) {
	  perror("writev #1");
	  exit(1);
	}
	nfilled = 0;
      }
    }
  }
  if (nfilled > 0) {
    if (writev (fd, iov, 2 * nfilled) < 0) {
      perror("writev #2");
      exit(1);
    }
  }
}


/* ------------------------------------------------------------------------ */
static void write_kernel_hist (fd)
int fd;
{
  u_char tag = GMON_TAG_TIME_HIST;
  struct gmon_hist_hdr thdr __attribute__ ((aligned (__alignof__ (char *))));

  struct iovec iov[3] = {
    { &tag, sizeof (tag) },
    { &thdr, sizeof (struct gmon_hist_hdr) },
    { gmonparam.kcount, gmonparam.kcountsize }
  };

  *(char **) thdr.low_pc = (char *) gmonparam.lowpc;
  *(char **) thdr.high_pc = (char *) gmonparam.highpc;
  *(int32_t *) thdr.hist_size = (gmonparam.kcountsize
				 / sizeof (HISTCOUNTER));
  *(int32_t *) thdr.prof_rate = 1000000 / 10000;
  strncpy (thdr.dimen, "seconds", sizeof (thdr.dimen));
  thdr.dimen_abbrev = 's';

  if (writev (fd, iov, 3) < 0) {
    perror("writev #3");
    exit(1);
  }
}

/* ------------------------------------------------------------------------ */
int main()
{
  /* Location of structure in kernel, converted to userland pointer. */
  int *ptr;
  struct gmonparam *p;
  struct gmon_mcount_struct *gmon_mcount_struct;
  struct gmon_hdr ghdr __attribute__ ((aligned (__alignof__ (int))));
  int fd = -1;

  ptr = (int*)(_gmonparam_ptr & 0x0fffffff);
  ptr = (int *)(*ptr & 0x0fffffff);
  p = (struct gmonparam *)ptr;

  ptr = (int *)(_gmon_mcount_struct & 0x0fffffff);
  ptr = (int *)(*ptr);
  ptr = (int *)((int)ptr & 0x0fffffff);
  gmon_mcount_struct = (struct gmon_mcount_struct *)ptr;

  gmonparam.kcount = p->kcount;
  gmonparam.kcountsize = p->kcountsize;
  gmonparam.froms = (unsigned short *)((int)(p->froms) & 0x0fffffff);
  gmonparam.fromssize = p->fromssize;
  gmonparam.tos = (struct tostruct *)((unsigned int)p->tos & 0x0fffffff);
  gmonparam.tolimit = p->tolimit;
  gmonparam.lowpc = p->lowpc;
  gmonparam.highpc = p->highpc;
  gmonparam.textsize = p->textsize;
  gmonparam.hashfraction = p->hashfraction;
  gmonparam.log_hashfraction = p->log_hashfraction;

  p = & gmonparam;
  p->kcountsize = sizeof(unsigned short);
  p->kcount = malloc(p->kcountsize * sizeof(unsigned short));
  bzero(p->kcount, sizeof(unsigned short));

  fd = open ("kernel.gmon.out", O_CREAT|O_TRUNC|O_WRONLY, 0666);
  if (fd < 0) {
    fprintf(stderr, "can't open file for writing\n");
    exit(1);
  }

/* first print out problems counters */
  fprintf(stderr, "gmon_mcount -- total_calls=%qd, turned_off=%qd, busy=%qd, error=%qd\n",
	gmon_mcount_struct->gmon_mcount_count,
	gmon_mcount_struct->gmon_mcount_off,
	gmon_mcount_struct->gmon_mcount_busy,
	gmon_mcount_struct->gmon_mcount_error);
  fprintf(stderr, "               toolowpc=%qd, toohighpc=%qd\n",
	gmon_mcount_struct->gmon_mcount_toolowpc,
	gmon_mcount_struct->gmon_mcount_toohighpc);

/* write gmon.out header: */
  memset (&ghdr, '\0', sizeof (struct gmon_hdr));
  memcpy (&ghdr.cookie[0], GMON_MAGIC, sizeof (ghdr.cookie));
  *(int32_t *) ghdr.version = GMON_VERSION;
  if (write (fd, &ghdr, sizeof (struct gmon_hdr)) < 0) {
    perror("write");
    exit(1);
  }

/* write PC histogram: */
  write_kernel_hist (fd);

/* write call graph */
  write_kernel_call_graph (fd);

  return(0);
}

/* ------------------------------------------------------------------------ */
