/* #define DEBUG */
/* #define BRIEF */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include "gmon_out.h"
#include "gprof.h"

/* ------------------------------------------------------------------------ */
extern int getnfile(const char *, char ***);
extern nltype *nllookup(unsigned long);
/* ------------------------------------------------------------------------ */
static struct gmon_hist_hdr thdr __attribute__ ((aligned (__alignof__ (char *))));
static unsigned int low_pc;
static unsigned int high_pc;
static unsigned int hist_size;
static unsigned int prof_rate;
static unsigned short *kcount;

static int valcmp(const void *, const void *);

/* ------------------------------------------------------------------------ */
#define LONGLONGMOVE(store,temporary,input)			\
	temporary = (input & 0xffffffff00000000LL) >> 32;	\
	temporary = htonl(temporary);				\
  	store = (long long)temporary;				\
  	temporary = input & 0x00000000ffffffffLL;		\
  	temporary = htonl(temporary); 				\
  	store |= (long long)temporary << 32;

#define UNSIGNEDINTMOVE(store,temporary, input)			\
	(unsigned int)temporary = (unsigned int)input;					\
	(unsigned int)store = htonl(temporary)
/* ------------------------------------------------------------------------ */
static void read_bb_counts(fd)
int fd;
{
  fprintf(stderr,"Not done yet, read_bb_counts\n");
  exit(1);
}

/* ------------------------------------------------------------------------ */
static void read_call_graph(fd)
int fd;
{
  ssize_t lth;
  struct gmon_cg_arc_record raw_arc __attribute__ ((aligned (__alignof__ (char*))));
  unsigned int from_pc;
  unsigned int self_pc;
  unsigned int count;
  nltype *routine;
  nltype *calledfrom;
  const char *routinename;
  const char *calledfromname;
  unsigned int tmp;
  long long timediff;
  unsigned int timeminimum;
  unsigned int timemaximum;
  long long performance_count;
  unsigned int performance_count_minimum;
  unsigned int performance_count_maximum;

  lth = read(fd, &raw_arc, sizeof(raw_arc));
#ifdef DEBUG
for (tmp=0; tmp < sizeof(raw_arc); tmp++) {
  fprintf(stderr, "%-2.2x", *((unsigned char *)&raw_arc + tmp));
}
fprintf(stderr, "\n");
#endif
  if (lth != sizeof(raw_arc)) {
    perror("read_call_graph, read raw_arc");
    exit(1);
  }
/*   (int) from_pc = *(char **)(raw_arc.from_pc); */
/*   from_pc = htonl(from_pc); */
  UNSIGNEDINTMOVE(from_pc, tmp, *(char **)(raw_arc.from_pc));
/*   (int) self_pc = *(char **)(raw_arc.self_pc); */
/*   self_pc = htonl(self_pc); */
  UNSIGNEDINTMOVE(self_pc, tmp, *(char **)(raw_arc.self_pc));
/*   tmp = (raw_arc.timediff & 0xffffffff00000000LL) >> 32; */
/* fprintf(stderr, "tmp #1=%-8.8x\n", tmp); */
/*   tmp = htonl(tmp); */
/* fprintf(stderr, "tmp #2=%-8.8x\n", tmp); */
  LONGLONGMOVE(timediff, tmp, raw_arc.timediff);
  UNSIGNEDINTMOVE(timeminimum, tmp, raw_arc.timeminimum);
  UNSIGNEDINTMOVE(timemaximum, tmp, raw_arc.timemaximum);
  LONGLONGMOVE(performance_count, tmp, raw_arc.performance_count);
  UNSIGNEDINTMOVE(performance_count_minimum, tmp, raw_arc.performance_count_minimum);
  UNSIGNEDINTMOVE(performance_count_maximum, tmp, raw_arc.performance_count_maximum);
/*   (int) count = *(char **)(raw_arc.count); */
/*   count = htonl(count); */
  UNSIGNEDINTMOVE(count, tmp, *(char **)(raw_arc.count));

  routine = nllookup(self_pc);
  if (routine == NULL) {
    routinename = "";
  } else {
    routinename = routine->name;
  }
  calledfrom = nllookup(from_pc);
  if (calledfrom == NULL) {
    calledfromname = "";
  } else {
    calledfromname = calledfrom->name;
  }

/*   fprintf(stderr, "from_pc = %p self_pc = %p count = %d\n", (void *)from_pc, (void *)self_pc, (int)(count)); */
#if 0
  fprintf(stdout, "%8.8x %-33s %8.8x %-33s %9d\n",
	self_pc, routinename, from_pc, calledfromname, (int)count);
#endif	/* 0 */
#ifndef BRIEF
  fprintf(stdout, "%8.8x %-33s %8.8x %-33s %9d %20qd %10qd %7u %8u %20qd %12qd %8u %8u %5.2f %5.2f %5.2f\n",
	self_pc, routinename, from_pc, calledfromname, (int)count,
	timediff, timediff/count, timeminimum, timemaximum,
	performance_count, performance_count/count, performance_count_minimum, performance_count_maximum,
	(double)performance_count / (double)timediff ,
	(double)performance_count_minimum / (double)timeminimum ,
	(double)performance_count_maximum / (double)timemaximum );
#else
  fprintf(stdout, "%8.8x %-33s %8.8x %-33s %9d %10qd %12qd %5.2f\n",
	self_pc, routinename, from_pc, calledfromname, (int)count,
	timediff/count, performance_count/count,
	(double)performance_count / (double)timediff);
#endif
}

/* ------------------------------------------------------------------------ */
static int read_hist_done_already = 0;

/* ------------------------------------------------------------------------ */
static void read_hist(fd)
int fd;
{
  ssize_t lth;
  int i;
  unsigned int tmp;

  if (read_hist_done_already++ != 0) {
    fprintf(stderr, "read_hist already done, program can't do it more than once.\n");
    exit(1);
  }
/* Entry is gmon_hist_hdr */
  lth = read(fd, &thdr, sizeof(thdr));
#ifdef DEBUG
for (i=0; i < sizeof(thdr); i++) {
  fprintf(stderr, "%-2.2x", *((unsigned char *)&thdr + i));
}
fprintf(stderr, "\n");
#endif
  if (lth != sizeof(thdr)) {
    perror("read_hist, read thdr");
    exit(1);
  }
/*   (int) low_pc = *(char **)(thdr.low_pc); */
/*   low_pc = htonl(low_pc); */
  UNSIGNEDINTMOVE(low_pc, tmp, *(char **)(thdr.low_pc));
/*   (int) high_pc = *(char **)(thdr.high_pc); */
/*   high_pc = htonl(high_pc); */
  UNSIGNEDINTMOVE(high_pc, tmp, *(char **)(thdr.high_pc));
/*   (int) hist_size = *(char **)(thdr.hist_size); */
/*   hist_size = htonl(hist_size); */
  UNSIGNEDINTMOVE(hist_size, tmp, *(char **)(thdr.hist_size));
/*   (int) prof_rate = *(char **)(thdr.prof_rate); */
/*   prof_rate = htonl(prof_rate); */
  UNSIGNEDINTMOVE(prof_rate, tmp, *(char **)(thdr.prof_rate));
#ifdef DEBUG
  fprintf(stderr, "low_pc=%p, high_pc=%p, hist_size=%d, prof_rate=%d, dimen=%s, dimen_abbrev=%c\n",
	(void *)low_pc, (void *)high_pc, (int)(hist_size), (int)(prof_rate),
	thdr.dimen, thdr.dimen_abbrev);
#endif
  
  kcount = (unsigned short *)malloc(hist_size * sizeof (unsigned short));
  if (kcount == NULL) {
    fprintf(stderr, "%s: malloc, out of memory\n", __FUNCTION__);
    exit(1);
  }
  lth = read(fd, kcount, hist_size * sizeof(unsigned short));
#ifdef DEBUG
for (i=0; i < hist_size * sizeof(unsigned short); i++) {
  fprintf(stderr, "%-2.2x", *((unsigned char *)kcount + i));
}
fprintf(stderr, "\n");
#endif
  if (lth != hist_size * sizeof(unsigned short)) {
    perror("read_hist, read kcount");
    exit(1);
  }
  for (i=0; i < hist_size; i++) {
    kcount[i] = htons(kcount[i]);	/* convert to our machine format */
#ifdef DEBUG
    fprintf(stderr, "timercount %d = %d\n", i, kcount[i]);
#endif
  }
}

/* ------------------------------------------------------------------------ */
int main(int argc, char **argv)
{
  struct gmon_hdr ghdr __attribute__ ((aligned (__alignof__ (int))));
  int fd = -1;
  int version;
  ssize_t lth;
  unsigned char gmon_type;
  char *kernel_file_name;
  char *kernel_gmon_out;
  char **defaultEs;
  int header_already = 0;
  unsigned int tmp;

  if (argc != 3) {
    fprintf(stderr, "usage: kgprof linux kernel.gmon.out\n");
    exit(1);
  }
  kernel_file_name = argv[1];
  kernel_gmon_out = argv[2];
  fd = open (kernel_gmon_out, O_RDONLY, 0);
  if (fd < 0) {
    fprintf(stderr, "open %s failure fd=%d\n", kernel_gmon_out, fd);
    exit(1);
  }
/* Get elf symbols.  */
  if (getnfile(kernel_file_name, &defaultEs) == -1) {
    fprintf(stderr, "%s: bad format", kernel_file_name);
    exit(1);
  }
  qsort(nl, nname, sizeof(nltype), valcmp);

  read(fd, &ghdr, sizeof (struct gmon_hdr));
  if (strncmp(GMON_MAGIC, &ghdr.cookie[0], sizeof (ghdr.cookie)) != 0) {
    fprintf(stderr, "header(%s) != %s\n", &ghdr.cookie[0], GMON_MAGIC);
    exit(1);
  }
/*   version = htonl(*(int32_t *)ghdr.version); */
  UNSIGNEDINTMOVE(version, tmp, *(int32_t*)(ghdr.version));
  if (version != GMON_VERSION) {
    fprintf(stderr, "version(%d) != %d\n", version, GMON_VERSION);
    exit(1);
  }

/* First entry is type. */
  while (1) {
    lth = read(fd, &gmon_type, sizeof(gmon_type));
    if (lth < 0) {
      perror("read gmon_type");
      exit(1);
    } else if (lth == 0) {
      break;			/* end of file */
    } else if (lth != sizeof(gmon_type)) {
      fprintf(stderr, "read of gmon_type lth wrong, only %d, should be %d\n", lth, sizeof(gmon_type));
      exit(1);
    }
#ifdef DEBUG
fprintf(stderr, "lth=%d, gmon_type=0x%-2.2x\n", lth, gmon_type);
fprintf(stderr, "GMON_TAG_TIME_HIST=%d, GMON_TAG_CG_ARC=%d, GMON_TAG_BB_COUNT=%d\n", GMON_TAG_TIME_HIST, GMON_TAG_CG_ARC, GMON_TAG_BB_COUNT);
#endif
    if (gmon_type == GMON_TAG_TIME_HIST) {
      read_hist(fd);
    } else if (gmon_type == GMON_TAG_CG_ARC) {
      if (header_already++ == 0) {
#ifndef BRIEF
	fprintf(stdout, "%-8s %-33s %-8s%-33s %7s %20s %10s %7s %8s %20s %12s %8s %8s %5s %5s %5s\n",
		" Routine", "Name", "Called from", "_name", "Count",
		"COP_0_COUNT", "Avg", "Min", "Max",
		"Performance_Count", "Avg", "Min", "Max", "Pf/C0", "Min", "Max");
#else
	fprintf(stdout, "%-8s %-33s %-8s%-33s %7s %10s %12s %5s\n",
		" Routine", "Name", "Called from", "_name", "Count",
		"C0_Avg", "Pf_Avg", "Pf/C0");
#endif
      }
      read_call_graph(fd);
    } else if (gmon_type == GMON_TAG_BB_COUNT) {
      read_bb_counts(fd);
    } else {
      fprintf(stderr, "gmon_type unrecognized (%d)\n", gmon_type);
      exit(1);
    }
  }
#ifdef DEBUG
  fprintf(stderr, "done reading gmon.out file\n");
#endif
  close(fd);
  return(0);
}

/* ------------------------------------------------------------------------ */
int             valcmp(const void *vp1, const void *vp2)
{
  const nltype   *p1 = vp1;
  const nltype   *p2 = vp2;

  if (p1->value < p2->value) {
    return -1;
  }
  if (p1->value > p2->value) {
    return 1;
  }
  return 0;
}

/* ------------------------------------------------------------------------ */
