
/*
** A new version of vxworksxlat, to use the newer API
*/
#define MSP_SUCCESS 0
#define ERROR -1
#define OK 0
extern int errno ;

typedef void (*SecCompletionFunc) (unsigned int callerRefId,
				   unsigned int status);

typedef struct {
	U32			            Key1High;
	U32			            Key1Low;
	U32						Key1Mode;
	U32			            Key2High;
	U32			            Key2Low;
	U32						Key2Mode;
	U32			            Key3High;
	U32			            Key3Low;
	U32						Key3Mode;
} msp_sec_3des_key;

typedef struct {
	U32			IVHigh;
	U32			IVLow;
} msp_sec_des_iv;


typedef struct {
	U32	ChainVarA;
	U32	ChainVarB;
	U32	ChainVarC;
	U32	ChainVarD;
	U32	ChainVarE;
} msp_sec_hsh_chaining_vars;

extern void perror() ;
extern int ioctl() ;


static inline int MspSecDESXncryptFast(void *src, void *dst,
			   msp_sec_3des_key *key,
			   msp_sec_des_iv *iv,
			   int length, int mode)
{
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;

	int rc ;

	sa.flags = SAFLG_MODE_CRYPT ;

	if ( (mode & DMC_MOD) == DMC_MOD_PT)
		sa.flags |= SAFLG_CRYPTNULL ;
	else {
		if (mode & DMC_3DES)
		{
			sa.flags |= SAFLG_3DES ;
			if (key->Key1Mode)
				sa.flags |= SAFLG_DES_K1_DECRYPT ;
			if (key->Key2Mode)
				sa.flags |= SAFLG_DES_K2_DECRYPT ;
			if (key->Key3Mode)
				sa.flags |= SAFLG_DES_K3_DECRYPT ;
		}
		else
		{
			sa.flags |= SAFLG_DES ;
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_DES_K1_DECRYPT ;
		}

		switch (mode & DMC_MOD)
		{
		case DMC_MOD_ECB:
			sa.flags |= SAFLG_ECB ;
			break ;
		case DMC_MOD_CBC:
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_CBC_DECRYPT ;
			else
				sa.flags |= SAFLG_CBC_ENCRYPT ;
			break ;
		case DMC_MOD_CFB:
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_CFB_DECRYPT ;
			else
				sa.flags |= SAFLG_CFB_ENCRYPT ;
			break ;
		}
	}

	sa.crypt_iv[0] = iv->IVHigh ;
	sa.crypt_iv[1] = iv->IVLow ;

	sa.crypt_keys[0] = key->Key1High ;
	sa.crypt_keys[1] = key->Key1Low ;
	sa.crypt_keys[2] = key->Key2High ;
	sa.crypt_keys[3] = key->Key2Low ;
	sa.crypt_keys[4] = key->Key3High ;
	sa.crypt_keys[5] = key->Key3Low ;

	wqe.status     = 0 ;

	MSP_SEC2_NEW_REQUEST(&wqe, /* wqep */
			     0, /* work_q */
			     &sa, /* sa */
			     0	/* control */
			     ) ;

	MSP_SEC2_ADD_SG(&wqe, 0 /* gather */, src, length ) ;
	MSP_SEC2_ADD_SG(&wqe, 1 /* scatter*/, dst, length ) ;

	rc = MSP_SEC2_END_REQUEST(&wqe) ;
	if (rc)
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	return wqe.status ;
}

#define MspSecDESXncryptBlk MspSecDESXncryptFast

static inline int MspSecDESXncrypt(unsigned int id,
			      void *src,
			      void *dst,
			      msp_sec_3des_key *key,
			      msp_sec_des_iv *iv,
			      int length,
			      int mode,
			      SecCompletionFunc comp)
{
	int rc ;
	rc = MspSecDESXncryptFast(src, dst, key, iv, length, mode) ;
	comp(id, rc) ;

	return rc ;
}

/* Chain building:  for now assuming building one chain at a time. */

int curchain ;
sec_cbuf chainbufs[64] ;

static inline int MspSecBuildChain(int *chainid,
			       int length,
			       void *src, void *dst)
{
	if(curchain >= 64)
		return -1 ;

	chainbufs[curchain].buflen  = length ;
	chainbufs[curchain].srcaddr = src ;
	chainbufs[curchain].dstaddr = dst ;

	curchain++ ;
	return 0 ;
		
}
	

	
static inline int MspSecDESXncryptChain(unsigned int id,
				   int chain,
				   msp_sec_3des_key *key,
				   msp_sec_des_iv *iv,
				   int mode,
				   SecCompletionFunc comp)
{
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;

	int rc ;

	sa.flags = SAFLG_MODE_CRYPT ;

	if ( (mode & DMC_MOD) == DMC_MOD_PT)
		sa.flags |= SAFLG_CRYPTNULL ;
	else {
		if (mode & DMC_3DES)
		{
			sa.flags |= SAFLG_3DES ;
			if (key->Key1Mode)
				sa.flags |= SAFLG_DES_K1_DECRYPT ;
			if (key->Key2Mode)
				sa.flags |= SAFLG_DES_K2_DECRYPT ;
			if (key->Key3Mode)
				sa.flags |= SAFLG_DES_K3_DECRYPT ;
		}
		else
		{
			sa.flags |= SAFLG_DES ;
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_DES_K1_DECRYPT ;
		}

		switch (mode & DMC_MOD)
		{
		case DMC_MOD_ECB:
			sa.flags |= SAFLG_ECB ;
			break ;
		case DMC_MOD_CBC:
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_CBC_DECRYPT ;
			else
				sa.flags |= SAFLG_CBC_ENCRYPT ;
			break ;
		case DMC_MOD_CFB:
			if (mode & DMC_MOD_DEC)
				sa.flags |= SAFLG_CFB_DECRYPT ;
			else
				sa.flags |= SAFLG_CFB_ENCRYPT ;
			break ;
		}
	}

	sa.crypt_iv[0] = iv->IVHigh ;
	sa.crypt_iv[1] = iv->IVLow ;

	sa.crypt_keys[0] = key->Key1High ;
	sa.crypt_keys[1] = key->Key1Low ;
	sa.crypt_keys[2] = key->Key2High ;
	sa.crypt_keys[3] = key->Key2Low ;
	sa.crypt_keys[4] = key->Key3High ;
	sa.crypt_keys[5] = key->Key3Low ;

	wqe.status     = 0 ;

	MSP_SEC2_NEW_REQUEST(&wqe, /* wqep */
			     0, /* work_q */
			     &sa, /* sa */
			     0	/* control */
			     ) ;

	for (rc = 0 ; rc < curchain ; rc++)
	{
		MSP_SEC2_ADD_SG(&wqe, 0 /* gather */,
				chainbufs[rc].srcaddr,
				chainbufs[rc].buflen) ;
		MSP_SEC2_ADD_SG(&wqe, 1 /* scatter */,
				chainbufs[rc].dstaddr,
				chainbufs[rc].buflen) ;
	}

	rc = MSP_SEC2_END_REQUEST(&wqe) ;

	if (rc == 0)
		rc = wqe.status ;
	else
		printf("ioctl failed, rc %d, errno %d\n", rc, errno) ;

	curchain = 0 ;

	if(comp)
		comp(id, rc) ;

	return rc ;
}

#define MspSecDESXncryptChainFast(chain, key, iv, mode) \
		MspSecDESXncryptChain(0, chain, key, iv, mode, 0)


static inline int MspSecHshFast(void *src, void *dst,
			    int length,
			    msp_sec_hsh_chaining_vars *chainvars,
			    int mode)
{
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;

	int rc ;
	int hashlen ;

	sa.hash_init_len[0] = 0 ;
	sa.hash_init_len[1] = 0 ;

	if (mode & MSP_SEC_DO_PADDING)
		sa.flags = SAFLG_MODE_HASH_PAD ;
	else
		sa.flags = SAFLG_MODE_HASH ;

	if (mode & HMC_SHA1)
	{
		sa.flags |= SAFLG_SHA1 ;
		hashlen = 20 ;
	}
	else
	{
		sa.flags |= SAFLG_MD5 ;
		hashlen = 16 ;
	}

	if (mode & HMC_CRV)
		sa.flags |= SAFLG_CV ;
	
	if (chainvars)
		memcpy((void *)&sa.hash_chain_a[0], (void *)chainvars,
		       sizeof(*chainvars)) ;
	

	wqe.status    = 0 ;

	MSP_SEC2_NEW_REQUEST(&wqe, /* wqep */
			     0, /* work_q */
			     &sa, /* sa */
			     0	/* control */
			     ) ;

	MSP_SEC2_ADD_SG(&wqe, 0 /* gather */, src, length ) ;
	MSP_SEC2_ADD_SG(&wqe, 1 /* scatter*/, dst, hashlen ) ;

	rc = MSP_SEC2_END_REQUEST(&wqe) ;
	if (rc)
	{
		printf("ioctl failed\n") ;
		return rc ;
	}

	return wqe.status ;
}

#define MspSecHshBlk MspSecHshFast

static inline int MspSecHsh(unsigned int id,
			void *src,
			void *dst,
			int length,
			msp_sec_hsh_chaining_vars *chainvars,
			int mode,
			SecCompletionFunc comp)
{
	int rc ;
	rc = MspSecHshFast(src, dst, length, chainvars, mode) ;
	comp(id, rc) ;
	return rc ;
}

static inline int MspSecHshChain(unsigned int id,
			     int chain,
			     msp_sec_hsh_chaining_vars *chainvars,
			     int mode,
			     SecCompletionFunc comp)
{
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;

	int rc ;
	int hashlen ;

	sa.hash_init_len[0] = 0 ;
	sa.hash_init_len[1] = 0 ;

	if (mode & MSP_SEC_DO_PADDING)
		sa.flags = SAFLG_MODE_HASH_PAD ;
	else
		sa.flags = SAFLG_MODE_HASH ;

	if (mode & HMC_SHA1)
	{
		sa.flags |= SAFLG_SHA1 ;
		hashlen = 20 ;
	}
	else
	{
		sa.flags |= SAFLG_MD5 ;
		hashlen = 16 ;
	}

	if (mode & HMC_CRV)
		sa.flags |= SAFLG_CV ;
	
	if (chainvars)
		memcpy((void *)&sa.hash_chain_a[0], (void *)chainvars,
		       sizeof(*chainvars)) ;
	

	wqe.status    = 0 ;

	MSP_SEC2_NEW_REQUEST(&wqe, /* wqep */
			     0, /* work_q */
			     &sa, /* sa */
			     0	/* control */
			     ) ;

	for (rc = 0 ; rc < curchain ; rc++)
	{
		MSP_SEC2_ADD_SG(&wqe, 0 /* gather */,
				chainbufs[rc].srcaddr,
				chainbufs[rc].buflen) ;
	}
	MSP_SEC2_ADD_SG(&wqe, 1 /* scatter */, chainbufs[0].dstaddr, hashlen) ;

	rc = MSP_SEC2_END_REQUEST(&wqe) ;

	if (rc == 0)
		rc = wqe.status ;
	else
		printf("ioctl failed\n") ;


	curchain = 0 ;

	if(comp)
		comp(id, rc) ;

	return rc ;
}

static inline int MspSecHshHMACFast(void *src, void *dst,
				int length,
				msp_sec_hsh_chaining_vars *chainvars,
				unsigned int keylength,
				unsigned char *key,
				int mode)
{
	MSP_SEC2_SA sa ;
	MSP_SEC2_WQE wqe ;
	int hashlen ;

	int rc ;

	sa.flags = SAFLG_MODE_HMAC ;

	if (mode & HMC_SHA1)
	{
		sa.flags |= SAFLG_SHA1 ;
		hashlen = 20 ;
	}
	else
	{
		sa.flags |= SAFLG_MD5 ;
		hashlen = 16 ;
	}

	sa.flags |= SAFLG_CV ;
	
	if (chainvars)
		memcpy((void *)&sa.hash_chain_a[0], (void *)chainvars,
		       sizeof(*chainvars)) ;
	

	wqe.status    = 0 ;

	MSP_SEC2_SET_HMAC_KEY(&sa, key, keylength, 0, 0) ;

	MSP_SEC2_NEW_REQUEST(&wqe, /* wqep */
			     0, /* work_q */
			     &sa, /* sa */
			     0	/* control */
			     ) ;

	MSP_SEC2_ADD_SG(&wqe, 0 /* gather */, src, length) ;
	MSP_SEC2_ADD_SG(&wqe, 1 /* scatter */, dst, hashlen) ;

	rc = MSP_SEC2_END_REQUEST(&wqe) ;
	if (rc == 0)
		rc = wqe.status ;
	else
		printf("ioctl failed\n") ;
	return rc ;
}

