
/*
** Security tests derived from msp/hal_api/fsec_api/mspSecTest.c,v 1.17
**
** 2/14/02 updated to match v 1.20 of vxworks code.
**
*/

/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>

#ifdef SEC_V2
#include <brecis/msp_secv2.h>
#else
#include <brecis/msp_sec.h>
#endif

typedef unsigned char U8 ;
typedef unsigned int U32 ;
typedef int STATUS ;
typedef void (*FUNCPTR)(int) ;
#define MSP5000_CACHE_DATA_LINE_SIZE    (0x10)
/* #define SEC_LOUD_DEBUG */

extern void *malloc() ;
extern void free() ;

#ifdef SEC_V2
#include "vxworksxlat2.c"
#else
#include "vxworksxlat.c"
#endif

#define SEMGIVE(x) 
#define SEMCREATE(x,y,z)
#define SEMTAKE(x, y)
#define SEM_ID int

static inline void *memalign(align, size)
{
	void *m = (void *)malloc(align + size) ;
	return (void *) ( ((int) m) & (size - 1) ) ;
}

/* Globals */
U8		    *SecTestDestAddr1;
U8		    *SecTestDestAddr2;
U8		    *SecTestSrcAddr1;
U32                 SecTestFlipMode = 0;
U32                 SecTestCompareError = 0;
U32                 SecTestTotalCompletionSuccess = 0;
U32                 SecTestTotalCompletionErrors = 0;
U32                 SecTestTotalErrors = 0;
U32                 SecTestCompareOn = 1;
SEM_ID              SecTest3StressSemId;

U32                 SecTestJamErrorStatus;
U32                 SecTestJamTotalComp;
U32                 SecTestJamTotalCompErrors;
U32                 SecTestChainsCleared = 0;

/* JRR-DEBUG */
U32                 JohnNdaZeros;
U32                 JohnTotalIters = 2;

U32                 ErrorCount = 0 ;

static U8		*freeList[3000];
static volatile U32	freeCount;

static U8			*freeList2[3000];
static volatile U32	freeCount2;

void                (*DuetCompleteFunc) ();

typedef struct {
    U32     Status;
    U32     Number;
} msp_sec_test_error_status;

U32                         SecTestJamTDS;
msp_sec_test_error_status   SecTestJamDSA[20];

typedef enum
{
	MD5, SHA_1, HMAC_MD5, HMAC_SHA1
} HSH_TYPE;

typedef struct
{
	HSH_TYPE		type;
	unsigned char	*plainText;
	int				size;
	unsigned char	*result;
} HSHVectors;
	
typedef struct
{
	HSH_TYPE	type;
	char		*key;
	int			keyLength;
	char   		*plainText;
	int			size;
	U32			*result;
} HMACVectors;


char pmrInputA[] ="12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"; 


char pmrInputD[] = "12345678901234567890123456789012345678901234567890123456";

/*  SHA 1 Vectors out of FIPS - 180 */
char sha1Vector1[] = "abc";
char sha1Result1[] = {	0xA9, 0x99, 0x3E, 0x36, 0x47, 0x06, 0x81, 0x6A,
			0xBA, 0x3E, 0x25, 0x71, 0x78, 0x50, 0xC2, 0x6C,
			0x9C, 0xD0, 0xD8, 0x9D };

char sha1Vector2[] = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
char sha1Result2[] = {	0x84, 0x98, 0x3E, 0x44, 0x1C, 0x3B, 0xD2, 0x6E,
			0xBA, 0xAE, 0x4A, 0xA1, 0xF9, 0x51, 0x29, 0xE5,  
			0xE5, 0x46, 0x70, 0xF1	};

/* MD5 Vectors out of RFC 1321 */
char md5Vector1[] = "";
char md5Result1[] = { 0xd4, 0x1d, 0x8c, 0xd9, 0x8f, 0x00, 0xb2, 0x04, 
		      0xe9, 0x80, 0x09, 0x98, 0xec, 0xf8, 0x42, 0x7e};

char md5Vector2[] = "a";
char md5Result2[] = { 0x0c, 0xc1, 0x75, 0xb9, 0xc0, 0xf1, 0xb6, 0xa8, 
		      0x31, 0xc3, 0x99, 0xe2, 0x69, 0x77, 0x26, 0x61};

char md5Vector3[] = "abc";
char md5Result3[] = { 0x90, 0x01, 0x50, 0x98, 0x3c, 0xd2, 0x4f, 0xb0, 
		      0xd6, 0x96, 0x3f, 0x7d, 0x28, 0xe1, 0x7f, 0x72};

char md5Vector4[] = "message digest";
char md5Result4[] = { 0xf9, 0x6b, 0x69, 0x7d, 0x7c, 0xb7, 0x93, 0x8d, 
		      0x52, 0x5a, 0x2f, 0x31, 0xaa, 0xf1, 0x61, 0xd0};

char md5Vector5[] = "abcdefghijklmnopqrstuvwxyz";
char md5Result5[] = { 0xc3, 0xfc, 0xd3, 0xd7, 0x61, 0x92, 0xe4, 0x00, 
		      0x7d, 0xfb, 0x49, 0x6c, 0xca, 0x67, 0xe1, 0x3b};

char md5Vector6[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789"; 
char md5Result6[] = { 0xd1, 0x74, 0xab, 0x98, 0xd2, 0x77, 0xd9, 0xf5, 
		      0xa5, 0x61, 0x1c, 0x2c, 0x9f, 0x41, 0x9d, 0x9f};

char md5Vector7[] = "12345678901234567890123456789012345678901234567890123456789012345678901234567890";
char md5Result7[] = { 0x57, 0xed, 0xf4, 0xa2, 0x2b, 0xe3, 0xc9, 0x55, 0xac, 
		      0x49, 0xda, 0x2e, 0x21, 0x07, 0xb6, 0x7a};

char md5Vector8[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789A"; 
char md5Result8[] = { 0x42, 0x64, 0x0a, 0xf7, 0x8b, 0x2a, 0x7d, 0xeb, 
		      0x4b, 0x57, 0x15, 0xb0, 0x0e, 0xf3, 0x10, 0x73};

HSHVectors Vectors2Test[] = 
{
#if 0
	/* do not currently support 0 length blocks */
	{MD5, md5Vector1, sizeof(md5Vector1)-1, md5Result1},
#endif
	{MD5, md5Vector2, sizeof(md5Vector2)-1, md5Result2},
	{MD5, md5Vector3, sizeof(md5Vector3)-1, md5Result3},
	{MD5, md5Vector4, sizeof(md5Vector4)-1, md5Result4},
	{MD5, md5Vector5, sizeof(md5Vector5)-1, md5Result5},
	{MD5, md5Vector6, sizeof(md5Vector6)-1, md5Result6},
	{MD5, md5Vector7, sizeof(md5Vector7)-1, md5Result7},
	{MD5, md5Vector8, sizeof(md5Vector8)-1, md5Result8},
	{SHA_1, sha1Vector1, sizeof(sha1Vector1)-1, sha1Result1},
	{SHA_1, sha1Vector2, sizeof(sha1Vector2)-1, sha1Result2},
	{MD5, NULL, 0, NULL}
};


/* HMAC Vectors out of RFC 2202 */
/* MD5 Test Vectors */
char hmacKey1 []    = { 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 
			0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b };
char hmacVector1 [] = "Hi There";	
U32 hmacResult1 []  = { 0x9294727a, 0x3638bb1c, 0x13f48ef8, 0x158bfc9d	};

char hmacKey2 []    = "Jefe";
char hmacVector2 [] = "what do ya want for nothing?";
U32 hmacResult2 []  = { 0x750c783e, 0x6ab0b503, 0xeaa86e31, 0x0a5db738  };

char hmacKey3 []    = { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa	};
char hmacVector3 [] = { 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd };
U32 hmacResult3 []  = { 0x56be3452, 0x1d144c88, 0xdbb8c733, 0xf0e8b3f6 };

char hmacKey4 []    = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
			0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 
			0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 
			0x19 };
char hmacVector4 [] = { 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd };
U32 hmacResult4 []  = { 0x697eaf0a, 0xca3a3aea, 0x3a751647, 0x46ffaa79 };

char hmacKey5 []    = {	0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
			0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c };
char hmacVector5 [] = "Test With Truncation";
U32 hmacResult5 []  = { 0x56461ef2, 0x342edc00, 0xf9bab995, 0x690efd4c };

char hmacKey6[]     = { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa	};
char hmacVector6[]  = "Test Using Larger Than Block-Size Key - Hash Key First";
U32 hmacResult6[]   = {	0x6b1ab7fe, 0x4bd7bf8f, 0x0b62e6ce, 0x61b9d0cd };

char hmacKey7[]     = { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa	};
char hmacVector7[]  = "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data";
U32 hmacResult7[]   = {	0x6f630fad, 0x67cda0ee, 0x1fb1f562, 0xdb3aa53e };


/* SHA1 Test Vectors */
char hmacKey8 []    = {	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
			0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b };
char hmacVector8 [] = "Hi There";	
U32 hmacResult8 []  = {	0xb6173186, 0x55057264, 0xe28bc0b6,
			0xfb378c8e, 0xf146be00 };

char hmacKey9 []    = "Jefe";
char hmacVector9 [] = "what do ya want for nothing?";
U32 hmacResult9 []  = {	0xeffcdf6a, 0xe5eb2fa2, 0xd27416d5,
			0xf184df9c, 0x259a7c79 };

char hmacKey10 []   = {	0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa };
char hmacVector10[] = {	0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
			0xdd, 0xdd };
U32 hmacResult10 [] = { 0x125d7342, 0xb9ac11cd, 0x91a39af4,
			0x8aa17b4f, 0x63f175d3 };

char hmacKey11 []   = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
			0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 
			0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 
			0x19 };
char hmacVector11[] = { 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd,
			0xcd, 0xcd };
U32 hmacResult11 [] = { 0x4c9007f4, 0x026250c6, 0xbc8414f9,
			0xbf50c86c, 0x2d7235da };

char hmacKey12[]    = { 0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
			0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 
			0x0c, 0x0c, 0x0c, 0x0c, 0x0c,
			0x0c, 0x0c, 0x0c, 0x0c, 0x0c };
char hmacVector12[] = "Test With Truncation";
U32 hmacResult12 [] = { 0x4c1a0342, 0x4b55e07f, 0xe7f27be1,
			0xd58bb932, 0x4a9a5a04	};

char hmacKey13[]    = { 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa };
char hmacVector13[] = "Test Using Larger Than Block-Size Key - Hash Key First";
U32 hmacResult13 [] = { 0xaa4ae5e1, 0x5272d00e, 0x95705637,
			0xce8a3b55, 0xed402112	};

char hmacKey14[]    = {	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa };
char hmacVector14[] = "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data";
U32 hmacResult14 [] = { 0xe8e99d0f, 0x45237d78, 0x6d6bbaa7,
			0x965c7808, 0xbbff1a91 };

char hmacKey15[]    = {	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa };
char hmacVector15[] = "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data";
U32 hmacResult15 [] = { 0xe8e99d0f, 0x45237d78, 0x6d6bbaa7,
			0x965c7808, 0xbbff1a91	};
HMACVectors hmacVectors2Test[] = 
{
		/* do not currently support 0 length blocks */
	{HMAC_MD5,  hmacKey1,  sizeof(hmacKey1),   hmacVector1,  sizeof(hmacVector1)-1,  hmacResult1},
	{HMAC_MD5,  hmacKey2,  sizeof(hmacKey2)-1, hmacVector2,  sizeof(hmacVector2)-1,  hmacResult2},
	{HMAC_MD5,  hmacKey3,  sizeof(hmacKey3),   hmacVector3,  sizeof(hmacVector3),    hmacResult3},
	{HMAC_MD5,  hmacKey4,  sizeof(hmacKey4),   hmacVector4,  sizeof(hmacVector4),    hmacResult4},
	{HMAC_MD5,  hmacKey5,  sizeof(hmacKey5),   hmacVector5,  sizeof(hmacVector5)-1,  hmacResult5},
	{HMAC_MD5,  hmacKey6,  sizeof(hmacKey6),   hmacVector6,  sizeof(hmacVector6)-1,  hmacResult6},
	{HMAC_MD5,  hmacKey7,  sizeof(hmacKey6),   hmacVector7,  73,                     hmacResult7},
	{HMAC_SHA1, hmacKey8,  sizeof(hmacKey8),   hmacVector8,  sizeof(hmacVector8)-1,  hmacResult8},
	{HMAC_SHA1, hmacKey9,  sizeof(hmacKey9)-1, hmacVector9,  sizeof(hmacVector9)-1,  hmacResult9},
	{HMAC_SHA1, hmacKey10, sizeof(hmacKey10),  hmacVector10, sizeof(hmacVector10),   hmacResult10},
	{HMAC_SHA1, hmacKey11, sizeof(hmacKey11),  hmacVector11, sizeof(hmacVector11),   hmacResult11},
	{HMAC_SHA1, hmacKey12, sizeof(hmacKey12),  hmacVector12, sizeof(hmacVector12)-1, hmacResult12},
	{HMAC_SHA1, hmacKey13, sizeof(hmacKey13),  hmacVector13, sizeof(hmacVector13)-1, hmacResult13},
	{HMAC_SHA1, hmacKey14, sizeof(hmacKey14),  hmacVector14, 73,                     hmacResult14},
	{HMAC_SHA1, hmacKey15, sizeof(hmacKey15),  hmacVector15, sizeof(hmacVector15)-1, hmacResult15},
	{0, NULL, 0, NULL, 0, NULL}
};

/* NIST Test Data */
U8 NistSrc1 [] = { 0x4e, 0x6f, 0x77, 0x20, 0x69, 0x73, 0x20, 0x74 }; 
U8 NistExp1 [] = { 0x3f, 0xa4, 0x0e, 0x8a, 0x98, 0x4d, 0x48, 0x15 };

U8 NistExp2 [] = { 0x81, 0xce, 0xd6, 0xad, 0x96, 0x4d, 0xde, 0xce };

/* SrcData1 is used in MspSecTestEcbDesSer      */
U8 SrcData1 [] = { 0x10, 0x01, 0x02, 0x03,  0x14, 0x05, 0x06, 0x07,
		   0x18, 0x09, 0x0a, 0x0b,  0x1c, 0x0d, 0x0e, 0x0f };

/* ExpData1 is used in MspSecTestEcbDesBlk      */
/* ExpData1 is used in MspSecTestEcbDesSer      */
U8 ExpData1 [] = { 0xe1, 0x4a, 0x6c, 0xf8, 0xc1, 0xe7, 0x65, 0x7d, 
		   0x10, 0x5d, 0x53, 0xad, 0x3e, 0xe0, 0xd3, 0x20 };

/* SrcData2 is used in MspSecTestEcbDesSer      */
U8  SrcData2 [] = { 0x20, 0x01, 0x02, 0x03,  0x24, 0x05, 0x06, 0x07,
		    0x28, 0x09, 0x0a, 0x0b,  0x2c, 0x0d, 0x0e, 0x0f };

/* ExpData2 is used in MspSecTestEcbDesSer      */
U8  ExpData2 [] = { 0x0e, 0x4e, 0xcb, 0xe0, 0x22, 0x67, 0xc1, 0x2a, 
		    0x33, 0xf3, 0xf2, 0xbd, 0x51, 0x74, 0xd3, 0xf6 };
                        
/* SrcData3 is used in MspSecTestEcbDesChainSer */
U8  SrcData3 [] = { 0x80, 0x01, 0x02, 0x03,   0x84, 0x05, 0x06, 0x07,
		    0x88, 0x09, 0x0a, 0x0b,   0x8c, 0x0d, 0x0e, 0x0f };

/* SrcData4 is used in MspSecTestEcbDesChainSer */
U8  SrcData4 [] = { 0x80, 0x11, 0x12, 0x13,   0x84, 0x15, 0x16, 0x17,
		    0x88, 0x19, 0x1a, 0x1b,   0x7c, 0x1d, 0x1e, 0x1f };

/* SrcData5 is used in MspSecTestEcbDesChainSer */
U8  SrcData5 [] = { 0x80, 0x21, 0x22, 0x23,   0x84, 0x25, 0x26, 0x27,
		    0x88, 0x29, 0x2a, 0x2b,   0x8c, 0x2d, 0x2e, 0x2f };

/* ExpData3 is used in MspSecTestEcbDesChainSer */
U8  ExpData3 [] = { 0x80, 0x01, 0x02, 0x03,   0x84, 0x05, 0x06, 0x07,
		    0x88, 0x09, 0x0a, 0x0b,   0x8c, 0x0d, 0x0e, 0x0f,
		    0x80, 0x11, 0x12, 0x13,   0x84, 0x15, 0x16, 0x17,
		    0x88, 0x19, 0x1a, 0x1b,   0x7c, 0x1d, 0x1e, 0x1f,
		    0x80, 0x21, 0x22, 0x23,   0x84, 0x25, 0x26, 0x27,
		    0x88, 0x29, 0x2a, 0x2b,   0x8c, 0x2d, 0x2e, 0x2f };

/* SrcData6 is used in MspSecTestEcbDesChainSer */
U8  SrcData6 [] = { 0x70, 0x01, 0x02, 0x03,  0x74, 0x05, 0x06, 0x07,
		    0x78, 0x09, 0x0a, 0x0b,  0x7c, 0x0d, 0x0e, 0x0f };

/* SrcData7 is used in MspSecTestEcbDesChainSer */
U8  SrcData7 [] = { 0x70, 0x11, 0x12, 0x13,  0x74, 0x15, 0x16, 0x17,
		    0x78, 0x19, 0x1a, 0x1b,  0x7c, 0x1d, 0x1e, 0x1f };

/* SrcData8 is used in MspSecTestEcbDesChainSer */
U8  SrcData8 [] = { 0x70, 0x21, 0x22, 0x23,  0x74, 0x25, 0x26, 0x27,
		    0x78, 0x29, 0x2a, 0x2b,  0x7c, 0x2d, 0x2e, 0x2f };

/* ExpData4 is used in MspSecTestEcbDesChainSer */
U8  ExpData4 [] = { 0x8e, 0x65, 0x3a, 0x30,  0x04, 0x1f, 0xf9, 0x5b,
		    0x58, 0x2d, 0xdf, 0x02,  0x38, 0x43, 0xe2, 0x63,
		    0x04, 0x85, 0x86, 0x36,  0x9d, 0xfd, 0xf6, 0x92,
		    0xa7, 0xbc, 0xde, 0x8a,  0x08, 0xcb, 0xfe, 0x54,
		    0x1b, 0xfe, 0xa0, 0x88,  0x39, 0xe2, 0xc3, 0x8a,
		    0x46, 0x90, 0x0b, 0x0a,  0x29, 0x3b, 0x82, 0x9b };

/* SrcData9 is used in MspSecTestMd5Blk */
U8  SrcData9 [] = { 0x55, 0x55, 0x55, 0x55, 0xaa, 0xaa, 0xaa, 0xaa,
		    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
		    0x66, 0x66, 0x66, 0x66, 0x99, 0x99, 0x99, 0x99,
		    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
		    0x55, 0x55, 0x55, 0x55, 0xaa, 0xaa, 0xaa, 0xaa,
		    0x33, 0x33, 0x33, 0x33, 0xcc, 0xcc, 0xcc, 0xcc,
		    0x66, 0x66, 0x66, 0x66, 0x80, 0x00, 0x00, 0x00,
		    0xa0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

/* ExpData5 is used in MspSecTestMd5Blk */
U8  ExpData5 [] = { 0x3f, 0x56, 0x62, 0x34,
                    0x16, 0xfc, 0x63, 0x7d, 0x7c, 0x81, 0x2b, 0xca,
                    0xef, 0x8a, 0xb4, 0xae };

/* SrcData10 is used in MspSecTestSha1Blk */
U8  SrcData10 [] = { 0x61, 0x62, 0x63, 0x80,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
                     0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x18 };

/* ExpData6 is used in MspSecTestSha1Blk */
U8  ExpData6 [] = { 0xa9, 0x99, 0x3e, 0x36,  0x47, 0x06, 0x81, 0x6a,
                    0xba, 0x3e, 0x25, 0x71,  0x78, 0x50, 0xc2, 0x6c,
                    0x9c, 0xd0, 0xd8, 0x9d };

/* SrcData11 is used in MspSecTestHshChainSer */
U8 SrcData11 [] = { 0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f };

/* SrcData12 is used in MspSecTestHshChainSer */
U8 SrcData12 [] = { 0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f };

/* SrcData13 is used in MspSecTestHshChainSer */
U8 SrcData13 [] = { 0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x00,
		    0x80, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x10, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00 };

/* SrcData14 is used in MspSecTestHshChainSer */
U8 SrcData14 [] = { 0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x3f,
		    0x40, 0x01, 0x02, 0x03,   0x44, 0x05, 0x06, 0x07,
                    0x48, 0x09, 0x0a, 0x0b,   0x4c, 0x0d, 0x0e, 0x0f,
                    0x40, 0x11, 0x12, 0x13,   0x44, 0x15, 0x16, 0x17,
                    0x48, 0x19, 0x1a, 0x1b,   0x4c, 0x1d, 0x1e, 0x1f,
                    0x40, 0x21, 0x22, 0x23,   0x44, 0x25, 0x26, 0x27,
                    0x48, 0x29, 0x2a, 0x2b,   0x4c, 0x2d, 0x2e, 0x2f,
                    0x40, 0x31, 0x32, 0x33,   0x44, 0x35, 0x36, 0x37,
                    0x48, 0x39, 0x3a, 0x3b,   0x4c, 0x3d, 0x3e, 0x00,
		    0x80, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00, 
		    0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x10, 0x00 };

/* ExpData7 is used in MspSecTestHshChainSer */
U8 ExpData7 [] = { 0x4D, 0xB2, 0x88, 0x6A, 0xF5, 0x79, 0x83, 0xBB, 
		   0xFD, 0xFB, 0x77, 0xA3, 0xE6, 0xBD, 0x0C, 0xA5 };

  
/* ExpData8 is used in MspSecTestHshChainSer */
U8 ExpData8[] = { 0x99, 0xda, 0xe1, 0xef, 0x30, 0xc9, 0xe3, 0xa4, 0x0b, 0x8d, 
		  0x84, 0x07, 0x0b, 0x6f, 0xbe, 0xf0, 0xf0, 0x00, 0xed, 0x58 };

int MspSecWhatTime();

/*************************************************/
/*                                               */
/* MspSecWhatTime                                */
/*                                               */
/* DESCRIPTION:                                  */
/* This routine is used to get the time for      */
/* performance testing.                          */
/*                                               */
/*************************************************/
int MspSecWhatTime()
{
    time_t   tt;
    void * p;

    tt = time(0); 

    p = ctime(&tt);

    printf("%s", (char *)p );

    return 0 ;
}

static void prepareGlobalMemory()
{
	freeCount = 0;
	memset (freeList, 0, sizeof (freeList));
}

static void returnGlobalMemory()
{
	int	i;

	for (i = 0; i < freeCount; i++)
	{
		free (freeList[i]);
		freeList[i] = 0;
	}
	freeCount = 0;

	for (i = 0; i < freeCount2; i++)
	{
		free (freeList2[i]);
		freeList2[i] = 0;
	}
	freeCount2 = 0;
}

/******************************************************************/
/*                                                                */
/* MspSecTestPtDes                                                */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests the MspSecDesEncryptBlk pass through        */
/* capability.                                                    */
/*                                                                */
/* PARAMETERS:                                                    */
/*             none                                               */
/*                                                                */
/******************************************************************/
void MspSecTestPtDes()
{
	U8                  *sourceAddress;
	U8		    *destAddress;
	msp_sec_3des_key    keyValue;
	msp_sec_des_iv	    IV;
	U32		    length;
	U32		    mode;
	U32                 i;
	U32                 *tempAddrPtr;
	U32                 retStatus;

	sourceAddress = (U8 *)malloc(64);
	destAddress = (U8 *)malloc(64);

	tempAddrPtr = (U32 *)sourceAddress;
	for (i=0;i<8;i++)
		*tempAddrPtr++ = 0xABABABAB;

	keyValue.Key1Low = 0xABABABAB; 
	keyValue.Key1High = 0xABABABAB; 

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	length = 64;

	printf("Pass through test\n");

	mode = DMC_MOD_PT | DMC_MOD_ENC ;
        retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keyValue,
					  &IV,
					  length,
					  mode);

	printf("Return value:  %d\n",retStatus);

	printf("\n");
	printf("SrcAddress:\n");
	tempAddrPtr = (U32 *)sourceAddress;
	for (i=0;i<8;i++)
		printf("   0x%x\n",*tempAddrPtr++);

	printf("\n");
	printf("DestAddress:\n");
	tempAddrPtr = (U32 *)destAddress;
	for (i=0;i<8;i++)
		printf("   0x%x\n",*tempAddrPtr++);
	printf("\n");

	if (memcmp(sourceAddress, destAddress, 64))
	{
		printf("*+*+*+*+* Error in comparisson. \n") ;
		ErrorCount++ ;
	}

	free(sourceAddress);
	free(destAddress);

}

/******************************************************************/
/*                                                                */
/* MspSecTestEcbDesBlk                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests the MspSecDesEncryptBlk electronic code     */
/* book (ECB) encryption capability.                              */
/*                                                                */
/* PARAMETERS:                                                    */
/*             none                                               */
/*                                                                */
/******************************************************************/
void MspSecTestEcbDesBlk()
{

	U8                  *sourceAddress;
	U8		    *destAddress;
	msp_sec_3des_key     keyValue;
	msp_sec_des_iv	    IV;
	U32		    length;
	U32		    mode;
	U32                 i;
	U8                  *tempAddrPtr;
	U32                 retStatus;
       
	sourceAddress = SrcData1;
	destAddress = (U8 *)malloc(64);

	keyValue.Key1High = 0xecb10001; 
	keyValue.Key1Low = 0x134efffe; 

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	length = 16;

	printf("ECB test\n");

	mode = DMC_MOD_ECB | DMC_MOD_ENC ;
        retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keyValue,
					  &IV,
					  length,
					  mode);

	printf("Return value:  %d\n",retStatus);

	printf("\n");
	printf("SrcAddress:\n");
	tempAddrPtr = sourceAddress;
	for (i=0;i<16;i++) {
		printf("   0x%x,",*tempAddrPtr++);
		if ((i % 4) == 3)
			printf("\n");
	}

	printf("\n");
	printf("DestAddress:\n");
	tempAddrPtr = destAddress;
	for (i=0;i<16;i++) {
		printf("   0x%x,",*tempAddrPtr++);
		if ((i % 4) == 3)
			printf("\n");
	}
	printf("\n");

	printf("\n");
	printf("ExpData:\n");
	tempAddrPtr = ExpData1;
	for (i=0;i<16;i++) {
		printf("   0x%x,",*tempAddrPtr++);
		if ((i % 4) == 3)
			printf("\n");
	}
	printf("\n");

	if (memcmp(destAddress, ExpData1, 16))
	{
		printf("*+*+*+*+* Error in comparisson. \n") ;
		ErrorCount++ ;
	}

	free(destAddress);

}

/******************************************************************/
/*                                                                */
/* MspSecTestDesNist                                              */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests the MspSecDesEncryptBlk electronic code     */
/* book (ECB) encryption capability.                              */
/*                                                                */
/* PARAMETERS:                                                    */
/*             none                                               */
/*                                                                */
/******************************************************************/
void MspSecTestDesNist()
{

	U8                  *sourceAddress;
	U8  		    *destAddress;
	U8  		    *destAddress2;
	msp_sec_3des_key    keyValue;
	msp_sec_des_iv	    IV;
	U32 		    length;
	U32		    mode;
	U32                 i;
	U8                  *tempAddrPtr;
	U8                  *tempAddrPtr2;
	U32                 retStatus;
	U32                 totalErrors = 0;
       
	sourceAddress = NistSrc1;
	destAddress = (U8 *)malloc(64);
	destAddress2 = (U8 *)malloc(64);

	keyValue.Key1High = 0x01234567; 
	keyValue.Key1Low = 0x89abcdef; 
	IV.IVLow = 0x12345678;
	IV.IVHigh = 0x90abcdef;

	length = 8;

	printf("Des test with known good encryption values:\n");

	mode = DMC_MOD_ECB | DMC_MOD_ENC ;
	retStatus = MspSecDESXncryptFast ( sourceAddress,
					   destAddress,
					   &keyValue,
					   &IV,
					   length,
					   mode);

	printf("Return value:  %d\n",retStatus);

	/* Compare results */
	tempAddrPtr = destAddress;
	tempAddrPtr2 = NistExp1;
	for (i=0;i<8;i++) 
	{
		if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
			printf("Compare Error! [%d], 0x%x != 0x%x\n",
			       i, tempAddrPtr[-1], tempAddrPtr2[-1]);
			totalErrors++;
			/* break; */
		}
	}

	keyValue.Key1High = 0x0; 
	keyValue.Key1Low = 0x0; 

	retStatus = MspSecDESXncryptBlk ( destAddress,
					  destAddress2,
					  &keyValue,
					  &IV,
					  length,
					  mode);

	printf("Return value:  %d\n",retStatus);


	/* Compare results */
	tempAddrPtr = destAddress2;
	tempAddrPtr2 = NistExp2;
   
	for (i=0;i<8;i++) 
	{
		if (*tempAddrPtr++ != *tempAddrPtr2++) 
		{
			printf("Compare Error!\n");
			totalErrors++;
			break;
		}
	}

	printf("Test completed, total errors:  %d\n",totalErrors);
	printf("\n");

	if (totalErrors)
		ErrorCount++ ;

	free(destAddress);
	free(destAddress2);

}

/******************************************************************/
/*                                                                */
/* SecTestDesEncCompleteFunc                                      */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestEcbDesSer for each */
/* encryption it calls.                                           */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption/decryption          */
/*                                                                */
/******************************************************************/
void SecTestDesEncCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;

#ifdef SEC_LOUD_DEBUG
	printf("Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
#ifdef SEC_LOUD_DEBUG
		printf("Completion function -  Error:  0x%x\n",status);
#endif      
	} 
	else 
	{
		expAddrPtr = ExpData1;

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<16;i++) 
		{
			if (*tempAddrPtr++ != *tempAddrPtr2++) 
			{
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("DestAddress:\n");
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<16;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");

		tempAddrPtr = expAddrPtr;
		printf("\n");
		printf("ExpData:\n");
		for (i=0;i<16;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif

		SecTestTotalCompletionSuccess++;
	}
	
	freeList [freeCount] = (U8 *) callerRefId;
	freeCount++;
}

/******************************************************************/
/*                                                                */
/* SecTestDesDecCompleteFunc                                      */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestEcbDesSer for each */
/* decryption it calls.                                           */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption/decryption          */
/*                                                                */
/******************************************************************/
void SecTestDesDecCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;

#ifdef SEC_LOUD_DEBUG
	printf("Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
#ifdef SEC_LOUD_DEBUG
		printf("Completion function -  Error:  0x%x\n",status);
#endif      
	} 
	else 
	{
		expAddrPtr = ExpData2;

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<16;i++) 
		{
			if (*tempAddrPtr++ != *tempAddrPtr2++) 
			{
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("DestAddress:\n");
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<16;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");

		tempAddrPtr = expAddrPtr;
		printf("\n");
		printf("ExpData:\n");
		for (i=0;i<16;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif

		SecTestTotalCompletionSuccess++;
	}
	
	freeList2 [freeCount2] = (U8 *) callerRefId;
	freeCount2++;
}

/******************************************************************/
/*                                                                */
/* MspSecTestEcbDesSer                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a des encryption immediately        */
/* followed by a des decrytpion in ECB mode for a 1000 iterations */
/* All results are compared for accuracy.                         */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestEcbDesSer()
{
	U32                 callerRefId;
	U8                  *sourceAddress;
	msp_sec_3des_key    keyValue;
	msp_sec_des_iv	    IV;
	U32 		    length;
	U32		    mode;
	U32                 i;
	U32                 retStatus;

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestCompareError = 0;
	SecTestTotalErrors = 0;

	prepareGlobalMemory();

	for (i=0;i<1000;i++) 
	{
		if (SecTestCompareError) 
		{
			break;
		}

		sourceAddress = SrcData1;
		/* Change up the order so we exercise the memory */
		if ((i % 2) == 0) 
		{
			SecTestDestAddr2 = (U8 *)malloc(64);
			SecTestDestAddr1 = (U8 *)malloc(64);
		} 
		else 
		{
			SecTestDestAddr1 = (U8 *)malloc(64);
			SecTestDestAddr2 = (U8 *)malloc(64);
		}

		callerRefId = (U32)SecTestDestAddr1;

		keyValue.Key1High = 0xecb10001; 
		keyValue.Key1Low = 0x134efffe; 

		IV.IVLow = 0x0;
		IV.IVHigh = 0x0;

		length = 16;

#ifdef SEC_LOUD_DEBUG
		printf("ECB test == A\n");

		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		mode = DMC_MOD_ECB | DMC_MOD_ENC ;
		retStatus = MspSecDESXncrypt ( callerRefId,
					       sourceAddress,
					       SecTestDestAddr1,
					       &keyValue,
					       &IV,
					       length,
					       mode,
					       SecTestDesEncCompleteFunc);

		if (retStatus)
		{
			printf("Return value:  %d\n",retStatus);
			break;
		}

		sourceAddress = SrcData2;

		callerRefId = (U32)SecTestDestAddr2;

		keyValue.Key1High = 0xecb10702; 
		keyValue.Key1Low = 0x134ef8fd; 

		IV.IVLow = 0x0;
		IV.IVHigh = 0x0;

		length = 16;

#ifdef SEC_LOUD_DEBUG
		printf("ECB test == B\n");
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		mode = DMC_MOD_ECB | DMC_MOD_DEC ;
		retStatus = MspSecDESXncrypt ( callerRefId,
					       sourceAddress,
					       SecTestDestAddr2,
					       &keyValue,
					       &IV,
					       length,
					       mode,
					       SecTestDesDecCompleteFunc);

		if (retStatus)
		{
			printf("Return value:  %d\n",retStatus);
			break;
		}
	}

	if (SecTestCompareError) 
	{
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess :  %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:    %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:  	  %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;

	returnGlobalMemory();
}

/******************************************************************/
/*                                                                */
/* SecDesPTTestChainCompleteFunc                                  */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestEcbDesChainSer in  */
/* each of its encryption calls.                                  */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecDesPTTestChainCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U32         j;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;

#ifdef SEC_LOUD_DEBUG
	printf("Chain Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
#ifdef SEC_LOUD_DEBUG
		printf("Chain Completion function -  Error:  0x%x\n",status);
#endif      
	} 
	else 
	{
		expAddrPtr = ExpData3;

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<48;i++) 
		{
			if (*tempAddrPtr != *tempAddrPtr2) 
			{
				tempAddrPtr = (U8 *)callerRefId;
				tempAddrPtr2 = expAddrPtr;
				printf("JRR-ERROR\n");
				printf("callerRefId: 0x%x\n",callerRefId);

				printf("Got:\n");
				for (j=0;j<48;j++) {
					printf("   0x%x,",*tempAddrPtr++);
					if ((i % 8) == 7)
						printf("\n");
				}
				printf("Expected:\n");
				for (j=0;j<48;j++) {
					printf("   0x%x,",*tempAddrPtr2++);
					if ((i % 8) == 7)
						printf("\n");
				}

                
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("DestAddress:\n");
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<48;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
    
		tempAddrPtr = expAddrPtr;
		printf("\n");
		printf("ExpData:\n");
		for (i=0;i<48;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif

		SecTestTotalCompletionSuccess++;
	}

	freeList [freeCount] = (U8 *) callerRefId;
	freeCount++;
}

/******************************************************************/
/*                                                                */
/* SecDesEncTestChainCompleteFunc                                 */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestEcbDesChainSer in  */
/* each of its encryption calls.                                  */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecDesEncTestChainCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U32         j;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;

#ifdef SEC_LOUD_DEBUG
	printf("Chain Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
#ifdef SEC_LOUD_DEBUG
		printf("Chain Completion function -  Error:  0x%x\n",status);
#endif      
	} 
	else 
	{
		expAddrPtr = ExpData4;

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<48;i++) 
		{
			if (*tempAddrPtr != *tempAddrPtr2) 
			{
				tempAddrPtr = (U8 *)callerRefId;
				tempAddrPtr2 = expAddrPtr;
				printf("callerRefId: 0x%x\n",callerRefId);
				printf("JRR-ERROR\n");
				printf("Got:\n");
				for (j=0;j<48;j++) {
					printf("   0x%x,",*tempAddrPtr++);
					if ((i % 8) == 7)
						printf("\n");
				}
				printf("Expected:\n");
				for (j=0;j<48;j++) {
					printf("   0x%x,",*tempAddrPtr2++);
					if ((i % 8) == 7)
						printf("\n");
				}

				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("DestAddress:\n");
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<48;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
    
		tempAddrPtr = expAddrPtr;
		printf("\n");
		printf("ExpData:\n");
		for (i=0;i<48;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif

		SecTestTotalCompletionSuccess++;
	}

	freeList2 [freeCount2] = (U8 *) callerRefId;
	freeCount2++;
}

/******************************************************************/
/*                                                                */
/* MspSecTestEcbDesChainSer                                       */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a des chained pass through dma then */
/* followed by a des chained encryption in ECB mode for a 1000    */
/* iterations.  All results are compared for accuracy.            */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestEcbDesChainSer()
{
	U32                 callerRefId;
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keyValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 retStatus = MSP_SUCCESS;
	U32                 tempDestLoc;
	U32                 chainId;

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestTotalErrors = 0;
	SecTestCompareError = 0;
	SecTestTotalErrors = 0;

	prepareGlobalMemory();

	for (i=0;i<1000;i++) 
	{
		if (SecTestCompareError || retStatus) 
		{
			break;
		}

		SecTestDestAddr1 = (U8 *)malloc(64);

#ifdef SEC_LOUD_DEBUG
		printf("ECB Chain test\n");
		printf("Calling build chain\n");
#endif
		sourceAddress = SrcData3;
		tempDestLoc = (U32)SecTestDestAddr1;
		callerRefId = (U32)SecTestDestAddr1;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------first dest location:  0x%x\n",(U32)destAddress);
#endif

		chainId = 0;
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

		sourceAddress = SrcData4;
		tempDestLoc += 16;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------next dest location:  0x%x\n",(U32)destAddress);
#endif
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);
		sourceAddress = SrcData5;
		tempDestLoc += 16;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------next dest location:  0x%x\n",(U32)destAddress);
#endif
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

		keyValue.Key1High = 0xecb10001; 
		keyValue.Key1Low = 0x134efffe; 

		IV.IVLow = 0x0;
		IV.IVHigh = 0x0;

		mode = DMC_MOD_PT ;

#ifdef SEC_LOUD_DEBUG
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		retStatus = MspSecDESXncryptChain ( callerRefId,
						    chainId,
						    &keyValue,
						    &IV,
						    mode,
						    SecDesPTTestChainCompleteFunc);

		if (retStatus)
		{
			printf ("retStatus = %d\n", retStatus);
			break;
		}

		SecTestDestAddr2 = (U8 *)malloc(64);

#ifdef SEC_LOUD_DEBUG
		printf("ECB Chain test\n");
		printf("Calling build chain\n");
#endif
		sourceAddress = SrcData6;
		chainId = 0;
		tempDestLoc = (U32)SecTestDestAddr2;
		callerRefId = (U32)SecTestDestAddr2;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------first dest location:  0x%x\n",(U32)destAddress);
#endif
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

		sourceAddress = SrcData7;
		tempDestLoc += 16;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------next dest location:  0x%x\n",(U32)destAddress);
#endif
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);
		sourceAddress = SrcData8;
		tempDestLoc += 16;
		destAddress = (U8 *)tempDestLoc;
#ifdef SEC_LOUD_DEBUG
		printf("--------next dest location:  0x%x\n",(U32)destAddress);
#endif
		MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

		keyValue.Key1High = 0x71717171; 
		keyValue.Key1Low = 0x72727272; 

		IV.IVLow = 0x0;
		IV.IVHigh = 0x0;

		mode = DMC_MOD_ECB ;

#ifdef SEC_LOUD_DEBUG
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		retStatus = MspSecDESXncryptChain ( callerRefId,
						    chainId,
						    &keyValue,
						    &IV,
						    mode,
						    SecDesEncTestChainCompleteFunc);


		if (retStatus)
		{
			printf ("retStatus = %d\n", retStatus);
			break;
		}
	}

	if (SecTestCompareError) 
	{
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess :  %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:    %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:     %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;

	returnGlobalMemory();
}

/******************************************************************/
/*                                                                */
/* SecDesTestBigChainCompleteFunc                                 */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestBigDesChain in     */
/* it's MspSecDesEncryptChain call.                               */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecTestBigChainCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;


	if (status) 
	{
		SecTestTotalCompletionErrors++;
	} 
	else 
	{
		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<48;i++) 
		{
			if (*tempAddrPtr++ != (i & 0xff)) 
			{
				printf("--------------failed at 0x%x\n",i);
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

#ifdef SEC_LOUD_DEBUG
		printf("\n");
		tempAddrPtr = (U8 *)callerRefId;
		printf("DestAddress: %08X\n", callerRefId);
		for (i=0;i<48;i++) 
		{
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif

		SecTestTotalCompletionSuccess++;
	}

	freeList [freeCount] = (U8 *) callerRefId;
	freeCount++;
}

/******************************************************************/
/*                                                                */
/* MspSecTestBigDesChain                                          */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a des chained pass through dma of   */
/* 48 bytes.                                                      */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestBigDesChain()
{

	U32                 callerRefId;
	U8                  *sourceAddress;
	U8                  *destAddress;
	U8                  *tempAddrPtr;
	msp_sec_3des_key     keyValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 retStatus;
	U32                 tempDestLoc;
	U32                 tempSrcLoc;
	U32                 chainId;
	
	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestTotalErrors = 0;
	SecTestCompareError = 0;

	prepareGlobalMemory();

	SecTestSrcAddr1 = (U8 *)malloc(64);
	SecTestDestAddr1 = (U8 *)malloc(64);

	/* Fill in source data */
	sourceAddress = SecTestSrcAddr1;
	tempAddrPtr = sourceAddress;

	for (i=0;i<48;i++)
		*tempAddrPtr++ = (i & 0xFF);
 
	tempSrcLoc = (U32)SecTestSrcAddr1; 
	tempDestLoc = (U32)SecTestDestAddr1; 
	chainId = 0;
	callerRefId = tempDestLoc;
	sourceAddress = (U8 *)tempSrcLoc;
	destAddress = (U8 *)tempDestLoc;

#ifdef SEC_LOUD_DEBUG
	printf("--------first dest location:  0x%x\n",(U32)destAddress);
	printf("--------first src location:  0x%x\n",(U32)sourceAddress);
#endif

	MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

	tempDestLoc += 16;
	tempSrcLoc += 16;
	destAddress = (U8 *)tempDestLoc;
	sourceAddress = (U8 *)tempSrcLoc;
#ifdef SEC_LOUD_DEBUG
	printf("--------next dest location:  0x%x\n",(U32)destAddress);
	printf("--------next src location:  0x%x\n",(U32)sourceAddress);
#endif
	MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

	tempDestLoc += 16;
	tempSrcLoc += 16;
	destAddress = (U8 *)tempDestLoc;
	sourceAddress = (U8 *)tempSrcLoc;

#ifdef SEC_LOUD_DEBUG
	printf("--------next dest location:  0x%x\n",(U32)destAddress);
	printf("--------next src location:  0x%x\n",(U32)sourceAddress);
#endif

	MspSecBuildChain(&chainId, 16, sourceAddress, destAddress);

	keyValue.Key1High = 0xecb10001; 
	keyValue.Key1Low = 0x134efffe; 

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_PT ;

#ifdef SEC_LOUD_DEBUG
	printf("CallerRefId passed in is 0x%x\n",callerRefId);
	printf("About to call serialized version\n");
#endif

	retStatus = MspSecDESXncryptChain ( callerRefId,
					    chainId,
					    &keyValue,
					    &IV,
					    mode,
					    SecTestBigChainCompleteFunc);

	if (retStatus)
		printf ("retStatus = %d\n", retStatus);

	if (SecTestCompareError) 
	{
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess:  %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:   %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:    %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;

	returnGlobalMemory();
}

/******************************************************************/
/*                                                                */
/* SecDesTest3ChainCompleteFunc                                   */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTest3DesChain in       */
/* it's MspSec3DesEncryptChain call.                              */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecTest3ChainCompleteFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;

#ifdef SEC_LOUD_DEBUG
	printf("Chain Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
		printf("Chain Completion function -  Error:  0x%x\n",status);
	} 
	else 
	{
		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<640;i++) {
			if (*tempAddrPtr++ != (i & 0xFF)) {
				printf("--------------failed at 0x%x\n",i);
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

		SecTestTotalCompletionSuccess++;
#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("DestAddress:\n");
		tempAddrPtr = (U8 *)callerRefId;
		for (i=0;i<72;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif      
	}

	freeList [freeCount] = (U8 *) callerRefId;
	freeCount++;
}

/******************************************************************/
/*                                                                */
/* MspSecTest3DesChain                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a des chained pass through dma of   */
/* 640 bytes (10 item chain) with Src == Dest and then does one   */
/* more 640 byte (10 item chain) des pass through to a different  */
/* destination.                                                   */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTest3DesChain()
{
	U32                 callerRefId;
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U8                  *tempAddrPtr;
	U32                 retStatus;
	U32                 tempDestLoc;
	U32                 tempSrcLoc;
	U32                 chainId;

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestTotalErrors = 0;
	SecTestCompareError = 0;
    
	prepareGlobalMemory();
	SecTestDestAddr1 = (U8 *)malloc(1000);
	sourceAddress = SecTestDestAddr1;

	tempAddrPtr = sourceAddress;

	for (i=0;i<640;i++)
		*tempAddrPtr++ = (i & 0xFF);
#ifdef SEC_LOUD_DEBUG
	printf("3Des ECB Chain test\n");
	printf("Calling build chain\n");
#endif

	tempDestLoc = (U32)SecTestDestAddr1;
	callerRefId = (U32)SecTestDestAddr1;
	destAddress = (U8 *)SecTestDestAddr1;
	sourceAddress = (U8 *)tempDestLoc;
	chainId = 0;
	for (i=0;i<10;i++) {
		MspSecBuildChain(&chainId, 64, sourceAddress, destAddress);
		tempDestLoc += 64;
		destAddress = (U8 *)tempDestLoc;
		sourceAddress = (U8 *)tempDestLoc;
	}

	keysValue.Key1High = 0xecb10001; 
	keysValue.Key1Low = 0x134efffe; 
	keysValue.Key1Mode = DMC_K1_ENC ;
	keysValue.Key2High = 0xecb10001; 
	keysValue.Key2Low = 0x134efffe; 
	keysValue.Key2Mode = DMC_K2_ENC ;
	keysValue.Key3High = 0xecb10001; 
	keysValue.Key3Low = 0x134efffe; 
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_PT | DMC_3DES;

#ifdef SEC_LOUD_DEBUG
	printf("About to call serialized version\n");
#endif   
	retStatus = MspSecDESXncryptChain ( callerRefId,
					    chainId,
	                                    &keysValue,
	                                    &IV,
	                                    mode,
					    SecTest3ChainCompleteFunc);

	if (retStatus)
   		printf("Return value:  %d\n",retStatus);


	SecTestDestAddr2 = (U8 *)malloc(1000);

	tempSrcLoc = (U32)SecTestDestAddr1;
	tempDestLoc = (U32)SecTestDestAddr2;
	callerRefId = (U32)SecTestDestAddr2;
	destAddress = (U8 *)tempDestLoc;
	sourceAddress = (U8 *)tempSrcLoc;
	chainId	= 0;
	for (i=0;i<5;i++) {
		MspSecBuildChain(&chainId, 128, sourceAddress, destAddress);
		tempSrcLoc += 128;
		tempDestLoc += 128;
		destAddress = (U8 *)tempDestLoc;
		sourceAddress = (U8 *)tempSrcLoc;
	}
    
	/* JRR-DEBUG */
	keysValue.Key1High = 0xecb10001;
	keysValue.Key1Low = 0x134efffe; 

	retStatus = MspSecDESXncryptChain ( callerRefId,
					    chainId,
	                                    &keysValue,
	                                    &IV,
	                                    mode,
					    SecTest3ChainCompleteFunc);

	if (retStatus)
   		printf("Return value:  %d\n",retStatus);


	if (SecTestCompareError) {
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess: %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:  %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:   %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;

	returnGlobalMemory();
}

/******************************************************************/
/*                                                                */
/* SecDesTest3StressDecCompFunc                                   */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by SecTest3StressEncCompFunc    */
/* for it's MspSec3DesDecryptChain call.                          */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecTest3StressDecCompFunc(U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;

	if (status) {
		SecTestTotalCompletionErrors++;
	} else {
		if (SecTestCompareOn) {
			/* Compare results */
			tempAddrPtr = (U8 *)callerRefId;
			for (i=0;i<640;i++) {
				if (*tempAddrPtr++ != (i & 0xFF)) {
					printf("--------------failed at 0x%x\n",i);
					SecTestCompareError = 1;
					SecTestTotalErrors++;
					break;
				}
			}
		}
		SecTestTotalCompletionSuccess++;
	}

	/* Give Semaphore to continue test- reverse direction */
	SEMGIVE(SecTest3StressSemId);
}

/******************************************************************/
/*                                                                */
/* SecDesTest3StressEncCompFunc                                   */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTest3DesStress for its */
/* MspSec3DesEncryptChain call.  If the encryption is a success,  */ 
/* a MspSecDESDecryptChain is called to decrypt it.               */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecTest3StressEncCompFunc(U32 callerRefId, U32 status)
{
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 retStatus;
	U32                 tempDestLoc;
	U32                 tempSrcLoc;
	U32                 chainId;

	if (status) {
		SecTestTotalCompletionErrors++;
		/* Since encrypt failed, give semaphore now */
		SEMGIVE(SecTest3StressSemId);
	} else {
		SecTestTotalCompletionSuccess++;

		keysValue.Key3High = 0xecb10001; 
		keysValue.Key3Low = 0x134efffe; 
		keysValue.Key3Mode = DMC_K3_DEC ;
		keysValue.Key2High = 0xecb10001; 
		keysValue.Key2Low = 0x134efffe; 
		keysValue.Key2Mode = DMC_K2_DEC ;
		keysValue.Key1High = 0xecb10001; 
		keysValue.Key1Low = 0x134efffe; 
		keysValue.Key1Mode = DMC_K1_DEC ;

		IV.IVLow = 0x0;
		IV.IVHigh = 0x0;

		mode = DMC_MOD_ECB |
			DMC_3DES |
			DMC_MOD_DEC ;

		chainId = callerRefId;
		tempDestLoc = callerRefId;
		tempSrcLoc = callerRefId;
		destAddress = (U8 *)tempDestLoc;
		sourceAddress = (U8 *)tempSrcLoc;
		chainId = 0;
		for (i=0;i<10;i++) {
			MspSecBuildChain(&chainId, 64, sourceAddress, destAddress);
			tempDestLoc += 64;
			tempSrcLoc += 64;
			destAddress = (U8 *)tempDestLoc;
			sourceAddress = (U8 *)tempSrcLoc;
		}

		retStatus = MspSecDESXncryptChain ( callerRefId,
						    chainId,
						    &keysValue,
						    &IV,
						    mode,
						    SecTest3StressDecCompFunc);

	}
}

/******************************************************************/
/*                                                                */
/* MspSecTest3DesStress                                           */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine calls a Des ECB encryption and then the above     */
/* completion function call a decryption and the data is checked. */
/* This test is run through 1500 times.                           */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTest3DesStress()
{
	U32                 callerRefId;
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U8                  *tempAddrPtr;
	U32                 retStatus;
	U32                 tempDestLoc;
	U32                 tempSrcLoc;
	U32                 chainId;
	U32                 j;
	int                 tStat;

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestTotalErrors = 0;
	SecTestCompareError = 0;
    
	SEMCREATE(SEM_Q_FIFO, SEM_FULL, SecTest3StressSemId);

	/* tStat = MspSecCreateTimer(); */

	SecTestDestAddr1 = (U8 *)malloc(10000);
	SecTestSrcAddr1 = (U8 *)malloc(10000);

	tempAddrPtr = SecTestSrcAddr1;

	for (i=0;i<6400;i++)
		*tempAddrPtr++ = (i & 0xFF);
    
	keysValue.Key1High = 0xecb10001; 
	keysValue.Key1Low = 0x134efffe; 
	keysValue.Key1Mode = DMC_K1_ENC ;
	keysValue.Key2High = 0xecb10001; 
	keysValue.Key2Low = 0x134efffe; 
	keysValue.Key2Mode = DMC_K2_ENC ;
	keysValue.Key3High = 0xecb10001; 
	keysValue.Key3Low = 0x134efffe; 
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_ECB | DMC_3DES;

	tStat = MspSecWhatTime();

	fflush(stdout) ;
	
	for (j=0;j<1500;j++) {
		/* spinner */
		write(1,"|\010/\010-\010\\\010"+2*(j%4),2) ;

		SEMTAKE(SecTest3StressSemId, WAIT_FOREVER);

		SecTestCompareOn = 0 ;

		chainId = 0;
		callerRefId = (U32)SecTestDestAddr1;

		tempDestLoc = (U32)SecTestDestAddr1;
		tempSrcLoc = (U32)SecTestSrcAddr1;
		destAddress = (U8 *)tempDestLoc;
		sourceAddress = (U8 *)tempSrcLoc;
		for (i=0;i<10;i++) 
		{
			MspSecBuildChain(&chainId, 640, sourceAddress, destAddress);
			tempDestLoc += 640;
			tempSrcLoc += 640;
			destAddress = (U8 *)tempDestLoc;
			sourceAddress = (U8 *)tempSrcLoc;
		}

		retStatus = MspSecDESXncryptChain ( callerRefId,
						    chainId,
						    &keysValue,
						    &IV,
						    mode,
						    SecTest3StressEncCompFunc);

		SEMTAKE(SecTest3StressSemId, WAIT_FOREVER);

		SecTestCompareOn = 0 ;

		chainId = (U32)SecTestSrcAddr1;
		callerRefId = (U32)SecTestSrcAddr1;

		tempDestLoc = (U32)SecTestDestAddr1;
		tempSrcLoc = (U32)SecTestSrcAddr1;
		destAddress = (U8 *)tempDestLoc;
		sourceAddress = (U8 *)tempSrcLoc;
		chainId = 0;
		for (i=0;i<10;i++) {
			MspSecBuildChain(&chainId, 640, destAddress, sourceAddress);
			tempDestLoc += 640;
			tempSrcLoc += 640;
			destAddress = (U8 *)tempDestLoc;
			sourceAddress = (U8 *)tempSrcLoc;
		}

		retStatus = MspSecDESXncryptChain ( callerRefId,
						    chainId,
						    &keysValue,
						    &IV,
						    mode,
						    SecTest3StressEncCompFunc);

	}

	tStat = MspSecWhatTime();

	tempDestLoc = (U32)SecTestDestAddr1;
	tempSrcLoc = (U32)SecTestSrcAddr1;
	SecTestDestAddr1 = (U8 *)(tempDestLoc & ~(0x20000000)); /* */
	SecTestSrcAddr1 = (U8 *)(tempSrcLoc & ~(0x20000000)); /* */

	free(SecTestDestAddr1); /* */
	free(SecTestSrcAddr1); /* */

	if (SecTestCompareError) {
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess : %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors: 	 %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:    %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;
}

/******************************************************************/
/*                                                                */
/* SecTest3JamCompFunc                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTest3DesJam            */
/* when doing MspSec3DesEncryptChain calls.                       */
/* Any error status returned are recorded in the SecTestJamDSA    */
/* structure.                                                     */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption                     */
/*                                                                */
/******************************************************************/
void SecTest3JamCompFunc(U32 callerRefId, U32 status)
{
	U32             i;

	if (status) 
	{
		SecTestJamTotalCompErrors++;
		if (SecTestJamTDS) 
		{
			for (i=0;i<=SecTestJamTDS;i++) 
			{
				if (status == SecTestJamDSA[i].Status) {
					SecTestJamDSA[i].Number++;
					i = SecTestJamTDS + 1;
				} 
				else 
				{
					if (i == SecTestJamTDS) 
					{
						/* printf("--------New error status:  0x%x\n",status); */
						SecTestJamDSA[SecTestJamTDS].Status = status;
						SecTestJamDSA[SecTestJamTDS].Number = 1;
						SecTestJamTDS++;
						i = SecTestJamTDS + 1;
					} 
				}
			}
		} 
		else 
		{
			/* printf("--------New error status:  %d\n",status); */
			SecTestJamDSA[SecTestJamTDS].Status = status;
			SecTestJamDSA[SecTestJamTDS].Number = 1;
			SecTestJamTDS++;
		}
		SecTestJamErrorStatus = 1;
	} 
	else 
	{
		SecTestJamTotalComp++;
		/* SecTestJamErrorStatus = 0; */
	}
}

void MspSecTest3DESENC()
{
	U8                  sourceAddress[64] = "Mary had a little lamb, its.";
	U8                  destAddress[64];
	U8                  result[64];
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32                 mode;
	U32                 retStatus;

	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K1_ENC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_DEC ;

	keysValue.Key3High = 0x12131415;
	keysValue.Key3Low =  0x16171819;
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB | DMC_3DES;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	/* validate encryption 3 des the slow way */
	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K1_ENC ;

 	mode = DMC_MOD_ECB ; 

	IV.IVLow = 0;
	IV.IVHigh = 0;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	keysValue.Key1High = 0x090a0b0c;
	keysValue.Key1Low = 0x0e0f1011;
	keysValue.Key1Mode = DMC_K1_DEC ;
 	mode = DMC_MOD_ECB | DMC_MOD_DEC ;
	retStatus = MspSecDESXncryptFast (result,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	/* validate encryption 3 des the slow way */
	keysValue.Key1High = 0x12131415;
	keysValue.Key1Low =  0x16171819;
	keysValue.Key1Mode = DMC_K1_ENC ;

 	mode = DMC_MOD_ECB ; 

	IV.IVLow = 0;
	IV.IVHigh = 0;

	retStatus = MspSecDESXncryptFast (result,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	if (memcmp (result, destAddress, 32) == 0)
	{
		fprintf (stdout, "results compare\n");
	}
	else
	{
		fprintf (stderr, "*********** Results DO NOT compare ********** \n");
		ErrorCount++ ;
	}

	{
		int i;

		printf ("Expected Result\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				destAddress[i+0],
				destAddress[i+1],
				destAddress[i+2],
				destAddress[i+3],
				destAddress[i+4],
				destAddress[i+5],
				destAddress[i+6],
				destAddress[i+7]);
		}	
		printf ("Got\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				result[i+0],
				result[i+1],
				result[i+2],
				result[i+3],
				result[i+4],
				result[i+5],
				result[i+6],
				result[i+7]);
		}
		printf ("\n\n");
	}
}

void MspSecTest3DESDEC()
{
	U8                  sourceAddress[64] = "Mary had a little lamb, its.";
	U8                  destAddress[64];
	U8                  result[64];
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32                 mode;
	U32                 retStatus;

	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K1_DEC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_ENC ;

	keysValue.Key3High = 0x12131415;
	keysValue.Key3Low =  0x16171819;
	keysValue.Key3Mode = DMC_K3_DEC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB | DMC_3DES;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	/* validate encryption 3 des the slow way */
	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 

 	mode = DMC_MOD_ECB | DMC_MOD_DEC ;

	IV.IVLow = 0;
	IV.IVHigh = 0;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	keysValue.Key1High = 0x090a0b0c;
	keysValue.Key1Low = 0x0e0f1011;

 	mode = DMC_MOD_ECB ;

	retStatus = MspSecDESXncryptFast (result,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	/* validate encryption 3 des the slow way */
	keysValue.Key1High = 0x12131415;
	keysValue.Key1Low =  0x16171819;

 	mode = DMC_MOD_ECB | DMC_MOD_DEC ;

	IV.IVLow = 0;
	IV.IVHigh = 0;

	retStatus = MspSecDESXncryptFast (result,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Dec: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	if (memcmp (result, destAddress, 32) == 0)
	{
		fprintf (stdout, "results compare\n");
	}
	else
	{
		fprintf (stderr, "*********** Results DO NOT compare ********** \n");
		ErrorCount++ ;
	}

	{
		int i;

		printf ("Expected Result\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				destAddress[i+0],
				destAddress[i+1],
				destAddress[i+2],
				destAddress[i+3],
				destAddress[i+4],
				destAddress[i+5],
				destAddress[i+6],
				destAddress[i+7]);
		}	
		printf ("Got\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				result[i+0],
				result[i+1],
				result[i+2],
				result[i+3],
				result[i+4],
				result[i+5],
				result[i+6],
				result[i+7]);
		}
		printf ("\n\n");
	}
}

void MspSecTest3DES()
{
	U8                  sourceAddress[64] = "Mary had a little lamb, its.";
	U8                  destAddress[64];
	U8                  result[64];
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32                 mode;
	U32                 retStatus;

	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K1_ENC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_DEC ;

	keysValue.Key3High = 0x12131415;
	keysValue.Key3Low =  0x16171819;
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB | DMC_3DES ;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	keysValue.Key1High = 0x12131415;
	keysValue.Key1Low =  0x16171819;
	keysValue.Key1Mode = DMC_K1_DEC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_ENC ;

	keysValue.Key3High = 0x01020304;
	keysValue.Key3Low =  0x05060708; 
	keysValue.Key3Mode = DMC_K3_DEC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB | DMC_3DES | DMC_MOD_DEC ;

	retStatus = MspSecDESXncryptFast (destAddress,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	if (memcmp (sourceAddress, result, 32) == 0)
	{
		fprintf (stdout, "results compare\n");
	}
	else
	{
		fprintf (stderr, "*********** Results DO NOT compare ********** \n");
		ErrorCount++ ;
	}

	{
		int i;

		printf ("Expected Result\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				sourceAddress[i+0],
				sourceAddress[i+1],
				sourceAddress[i+2],
				sourceAddress[i+3],
				sourceAddress[i+4],
				sourceAddress[i+5],
				sourceAddress[i+6],
				sourceAddress[i+7]);
		}	
		printf ("Got\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				result[i+0],
				result[i+1],
				result[i+2],
				result[i+3],
				result[i+4],
				result[i+5],
				result[i+6],
				result[i+7]);
			
		}
		printf ("\n\n");
	}
}

void MspSecTestDES()
{
	U8                  sourceAddress[64] = "Mary had a little lamb, its.";
	U8                  destAddress[64];
	U8                  result[64];
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32                 mode;
	U32                 retStatus;

	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K1_ENC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_DEC ;

	keysValue.Key3High = 0x12131415;
	keysValue.Key3Low =  0x16171819;
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB ;

	retStatus = MspSecDESXncryptFast (sourceAddress,
					  destAddress,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	keysValue.Key1High = 0x01020304;
	keysValue.Key1Low =  0x05060708; 
	keysValue.Key1Mode = DMC_K3_DEC ;

	keysValue.Key2High = 0x090a0b0c;
	keysValue.Key2Low = 0x0e0f1011;
	keysValue.Key2Mode = DMC_K2_ENC ;

	keysValue.Key3High = 0x01020304;
	keysValue.Key3Low =  0x05060708; 
	keysValue.Key3Mode = DMC_K3_DEC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode =  DMC_MOD_ECB | DMC_MOD_DEC ;

	retStatus = MspSecDESXncryptFast (destAddress,
					  result,
					  &keysValue,
					  &IV,
					  32,
					  mode);

	if (retStatus) 
	{
		fprintf (stderr, "Bad Enc: retStatus = %d\n", retStatus);
		ErrorCount++ ;
		return ;
	}

	if (memcmp (sourceAddress, result, 32) == 0)
	{
		fprintf (stdout, "results compare\n");
	}
	else
	{
		fprintf (stderr, "*********** Results DO NOT compare ********** \n");
		ErrorCount++ ;
	}

	{
		int i;

		printf ("Expected Result\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				sourceAddress[i+0],
				sourceAddress[i+1],
				sourceAddress[i+2],
				sourceAddress[i+3],
				sourceAddress[i+4],
				sourceAddress[i+5],
				sourceAddress[i+6],
				sourceAddress[i+7]);
		}	
		printf ("Got\n");
		for (i = 0; i < 32; i+=8)
		{
			printf ("%02X %02X %02X %02X %02X %02X %02X %02X\n",
				result[i+0],
				result[i+1],
				result[i+2],
				result[i+3],
				result[i+4],
				result[i+5],
				result[i+6],
				result[i+7]);
			
		}
		printf ("\n\n");
	}
}

/******************************************************************/
/*                                                                */
/* MspSecTest3DesJam                                              */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine calls a 3DES CBC encryption repeatedly until      */
/* 300 MBits have been pushed through.  The NumInChain parameter  */
/* determines the number of chunks fed through the Des Dma engine */
/* per interrupt.  The performance is printed and measured in     */
/* seconds.                                                       */
/*                                                                */
/* PARAMETERS:                                                    */
/*              NumberInChain-  Number of 2048 byte chunks        */
/*                              in each chain that's encrypted    */
/*                              The range is {1,2,4, or 8}        */
/*                                                                */
/******************************************************************/
void MspSecTest3DesJam(U32 NumInChain)
{
	U32                 callerRefId;
	U8                  *sourceAddresses[32];
	U8                  *destAddresses[32];
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 lengthPerInt;
	U8                  *tempAddrPtr;
	U32                 retStatus;
	U32                 chainId;
	U32                 j;
	int                 tStat;
	U32                 numEncNeeded;
	U32                 deadChains[20];
	U32                 deadChainsTop = 0;
	U32                 totalBuildFail = 0;
	U32                 failedBuildChain = 0;
	U32                 numSerErrors = 0;
	U32                 numErrorStatusHoldups = 0;

	if (!(NumInChain))
		NumInChain = 1;

	/* tStat = MspSecCreateTimer(); */

	SecTestJamTotalCompErrors = 0;
	SecTestJamErrorStatus = 0;
	SecTestJamTotalComp = 0;
	SecTestJamTDS = 0;

	for (i=0;i<20;i++) 
	{
		SecTestJamDSA[i].Status = 0;
		SecTestJamDSA[i].Number = 0;
	}

	for (j=0;j < NumInChain;j++) 
	{
		destAddresses[j] = (U8 *)malloc(2048);
		if (!(destAddresses[j]))
			printf("-------------Malloc failed\n");
		sourceAddresses[j] = (U8 *)malloc(2048);
		tempAddrPtr = sourceAddresses[j];
		if (!(tempAddrPtr))
			printf("-------------Malloc failed\n");
		for (i=0;i<2048;i++)
			*tempAddrPtr++ = (i & 0xFF);
	}
         
	keysValue.Key1High = 0xecb10001; 
	keysValue.Key1Low = 0x134efffe; 
	keysValue.Key1Mode = DMC_K1_ENC ;
	keysValue.Key2High = 0xecb10001; 
	keysValue.Key2Low = 0x134efffe; 
	keysValue.Key2Mode = DMC_K2_ENC ;
	keysValue.Key3High = 0xecb10001; 
	keysValue.Key3Low = 0x134efffe; 
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_CBC ;

	lengthPerInt = 2048 * NumInChain;
	numEncNeeded = 39321600 / lengthPerInt;
	printf("\n");
	printf("SEC JAM TEST:  Number completions needed:  %d\n",numEncNeeded);
	printf("SEC JAM TEST:  Length per interrupt:       %d\n",lengthPerInt);
	printf("\n");

	/* JRR-DEBUG */
	printf("about to start test...........\n");

	tStat = MspSecWhatTime();

	callerRefId = (U32) destAddresses[0];
	chainId = 1000;

	if (NumInChain == 1) 
	{
		while (1) 
		{
			callerRefId++;

			retStatus = MspSecDESXncrypt( callerRefId,
						      sourceAddresses[0],
						      destAddresses[0],
						      &keysValue,
						      &IV,
						      2048,
						      mode,
						      SecTest3JamCompFunc);

			if (retStatus) 
			{
				/* JRR-DEBUG */
				/* printf("sererr\n"); */
				numSerErrors++;
			}

			if (SecTestJamErrorStatus) 
			{
				/* JRR-DEBUG */
				/* printf("staterr\n"); */
				numErrorStatusHoldups++;
				SecTestJamErrorStatus = 0;
			}

			if (SecTestJamTotalComp >= numEncNeeded)
				break;

			if ((callerRefId % 1000) == 0) {
				printf("Successful so far:  %d\n",SecTestJamTotalComp);
			}
		}
	} 
	else 
	{
		while (1) 
		{
			/* First clean any chains that may be dead */

#if 0
			if (deadChainsTop) 
			{
				retStatus = MspSecDesCleanChains(deadChains, deadChainsTop);
				if (!(retStatus)) 
				{
					SecTestChainsCleared += deadChainsTop;
					deadChainsTop = 0;
				}
			}
#endif

			chainId++;
			callerRefId = chainId;
			mode = DMC_MOD_CBC | DMC_3DES;

			for (i=0;i<NumInChain;i++) 
			{
				retStatus = MspSecBuildChain(&chainId,
							     2048,
							     sourceAddresses[i],
							     destAddresses[i]);

				if (retStatus) 
				{
					if (i) 
					{
						deadChains[deadChainsTop] = chainId;
						deadChainsTop++;
						if (deadChainsTop > 19) 
						{
							printf("TOO MANY DEAD CHAINS!!!!!\n");
						}
					}
					totalBuildFail++;
					failedBuildChain = 1;
					break;
				}
			}

			if (!(failedBuildChain)) 
			{
				retStatus = MspSecDESXncryptChain( callerRefId,
								   chainId,
								   &keysValue,
								   &IV,
								   mode,
								   SecTest3JamCompFunc);

				if (retStatus) 
				{
					deadChains[deadChainsTop] = chainId;
					deadChainsTop++;
					if (deadChainsTop > 19) 
					{
						printf("TOO MANY DEAD CHAINS!!!!!\n");
					}
					numSerErrors++;
				}

				if (SecTestJamErrorStatus) 
				{
					numErrorStatusHoldups++;
					SecTestJamErrorStatus = 0;
				}

			}
			failedBuildChain = 0;

			if ((callerRefId % 1000) == 0) 
			{
				printf("Successful so far:  %d\n",SecTestJamTotalComp);
			}

			if (SecTestJamTotalComp >= numEncNeeded)
				break;
		}
	}

	tStat = MspSecWhatTime();

	printf("about to clean leftover dead chains-  %d\n",deadChainsTop);

#if 0
	/* Finally, clean any chains that may be dead */
	if (deadChainsTop) {
		retStatus = MspSecDesCleanChains(deadChains, deadChainsTop);
		if (!(retStatus)) {
			SecTestChainsCleared += deadChainsTop;
			deadChainsTop = 0;
		}
	}
#endif

	for (j=0;j < NumInChain;j++) {
		/* tempPtr = (U32)sourceAddresses[j]; */
		/* tempPtr &= ~(0x20000000); */
		/* free((void *)tempPtr); */
		/* tempPtr = (U32)destAddresses[j]; */
		/* tempPtr &= ~(0x20000000); */
		/* free((void *)tempPtr); */
		free((void *)sourceAddresses[j]); 
		free((void *)destAddresses[j]);
	}

	printf("TotalCompletionSuccess :  %d\n",SecTestJamTotalComp);
	printf("TotalCompletionErrors:    %d\n",SecTestJamTotalCompErrors);
	printf("Total SerBuf Errors:      %d\n",numSerErrors);
	printf("Total Build Chain errors: %d\n",totalBuildFail);
	printf("Total Comp Error Holdups: %d\n",numErrorStatusHoldups);
	if (SecTestJamTDS) {
		printf("Error Status:           Returned\n");
		for (i=0;i<SecTestJamTDS;i++) {
			printf("     %d,                    0x%d times\n",
			       SecTestJamDSA[i].Status,
			       SecTestJamDSA[i].Number);
		}
		printf("\n");
	}
	if (SecTestJamTotalCompErrors
	    + numSerErrors
	    + totalBuildFail
	    + numErrorStatusHoldups)
	{
		ErrorCount++ ;
	}
		
}

/******************************************************************/
/*                                                                */
/* MspSecTest3DesChainUnser                                       */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a des chained pass through dma of   */
/* 640 bytes (5 item chain) from a source to a different dest.    */
/* The source and dest addresses are alternated and the pattern   */
/* is also alternated between an ascending and descending count.  */
/* This is repeated for 1000 iterations.                          */
/*                                                                */
/* PARAMETERS:                                                    */
/*                                                                */
/******************************************************************/
void MspSecTest3DesChainUnser()
{
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 j;
	U32                 chainId;
	U8                  *tempAddrPtr;
	U8                  *tempAddrPtr2;
	U32                 retStatus;
	U32                 tempDestLoc;
	U32                 tempSrcLoc;
	U32                 totalErrors = 0;
	U32                 totalSuccess = 0;
    
	keysValue.Key1High = 0xecb10001; 
	keysValue.Key1Low = 0x134efffe; 
	keysValue.Key1Mode = DMC_K1_ENC ;
	keysValue.Key2High = 0xecb10001; 
	keysValue.Key2Low = 0x134efffe; 
	keysValue.Key2Mode = DMC_K2_ENC ;
	keysValue.Key3High = 0xecb10001; 
	keysValue.Key3Low = 0x134efffe; 
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_PT | DMC_3DES ;

	SecTestDestAddr1 = (U8 *)malloc(1000);
	SecTestDestAddr2 = (U8 *)malloc(1000);

	for (j=0;j<1000;j++) 
	{
		if (SecTestFlipMode) 
		{
			tempAddrPtr = SecTestDestAddr1;
			for (i=640;i>0;i--)
				*tempAddrPtr++ = (i & 0xFF);
			SecTestFlipMode = 0;
			sourceAddress = SecTestDestAddr1;
			destAddress = SecTestDestAddr2;
		} 
		else 
		{
			tempAddrPtr = SecTestDestAddr2;
			for (i=0;i<640;i++)
				*tempAddrPtr++ = (i & 0xFF);
			SecTestFlipMode = 1;
			sourceAddress = SecTestDestAddr2;
			destAddress = SecTestDestAddr1;
		}


		tempSrcLoc = (U32)sourceAddress;
		tempDestLoc = (U32)destAddress;

		chainId = 0;
		for (i=0;i<5;i++) 
		{
			MspSecBuildChain( &chainId, 128,
					  sourceAddress,
					  destAddress);
			tempSrcLoc += 128;
			tempDestLoc += 128;
			sourceAddress = (U8 *)tempSrcLoc;
			destAddress = (U8 *)tempDestLoc;
		}
    
		retStatus = MspSecDESXncryptChainFast ( chainId,
							&keysValue,
							&IV,
							mode);
		if (retStatus)
		{
			printf ("retStatus = %d\n", retStatus);
			ErrorCount++ ;
			break;
		}

		tempAddrPtr = SecTestDestAddr1;
		tempAddrPtr2 = SecTestDestAddr2;

		for (i=0;i<640;i++) 
		{
			if (*tempAddrPtr++ != *tempAddrPtr2++) 
			{
				printf("--------------failed at 0x%x\n",i);
				totalErrors++; 
				break; 
			}
		}
		if (i == 640)
			totalSuccess++; 

	}

	free(SecTestDestAddr1);
	free(SecTestDestAddr2);

	printf("3DesChainUnser Test:  Test completed\n");
	printf("3DesChainUnser Test:  Total Comp Succ- %d\n",totalSuccess);
	printf("3DesChainUnser Test:  Total Comp Err-  %d\n",totalErrors);

	if (totalErrors)
		ErrorCount++ ;
}

/******************************************************************/
/*                                                                */
/* MspSecTest3DesUnserJam                                         */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine calls a 3DES CBC encryption repeatedly until      */
/* 300 MBits have been pushed through the unserialized interface. */
/* The performance is printed and measured in seconds.            */
/*                                                                */
/* PARAMETERS:                                                    */
/*              EncSize-  Size of each encryption                 */
/*                        It must be a multiple of 8              */
/*                                                                */
/******************************************************************/
void MspSecTest3DesUnserJam(U32 EncSize)
{
	U32                 callerRefId;
	U8                  *sourceAddress;
	U8                  *destAddress;
	msp_sec_3des_key    keysValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 i;
	U32                 lengthPerEnc;
	U8                  *tempAddrPtr;
	U32                 retStatus;
	struct timeval      tv1, tv2;
	U32                 numEncNeeded;
	U32                 numRetErrors = 0;

	if (EncSize < 64)
		EncSize = 64;

#if 0
	tStat = MspSecCreateTimer();
#endif

	SecTestJamTotalComp = 0;

	for (i=0;i<20;i++) {
		SecTestJamDSA[i].Status = 0;
		SecTestJamDSA[i].Number = 0;
	}

	destAddress = (U8 *)memalign(MSP5000_CACHE_DATA_LINE_SIZE,
				     EncSize);
	if (!(destAddress))
		printf("-------------Malloc failed\n");
	sourceAddress = (U8 *)memalign(MSP5000_CACHE_DATA_LINE_SIZE,
				       EncSize);
	tempAddrPtr = sourceAddress;
	if (!(tempAddrPtr))
		printf("-------------Malloc failed\n");
	for (i=0;i<EncSize;i++)
		*tempAddrPtr++ = (i & 0xFF);
         
	keysValue.Key1High = 0xecb10001; 
	keysValue.Key1Low = 0x134efffe; 
	keysValue.Key1Mode = DMC_K1_ENC ;
	keysValue.Key2High = 0xecb10001; 
	keysValue.Key2Low = 0x134efffe; 
	keysValue.Key2Mode = DMC_K2_ENC ;
	keysValue.Key3High = 0xecb10001; 
	keysValue.Key3Low = 0x134efffe; 
	keysValue.Key3Mode = DMC_K3_ENC ;

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_CBC | DMC_3DES;

	lengthPerEnc = EncSize;
#if 0
	numEncNeeded = 39321600 / lengthPerEnc;
#endif
	numEncNeeded = 3932160 / lengthPerEnc;
	printf("\n");
	printf("SEC UNSER JAM TEST:  Number completions needed:  %d\n",numEncNeeded);
	printf("SEC UNSER JAM TEST:  Length per encryption:  %d\n",lengthPerEnc);
	printf("\n");

	/* JRR-DEBUG */
	printf("about to start test...........\n");

#if 0
 	tStat = MspSecWhatTime();
#endif
	gettimeofday(&tv1, 0) ;

	callerRefId = 1000;

	while (1) {
		callerRefId++;

		retStatus = MspSecDESXncryptFast (sourceAddress,
						  destAddress,
						  &keysValue,
						  &IV,
						  lengthPerEnc,
						  mode);

		if (retStatus) {
			/* JRR-DEBUG */
			/* printf("Reterr\n"); */
			numRetErrors++;
		} else {
			SecTestJamTotalComp++;
		}

		if (SecTestJamTotalComp >= numEncNeeded)
			break;

		if ((callerRefId % 1000) == 0) {
#if 0         
			printf("Successful so far:  %d\n",SecTestJamTotalComp);
#endif         
		}
	}
    
	gettimeofday(&tv2, 0) ;
	printf ("Total Time = %ld\n",
		(tv2.tv_sec * 1000 + tv2.tv_usec) -
		(tv1.tv_sec * 1000 + tv1.tv_usec));

#if 0
	tStat = MspSecWhatTime();
#endif
    
	free((void *)sourceAddress);
	free((void *)destAddress);

	printf("TotalCompletionSuccess :  %d\n",SecTestJamTotalComp);
	printf("Total Return Errors:      %d\n",numRetErrors);

	if (numRetErrors)
		ErrorCount++ ;
}


/******************************************************************/
/*                                                                */
/* MspSecTestSpawn3Jam                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine spawns the task MspSecTest3DesJam at a priority   */
/* level equal to that of jobs added through MSP_JOB_ADD.         */
/*                                                                */
/* PARAMETERS:                                                    */
/*              NumberInChain-  Number of 2048 byte chunks        */
/*                              in each chain that's encrypted    */
/*                              The range is {1,2,4, or 8}        */
/*                                                                */
/******************************************************************/
void MspSecTestSpawn3Jam(U32     NumberInChain)
{

	/* taskSpawn("3JamFunc", 80, 0, 4096, (FUNCPTR)MspSecTest3DesJam, 
	   NumberInChain, 0, 0, 0, 0, 0, 0, 0, 0, 0); */
}

/******************************************************************/
/*                                                                */
/* MspSecTestSpawn3UJam                                           */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine spawns the task MspSecTest3DesUnserJam at a       */
/* priority level equal to that of jobs added through MSP_JOB_ADD */
/*                                                                */
/* PARAMETERS:                                                    */
/*              EncSize-  Size of each encryption                 */
/*                        It must be a multiple of 8              */
/*                                                                */
/******************************************************************/
void MspSecTestSpawn3UJam(U32     EncSize)
{

	/* taskSpawn("3JamUFunc", 80, 0, 4096, (FUNCPTR)MspSecTest3DesUnserJam,
	   EncSize, 0, 0, 0, 0, 0, 0, 0, 0, 0); */
}

/******************************************************************/
/*                                                                */
/* MspSecTestMd5Blk                                               */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests MspSecHshMD5Blk functionality.              */
/*                                                                */
/* PARAMETERS:                                                    */
/*             none                                               */
/*                                                                */
/******************************************************************/
void MspSecTestMd5Blk()
{

	U8                          *sourceAddress;
	U8                          destAddress[HSH_LEN_MD5];
	U32 			    length;
	msp_sec_hsh_chaining_vars   chainingVars;
	U32                         i;
	U8                          *tempAddrPtr;
	U32                         retStatus;
       
	sourceAddress = SrcData9;

	length = 64;

	chainingVars.ChainVarA = 0x0;
	chainingVars.ChainVarB = 0x22222222;
	chainingVars.ChainVarC = 0x23232323;
	chainingVars.ChainVarD = 0x24242424;
	chainingVars.ChainVarE = 0x25252525;

	printf("Simple Md5 test\n");

	retStatus = MspSecHshBlk ( sourceAddress,
				   destAddress,
				   length,
				   &chainingVars,
				   HMC_MD5);


	printf("Return value:  %d\n",retStatus);

	printf("\n");
	printf("SrcAddress:\n");
	tempAddrPtr = (U8 *)sourceAddress;
	for (i=0;i<64;i++) {
		printf("   0x%x",*tempAddrPtr++);
		if ((i % 8) == 7)
			printf("\n");
	}

	printf("\n");
	printf("HashResult:\n");
	for (i = 0; i < HSH_LEN_MD5; i+=4)
	{
		printf("  %02X %02X %02X %02X\n",
		       destAddress[i+0], 
		       destAddress[i+1], 
		       destAddress[i+2],
		       destAddress[i+3]);
	}
	printf("\n");

	printf("\n");
	printf("ExpData:\n");
	tempAddrPtr = ExpData5;
	for (i=0;i<HSH_LEN_MD5;i++) {
		printf("   0x%x,",*tempAddrPtr++);
		if ((i % 4) == 3)
			printf("\n");
	}
	printf("\n");

	if (memcmp(destAddress, ExpData5, HSH_LEN_MD5))
	{
		printf("*+*+*+*+* Compare failed\n") ;
		ErrorCount++ ;
	}
}

/******************************************************************/
/*                                                                */
/* MspSecTestSha1Blk                                              */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests MspSecHshSha1Blk functionality.             */
/*                                                                */
/* PARAMETERS:                                                    */
/*             none                                               */
/*                                                                */
/******************************************************************/
void MspSecTestSha1Blk()
{

	U8                          *sourceAddress;
	U8                          destAddress[HSH_LEN_SHA1];
	U32 			    length;
	msp_sec_hsh_chaining_vars   chainingVars;
	U32                         i;
	U8                          *tempAddrPtr;
	U32                         retStatus;
       
	sourceAddress = SrcData10;

	length = 64;

	chainingVars.ChainVarA = 0x0;
	chainingVars.ChainVarB = 0x22222222;
	chainingVars.ChainVarC = 0x23232323;
	chainingVars.ChainVarD = 0x24242424;
	chainingVars.ChainVarE = 0x25252525;

	printf("Simple Sha1 test\n");

	memset(destAddress, 0, HSH_LEN_SHA1) ;

	destAddress[16]++ ;
	printf("HashResult before hash:\n");
	for (i = 0; i < HSH_LEN_SHA1; i+=4)
	{
		printf("  %02X %02X %02X %02X\n",
		       destAddress[i+0], 
		       destAddress[i+1], 
		       destAddress[i+2],
		       destAddress[i+3]);
	}
	printf("\n");


	retStatus = MspSecHshBlk (	sourceAddress,
					destAddress,
					length,
					&chainingVars,
					HMC_SHA1);


	printf("Return value:  %d\n",retStatus);

	printf("\n");
	printf("SrcAddress:\n");
	tempAddrPtr = (U8 *)sourceAddress;
	for (i=0;i<64;i++) {
		printf("   0x%x",*tempAddrPtr++);
		if ((i % 8) == 7)
			printf("\n");
	}

	printf("\n");
	printf("HashResult:\n");
	for (i = 0; i < HSH_LEN_SHA1; i+=4)
	{
		printf("  %02X %02X %02X %02X\n",
		       destAddress[i+0], 
		       destAddress[i+1], 
		       destAddress[i+2],
		       destAddress[i+3]);
	}
	printf("\n");

	printf("\n");
	printf("ExpData:\n");
	tempAddrPtr = ExpData6;
	for (i=0;i<20;i++) {
		printf("   0x%x,",*tempAddrPtr++);
		if ((i % 4) == 3)
			printf("\n");
	}
	printf("\n");
	if (memcmp(destAddress, ExpData6, HSH_LEN_SHA1))
	{
		printf("*+*+*+*+* Compare failed\n") ;
		ErrorCount++ ;
	}
}

/******************************************************************/
/*                                                                */
/* SecTestHshCompleteFunc                                         */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestHshSer in its      */
/* serialized calls.  This function alternates between            */
/* comparing results to ExpData5 and ExpData6.                    */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Not used                            */
/*                                                                */
/*              hashResult-  Pointer to structure holding result  */
/*                                                                */
/*              status-  Status of hash                           */
/*                                                                */
/******************************************************************/
void SecTestHshCompleteFunc (U32 callerRefId, U32 status)
{
	U32         i;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;
	U32	    size;

#ifdef SEC_LOUD_DEBUG
	printf("Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
#ifdef SEC_LOUD_DEBUG
		printf("Completion function -  Error:  %d\n",status);
#endif      
	} 
	else 
	{
		if (SecTestFlipMode) 
		{
			expAddrPtr = ExpData6;
			size = HSH_LEN_SHA1;
			SecTestFlipMode = 0;
		} 
		else 
		{
			expAddrPtr = ExpData5;
			size = HSH_LEN_MD5;
			SecTestFlipMode = 1;
		}

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<size;i++) {
			if (*tempAddrPtr++ != *tempAddrPtr2++) {
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

		if (SecTestCompareError)
		{
			tempAddrPtr = (U8 *)callerRefId;
			tempAddrPtr2 = expAddrPtr;
			printf ("size = %d, pos = %d, got = %02X, exp = %02X\n", 
				size, i, tempAddrPtr[i], expAddrPtr[i]);
		}
		else
		{
			SecTestTotalCompletionSuccess++;
		}
	}
}

/******************************************************************/
/*                                                                */
/* MspSecTestHshSer                                               */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling a md5 hashing immediately followed  */
/* by a second sha1 hashing.  These are non-blocking		  */
/* calls where results are compared for accuracy.                 */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestHshSer()
{

	U32                         callerRefId;
	U8                          *sourceAddress;
	U8                          destAddressSHA1[HSH_LEN_SHA1];
	U8                          destAddressMD5[HSH_LEN_MD5];
	msp_sec_hsh_chaining_vars   chainingVars;
	U32 			    length;
	U32                         i;
	U32                         retStatus;

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestCompareError = 0;
	SecTestFlipMode = 0;

	length = 64;

	chainingVars.ChainVarA = 0x0;
	chainingVars.ChainVarB = 0x22222222;
	chainingVars.ChainVarC = 0x23232323;
	chainingVars.ChainVarD = 0x24242424;
	chainingVars.ChainVarE = 0x25252525;

	for (i=0;i<1000;i++) 
	{
		if (SecTestCompareError) 
		{
			break;
		}

		sourceAddress = SrcData9;

		callerRefId = (U32) destAddressMD5;

#ifdef SEC_LOUD_DEBUG
		printf("Md5 test\n");

		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		retStatus = MspSecHsh ( callerRefId,
                                        sourceAddress,
					destAddressMD5,
					length,
					&chainingVars,
					HMC_MD5 ,
                                        SecTestHshCompleteFunc);


		if (retStatus != MSP_SUCCESS)
			printf ("returnStatus = %x\n", retStatus);

		sourceAddress = SrcData10;

#ifdef SEC_LOUD_DEBUG
		printf("Sha1 test\n");
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		callerRefId = (U32) destAddressSHA1;
		retStatus = MspSecHsh ( callerRefId,
					sourceAddress,
					destAddressSHA1,
					length,
					&chainingVars,
					HMC_SHA1 ,
					SecTestHshCompleteFunc);
		if (retStatus != MSP_SUCCESS)
			printf ("returnStatus = %x\n", retStatus);

	}

	if (SecTestCompareError) 
	{
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess :  %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:    %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:     %d\n",SecTestTotalErrors);

	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;
}

/******************************************************************/
/*                                                                */
/* SecTestHshChainCompleteFunc                                    */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestHshChainSer in     */
/* its serialized calls.  This function alternates between        */
/* comparing results to ExpData7 and ExpData8.                    */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Not used                            */
/*                                                                */
/*              hashResult-  Pointer to structure holding result  */
/*                                                                */
/*              status-  Status of hash                           */
/*                                                                */
/******************************************************************/
void SecTestHshChainCompleteFunc(U32                 callerRefId,
                                 U32                 status)
{
	U32         i;
	U8          *tempAddrPtr;
	U8          *tempAddrPtr2;
	U8          *expAddrPtr;
	U32	    size;

#ifdef SEC_LOUD_DEBUG
	printf("Complete function called\n");
	printf("  CallerRefId:  0x%x\n",callerRefId);
	printf("  Hash Result addr:  0x%x\n",(U32)callerRefId);
	printf("  Return value:  0x%d\n",status);
#endif

	if (status) 
	{
		SecTestTotalCompletionErrors++;
		printf("Completion function -  Error:  %d\n",status);
	} 
	else 
	{

		if (SecTestFlipMode) {
			expAddrPtr = ExpData8;
			size = HSH_LEN_SHA1;
			SecTestFlipMode = 0;
		} 
		else 
		{
			expAddrPtr = ExpData7;
			size = HSH_LEN_MD5;
			SecTestFlipMode = 1;
		}

		/* Compare results */
		tempAddrPtr = (U8 *)callerRefId;
		tempAddrPtr2 = expAddrPtr;
		for (i=0;i<size;i++) {
			if (*tempAddrPtr++ != *tempAddrPtr2++) {
				SecTestCompareError = 1;
				SecTestTotalErrors++;
				break;
			}
		}

		if (SecTestCompareError)
		{
			tempAddrPtr = (U8 *)callerRefId;
			tempAddrPtr2 = expAddrPtr;
			printf ("size = %d, pos = %d, got = %02X, exp = %02X\n", 
				size, i, tempAddrPtr[i], expAddrPtr[i]);
		}
		else
		{
			SecTestTotalCompletionSuccess++;
		}
#if 0
#ifdef SEC_LOUD_DEBUG
		printf("\n");
		printf("HashResult:\n");
		printf("  Hash159to128:  0x%x\n",hashResult->Hsh159to128);
		printf("  Hash127to96:  0x%x\n",hashResult->Hsh127to96);
		printf("  Hash95to64:  0x%x\n",hashResult->Hsh95to64);
		printf("  Hash63to32:  0x%x\n",hashResult->Hsh63to32);
		printf("  Hash31to0:  0x%x\n",hashResult->Hsh31to0);
		printf("\n");

		tempAddrPtr = expAddrPtr;
		printf("\n");
		printf("ExpData:\n");
		for (i=0;i<20;i++) {
			printf("   0x%x,",*tempAddrPtr++);
			if ((i % 4) == 3)
				printf("\n");
		}
		printf("\n");
#endif
#endif
	}
}

/******************************************************************/
/*                                                                */
/* MspSecTestHMACChains                                           */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests HMAC vectors for accuracy                   */
/*. All results are compared for accuracy.            		  */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestHMACChains()
{
	U32		retStatus;
	int		i, j;
	int		compareSize;
	int		error;
	U32		typeOfHash;
	U32		destAddress[5];
	U32		*yyy;
	char		*p_hashname;

	for (i = 0 ; i < 5 ; i++) destAddress[i] = 0 ;
	printf("destAddress is %08x\n", (int)destAddress) ;

	i = 0;
	while (hmacVectors2Test[i].plainText != NULL)
	{
		if (hmacVectors2Test[i].type == HMAC_MD5)
		{
			typeOfHash = HMC_MD5;
			compareSize = 16;
			p_hashname = "HMC_MD5";
		}
		else
		{
			typeOfHash = HMC_SHA1;
			compareSize = 20;
			p_hashname = "HMC_SHA1";
		}

		printf ("MspSecTestHMACChains: plainTest = %02X%02X%02X%02X\n",
			(U8) hmacVectors2Test[i].plainText[0],
			(U8) hmacVectors2Test[i].plainText[1],
			(U8) hmacVectors2Test[i].plainText[2],
			(U8) hmacVectors2Test[i].plainText[3]);

		printf ("MspSecTestHMACChains: key = %02X%02X%02X%02X\n",
			(U8) hmacVectors2Test[i].key[0],
			(U8) hmacVectors2Test[i].key[1],
			(U8) hmacVectors2Test[i].key[2],
			(U8) hmacVectors2Test[i].key[3]);

		printf ("typeOfHash = %s\n", p_hashname);
		printf ("compareSize = %d\n", compareSize);

		retStatus =  MspSecHshHMACFast (hmacVectors2Test[i].plainText,
						(U8 *) destAddress,
						hmacVectors2Test[i].size,
						NULL,
						hmacVectors2Test[i].keyLength,
						hmacVectors2Test[i].key,
						typeOfHash);

		if (retStatus != MSP_SUCCESS)
		{
			printf ("MspSecHshHMACFast returned error %d\n",
				retStatus);
			break;
		}
		
		yyy =  hmacVectors2Test[i].result;
		error = 0;
		{
			volatile U8 *p_expected, *p_actual;

			p_expected = (U8 *) yyy;
			p_actual = (U8 *) destAddress;

			for (j = 0; j < compareSize; j++)
			{
				if (p_actual[j] != p_expected[j])
				{
					printf ("p_actual [%d]= %02X, p_expected [%d]= %02X\n", 
						j, p_actual[j], j, p_expected[j]);
					error = j+1;
					break;
				}
			}
		}

		if (error)
		{
			printf ("results differ at %d\n", error-1);
 			printf ("typeOfHash = %08X\n", typeOfHash); 
			printf ("compareSize = %d\n", compareSize);
			printf ("Vectors2Test[i].size = %d\n",  hmacVectors2Test[i].size);
			printf ("destAddress  = %08X %08X %08X %08X\n",  
				destAddress[0],
				destAddress[1],
				destAddress[2],
				destAddress[3]);

			printf ("VectAddress  = %08X %08X %08X %08X\n",  
				yyy[0],
				yyy[0],
				yyy[2],
				yyy[3]);

			printf ("Result %d does not compare\n", i);
			/* break; */
			ErrorCount ++ ;
		}
		else
		{
			printf ("*********** RESULT %d is GOOD ************\n",
				i);
		}

		i++;
	}
}
/******************************************************************/
/*                                                                */
/* MspSecTestHshChains                                            */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests hash vectors for accuracy			  */
/*. All results are compared for accuracy.            		  */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestHshChains()
{
	U32     	retStatus;
	int		i, j;
	int		compareSize;
	int		error;
	U32		typeOfHash;
	U32		destAddress[5];
	U32		*yyy;
	char		*p_hashname;

	i = 0;
	while (Vectors2Test[i].plainText != NULL)
	{
		/* JRR-DEBUG */
		printf("JRR size: %d\n",Vectors2Test[i].size);

		if (Vectors2Test[i].type == MD5)
		{
			typeOfHash = HMC_MD5;
			compareSize = 16;
			p_hashname = "HMC_MD5";
		}
		else
		{
			typeOfHash = HMC_SHA1;
			compareSize = 20;
			p_hashname = "HMC_SHA1";
		}

		printf ("MspSecTestHshChains: plainTest = %02X%02X%02X%02X\n",
			(U8) Vectors2Test[i].plainText[0],
			(U8) Vectors2Test[i].plainText[1],
			(U8) Vectors2Test[i].plainText[2],
			(U8) Vectors2Test[i].plainText[3]);

		printf ("typeOfHash = %s\n", p_hashname);
		printf ("compareSize = %d\n", compareSize);

		retStatus = MspSecHshFast (Vectors2Test[i].plainText,
					   (U8 *) destAddress,
					   Vectors2Test[i].size,
					   NULL,
					   typeOfHash | MSP_SEC_DO_PADDING);


		if (retStatus != MSP_SUCCESS)
		{
			printf ("MspSecHshChainBlk returned error %d\n",
				retStatus);
			break;
		}
		
		yyy = (U32 *) Vectors2Test[i].result;
		error = 0;
		{
			volatile U8 *p_expected, *p_actual;

			p_expected = (U8 *) Vectors2Test[i].result;
			p_actual = (U8 *) destAddress;

			for (j = 0; j < compareSize; j++)
			{
				if (p_actual[j] != p_expected[j])
				{
					printf ("p_actual [%d]= %02X, p_expected [%d]= %02X\n", 
						j, p_actual[j], j, p_expected[j]);
					error = j+1;
					break;
				}
			}
		}

		if (error)
		{
			printf ("results differ at %d\n", error-1);
 			printf ("typeOfHash = %08X\n", typeOfHash); 
			printf ("compareSize = %d\n", compareSize);
			printf ("Vectors2Test[i].size = %d\n",  Vectors2Test[i].size);
			printf ("destAddress  = %08X %08X %08X %08X\n",  
				destAddress[0],
				destAddress[1],
				destAddress[2],
				destAddress[3]);

			printf ("VectAddress  = %08X %08X %08X %08X\n",  
				yyy[0],
				yyy[0],
				yyy[2],
				yyy[3]);

			printf ("Result %d does not compare\n", i);
			ErrorCount++ ;

			//break;
		}
		else
		{
			printf ("*********** RESULT %d is GOOD ************\n", i);
		}

		i++;
	}
}

/******************************************************************/
/*                                                                */
/* MspSecTestHshChainSer                                          */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine tests calling an Md5 chained serialized hash and  */
/* followed by a Sha1 chained serialized hash for a thousand      */
/* iterations.  All results are compared for accuracy.            */
/*                                                                */
/* PARAMETERS:                                                    */
/*              none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestHshChainSer()
{
	U32                         callerRefId;
	U8                          *sourceAddress;
	U8                          *destAddressMD5;
	U8                          *destAddressSHA1;
	msp_sec_hsh_chaining_vars   chainingVars;
	U32                         i;
	U32                         retStatus;
	U32                         chainId;
	struct timeval              tv1, tv2 ;

	destAddressMD5 = (void *)malloc(128);
	destAddressSHA1 = (void *)malloc(128);

	SecTestTotalCompletionSuccess = 0;
	SecTestTotalCompletionErrors = 0;
	SecTestTotalErrors = 0;
	SecTestCompareError = 0;

	chainingVars.ChainVarA = 0x41414141;
	chainingVars.ChainVarB = 0x42424242;
	chainingVars.ChainVarC = 0x43434343;
	chainingVars.ChainVarD = 0x44444444;
	chainingVars.ChainVarE = 0x45454545;

	gettimeofday(&tv1, NULL) ;

	for (i=0;i<100000;i++) 
	{
		if (SecTestCompareError) 
		{
			break;
		}

#ifdef SEC_LOUD_DEBUG
		printf("Hash Chain test\n");
		printf("Calling build chain\n");
#endif
		chainId = 0;
		callerRefId = (U32) destAddressMD5;
        
#if 0
		sourceAddress = SrcData11;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressMD5);
#else
		/* use evil chains */
		sourceAddress = SrcData11;
		MspSecBuildChain(&chainId, 191, sourceAddress, destAddressMD5);

		sourceAddress = SrcData11 + 191;
		MspSecBuildChain(&chainId, 192-191, sourceAddress, destAddressMD5);
#endif

#if 0
		sourceAddress = SrcData12;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressMD5);
#else
		/* use evil chains */
		sourceAddress = SrcData12;
		MspSecBuildChain(&chainId, 3, sourceAddress, destAddressMD5);

		sourceAddress = SrcData12 + 3 ;
		MspSecBuildChain(&chainId, 192-3, sourceAddress, destAddressMD5);
#endif		

		sourceAddress = SrcData13;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressMD5);

#ifdef SEC_LOUD_DEBUG
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		retStatus = MspSecHshChain ( callerRefId,
					     chainId,
					     &chainingVars,
					     HMC_MD5,
					     SecTestHshChainCompleteFunc);

		if (retStatus != MSP_SUCCESS)
			printf ("retStatus = %d\n", retStatus);

#ifdef SEC_LOUD_DEBUG
		printf("Calling build chain\n");
#endif
		chainId = 0;
		callerRefId = (U32) destAddressSHA1;
        
#if 0
		sourceAddress = SrcData11;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressSHA1);
#else
		sourceAddress = SrcData11;
		MspSecBuildChain(&chainId, 12, sourceAddress, destAddressSHA1);

		sourceAddress = SrcData11 + 12;
		MspSecBuildChain(&chainId, 192-12, sourceAddress, destAddressSHA1);
#endif

#if 0
		sourceAddress = SrcData12;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressSHA1);
#else
		sourceAddress = SrcData12;
		MspSecBuildChain(&chainId, 61, sourceAddress, destAddressSHA1);

		sourceAddress = SrcData12+61;
		MspSecBuildChain(&chainId, 192-61, sourceAddress, destAddressSHA1);
#endif
		/* The pattern is exactly the same except for   */
		/* the padding.  That's why SrcData11 and 12    */
		/* are common but SrcData14 and 13 are dif'nt   */
#if 0
		sourceAddress = SrcData14;
		MspSecBuildChain(&chainId, 192, sourceAddress, destAddressSHA1);
#else
		sourceAddress = SrcData14;
		MspSecBuildChain(&chainId, 19, sourceAddress, destAddressSHA1);

		sourceAddress = SrcData14+19;
		MspSecBuildChain(&chainId, 63, sourceAddress, destAddressSHA1);

		sourceAddress = SrcData14+19+63;
		MspSecBuildChain(&chainId, 192-19-63, sourceAddress, destAddressSHA1);
#endif
		
#ifdef SEC_LOUD_DEBUG
		printf("CallerRefId passed in is 0x%x\n",callerRefId);
		printf("About to call serialized version\n");
#endif

		retStatus = MspSecHshChain (	callerRefId,
						chainId,
						&chainingVars,
						HMC_SHA1,
						SecTestHshChainCompleteFunc);


		if (retStatus != MSP_SUCCESS)
			printf ("retStatus = %d\n", retStatus);

	}

	gettimeofday(&tv2, NULL) ;

	tv2.tv_sec -= tv1.tv_sec ;
	tv2.tv_usec -= tv1.tv_usec ;
	if (tv2.tv_usec < 0)
	{
		tv2.tv_usec += 1000000 ;
		tv2.tv_sec -= 1 ;
	}

	if (SecTestCompareError) {
		printf("-------------Compare Error-------------\n");
	}
	printf("TotalCompletionSuccess :  %d\n",SecTestTotalCompletionSuccess);
	printf("TotalCompletionErrors:    %d\n",SecTestTotalCompletionErrors);
	printf("Total Compare Errors:     %d\n",SecTestTotalErrors);
	printf("Total time in ms:         %ld\n", (tv2.tv_sec * 1000
						  + tv2.tv_usec / 1000) ) ;
	
	if (SecTestTotalCompletionErrors + SecTestTotalErrors)
		ErrorCount++ ;

	free (destAddressMD5);
	free (destAddressSHA1);
}


/******************************************************************/
/*                                                                */
/* SecTestDuetLoadComplete                                        */
/*                                                                */
/* DESCRIPTION:                                                   */
/* Completion function registered by MspSecTestEcbDesSer in each  */
/* of its MspSecDesEncrypt and MspSecDesDecrypt calls.  This      */
/* function alternates between comparing results to ExpData1 and  */
/* ExpData2.                                                      */
/*                                                                */
/* PARAMETERS:                                                    */
/*              callerRefId-  Used to hold destination addr       */
/*                                                                */
/*              status-  Status of encryption/decryption          */
/*                                                                */
/******************************************************************/
void SecTestDuetLoadComplete(U32 callerRefId, U32 status)
{
	(*DuetCompleteFunc)();
}

/******************************************************************/
/*                                                                */
/* MspSecTestDuetLoad                                             */
/*                                                                */
/* DESCRIPTION:                                                   */
/* This routine was used in Duet Load testing.                    */
/*                                                                */
/* PARAMETERS:  none                                              */
/*                                                                */
/******************************************************************/
void MspSecTestDuetLoad(U8  *SrcAddr, U8 *DstAddr,
                        U32 Length,
                        void    (*completeFunc) ())
{
	U8                  *sourceAddress;
	U8  		    *destAddress;
	msp_sec_3des_key    keyValue;
	msp_sec_des_iv	    IV;
	U32		    mode;
	U32                 callerRefId;
	U32                 retStatus;

	sourceAddress = SrcAddr;
	destAddress = DstAddr;

	keyValue.Key1High = 0xecb10001; 
	keyValue.Key1Low = 0x134efffe; 

	IV.IVLow = 0x0;
	IV.IVHigh = 0x0;

	mode = DMC_MOD_ECB;

	callerRefId = (U32)completeFunc;

	DuetCompleteFunc = completeFunc;

	retStatus = MspSecDESXncrypt ( callerRefId,
				       sourceAddress,
				       destAddress,
				       &keyValue,
				       &IV,
				       Length,
				       mode,
				       SecTestDuetLoadComplete);

	if (retStatus)
	{
		printf("retStatus = %d\n", retStatus);
	}
}

int gotCall = 0;
int gotDelay = 0;
#define SEC_BUSY	0
#define SEC_DONE	1

volatile U32	secStatus = SEC_DONE;
volatile U32	secCount  = 0;

char *  pBufSec = NULL;
char *  pBufSec2 = NULL;
char *  pBufSec3 = NULL;

#define SEC_TEST_BUF_SIZE	64

void sec_done_cb()
{

	secStatus = SEC_DONE;
	secCount++;
}

void secTest()
{
	int i ;
	static int do_compare = 0 ;

	for( i = 0 ; i < SEC_TEST_BUF_SIZE; i++)
		pBufSec[i] = (char) i ;

	secStatus = SEC_BUSY ;
	
	MspSecTestDuetLoad(pBufSec, pBufSec3, SEC_TEST_BUF_SIZE, sec_done_cb) ;

	while(1)
	{
		if( secStatus == SEC_DONE )
		{
			if ((secCount % 100000) == 0)
				printf ("secCount = %d\n", secCount);

			if (do_compare &&
			    (memcmp(pBufSec2,pBufSec3,SEC_TEST_BUF_SIZE)!=0) )
			{
				printf ("**** COMPARE FAILED %d\n", secCount) ;
				ErrorCount++ ;
			}
			do_compare = 1 ;
			gotCall++;

			/* Start another SEC pass through   */

			memset(pBufSec2, 0, SEC_TEST_BUF_SIZE) ;
			secStatus = SEC_BUSY;
			MspSecTestDuetLoad(pBufSec, pBufSec2, SEC_TEST_BUF_SIZE, sec_done_cb);
		}
		else
		{
			gotDelay++;
		}
	}
}

int SEC()
{
	static int done = 0;

	if(!done)
	{
		/* set up the DES engine for serial mode    */

		if ((pBufSec = (void*)malloc (SEC_TEST_BUF_SIZE)) == NULL)
		{
			printf("Malloc failed for SEC buffer\n");
			return ERROR;
		}

		if ((pBufSec2 = (void*)malloc (SEC_TEST_BUF_SIZE)) == NULL)
		{
			printf("Malloc failed for SEC buffer\n");
			return ERROR;
		}

		if ((pBufSec3 = (void*)malloc (SEC_TEST_BUF_SIZE)) == NULL)
		{
			printf("Malloc failed for SEC buffer\n");
			return ERROR;
		}

		done = 1;
   		printf("Malloc returned SEC buffers at %p, %p, %p \n",
		       pBufSec, pBufSec2, pBufSec3);
   		printf("SEC_TEST_BUF_SIZE = 0x%x (%d)\n",
		       SEC_TEST_BUF_SIZE, SEC_TEST_BUF_SIZE);
	}

	/* taskSpawn ("tSEC", 101, 0, 10000,
	   (FUNCPTR) secTest, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0); */

	return OK;
}

/* Beginning of support for temp performance test */
#if 0

typedef struct {
	U32     callerRefId;
	U8      *pData;
	U32     length;
} msp_sec_test_perf_info;

msp_sec_test_perf_info  SecTestPerfInfo[500];

U32     SecTestPerfHead = 0;
U32     SecTestPerfTail = 0;
U32     SecTestPerfLast = 499;

#define SHRI 1

#ifdef SHRI 
void ShriComplete(U32   callerRefId,
                  U32   status)

{
	U8      *tempAddr;
	U32     i;

	tempAddr = SecTestPerfInfo[0].pData; 
    
	printf("PerfTest:  Got completion\n");
	printf("  CallerRefId: 0x%x\n",callerRefId);
	printf("  Status: 0x%x\n",status);

	printf("  Contents of pData is...\n");
	for (i=0;i<64;i++) {
		printf("  0x%x,",*tempAddr++);
		if ((i % 8) == 7)
			printf("\n");
	}
}
#else
extern void ShriComplete();
#endif

void SecTestCompFunc3(U32                   perfHead,
                      msp_sec_hsh_result    *hashResult,
                      U32                   status)
{
	msp_sec_3des_key    keys;
	msp_sec_des_iv      iV;
	U32    mode;
	U32                 retStatus;
	U32                 callerRefId;
	U8                  *sourceAddress;
	U32                 length;

	if (status != MSP_SUCCESS) {
		callerRefId = SecTestPerfInfo[perfHead].callerRefId;
		ShriComplete(callerRefId, status);
	} else {
		keys.Key1High = 0xABCDABCD;
		keys.Key1Low = 0xABCDABCD;
		keys.Key1Mode = DMC_K1_ENC ;
		keys.Key2High = 0xABCDABCD;
		keys.Key2Low = 0xABCDABCD;
		keys.Key2Mode = DMC_K2_DEC ;
		keys.Key3High = 0xABCDABCD;
		keys.Key3Low = 0xABCDABCD;
		keys.Key3Mode = DMC_K3_ENC ;

		iV.IVHigh = 0xABCDABCD;
		iV.IVLow= 0xABCDABCD;
    
		mode = DMC_MOD_CBC;

		sourceAddress = SecTestPerfInfo[perfHead].pData;
		length = SecTestPerfInfo[perfHead].length;
		callerRefId = SecTestPerfInfo[perfHead].callerRefId;

		mode = DMC_MOD_CBC | DMC_MOD_DEC | DMC_3DES;

		retStatus = MspSecDESXncrypt ( callerRefId,
					       sourceAddress,
					       sourceAddress,
					       SecTestDestAddr2,
					       &keys,
					       &iV,
					       length,
					       mode,
					       ShriComplete);
	}
}

void SecTestCompFunc2(U32                 perfHead,
                      U32                 status)
{
	msp_sec_hsh_chaining_vars   chainingVars;
	U8                          *sourceAddress;
	U32                         length;
	U32                         retStatus;
	U32                         callerRefId;

	if (status != MSP_SUCCESS) {
		callerRefId = SecTestPerfInfo[perfHead].callerRefId;
		ShriComplete(callerRefId, status);
	} else {
		chainingVars.ChainVarA = 0x01234567;
		chainingVars.ChainVarB = 0x89ABCDEF;
		chainingVars.ChainVarC = 0xFEDCBA98;
		chainingVars.ChainVarD = 0x76543210;
		chainingVars.ChainVarE = 0x25252525;

		sourceAddress = SecTestPerfInfo[perfHead].pData;
		length = SecTestPerfInfo[perfHead].length;

		retStatus = MspSecHshSHA1 ( perfHead,
					    sourceAddress,
					    length,
					    &chainingVars,
					    SecTestCompFunc3);
	}
}

void SecTestCompFunc1(U32   perfHead,
                      U32   status)
{
	msp_sec_hsh_chaining_vars   chainingVars;
	U8                          *sourceAddress;
	U32                         length;
	U32                         retStatus;
	U32                         callerRefId;

	if (status != MSP_SUCCESS) {
		callerRefId = SecTestPerfInfo[perfHead].callerRefId;
		ShriComplete(callerRefId, status);
	} else {
		chainingVars.ChainVarA = 0x01234567;
		chainingVars.ChainVarB = 0x89ABCDEF;
		chainingVars.ChainVarC = 0xFEDCBA98;
		chainingVars.ChainVarD = 0x76543210;
		chainingVars.ChainVarE = 0x25252525;
    
		sourceAddress = SecTestPerfInfo[perfHead].pData;
		length = SecTestPerfInfo[perfHead].length;
    
		retStatus = MspSecHshSHA1 ( perfHead,
					    sourceAddress,
					    length,
					    &chainingVars,
					    SecTestCompFunc2);
	}

}

U32 MspSecTestPerform(U8   *pData,
                       U32  length,
                       U32  callerRefId)
{
	msp_sec_3des_key    keys;
	msp_sec_des_iv      iV;
	U32    mode;
	U32                 retStatus;
	U32                 perfHead;

	perfHead = SecTestPerfHead;

	if (SecTestPerfHead == SecTestPerfLast)
		SecTestPerfHead = 0;
	else
		SecTestPerfHead++;

	keys.Key1High = 0xABCDABCD;
	keys.Key1Low = 0xABCDABCD;
	keys.Key1Mode = DMC_K1_ENC ;
	keys.Key2High = 0xABCDABCD;
	keys.Key2Low = 0xABCDABCD;
	keys.Key2Mode = DMC_K2_DEC ;
	keys.Key3High = 0xABCDABCD;
	keys.Key3Low = 0xABCDABCD;
	keys.Key3Mode = DMC_K3_ENC ;

	iV.IVHigh = 0xABCDABCD;
	iV.IVLow= 0xABCDABCD;

	mode = DMC_MOD_CBC | DMC_3DES;

	SecTestPerfInfo[perfHead].callerRefId = callerRefId;
	SecTestPerfInfo[perfHead].pData = pData;
	SecTestPerfInfo[perfHead].length = length;

	retStatus = MspSecDESXncrypt(perfHead,
				     pData,
				     pData,
				     &keys,
				     &iV,
				     length,
				     mode,
				     SecTestCompFunc1);

	return(MSP_SUCCESS);
}


U8  PDesPad[16];
U8  PHshPad[128];

U32 MspSecTestPerformBlk(U8   *pData,
                         U32  length)
{
	msp_sec_3des_key            keys;
	msp_sec_des_iv              iV;
	U32            		    mode;
	U32                         retStatus;
	msp_sec_hsh_chaining_vars   chainingVars;
	msp_sec_hsh_result          hashResult;
	U32                         secdLength;
	U32                         chainId;
	U32                         length2;

	unsigned char		    *destAddress;

	destAddress = (unsigned char *) & hashResult;

	keys.Key1High = 0xABCDABCD;
	keys.Key1Low = 0xABCDABCD;
	keys.Key1Mode = HMC_K1_ENC ;
	keys.Key2High = 0xABCDABCD;
	keys.Key2Low = 0xABCDABCD;
	keys.Key2Mode = HMC_K2_DEC ;
	keys.Key3High = 0xABCDABCD;
	keys.Key3Low = 0xABCDABCD;
	keys.Key3Mode = HMC_K3_ENC ;

	iV.IVHigh = 0xABCDABCD;
	iV.IVLow= 0xABCDABCD;

	mode = HMC_MOD_CBC;

	chainingVars.ChainVarA = 0x01234567;
	chainingVars.ChainVarB = 0x89ABCDEF;
	chainingVars.ChainVarC = 0xFEDCBA98;
	chainingVars.ChainVarD = 0x76543210;
	chainingVars.ChainVarE = 0x25252525;
    
	secdLength = 8 - (length % 8);

	chainId = (U32)pData;

	if (length % 8) {
		MspSecBuildChain(&chainId,
				 length,
				 pData,
				 pData);

		MspSecBuildChain(&chainId,
				 secdLength,
				 PDesPad,
				 PDesPad);

		retStatus = MspSec3DESEncryptChainBlk (chainId,
						       &keys,
						       iV,
						       mode);
	} else {
		retStatus = MspSec3DESEncryptBlk(pData,
						 pData,
						 &keys,
						 iV,
						 length,
						 mode);
	}

	if (retStatus != MSP_SUCCESS)
		return(retStatus);

	if (length % 64) {
		length2 = length - (length % 64);
		if (length2) {
			MspSecBuildChain(&chainId,
					 length2,
					 pData,
					 destAddress);
    
			length2 = 64;
			MspSecBuildChain(&chainId,
					 length2,
					 PHshPad,
					 destAddress);

			retStatus = MspSecHshSHA1ChainBlk ( chainId,
							    &hashResult,
							    &chainingVars);
		} else {
		}
	} else {
		retStatus = MspSecHshSHA1Blk ( pData,
					       &hashResult,
					       length,
					       &chainingVars);
	}
    
	if (retStatus != MSP_SUCCESS)
		return(retStatus);

	if (length % 64) {
		length2 = length - (length % 64);
		if (length2) {
			MspSecBuildChain(&chainId,
					 length2,
					 pData,
					 destAddress);
    
			length2 = 64;
			MspSecBuildChain(&chainId,
					 length2,
					 PHshPad,
					 destAddress);

			retStatus = MspSecHshSHA1ChainBlk ( chainId,
							    &hashResult,
							    &chainingVars);
		} else {
		}
	} else {
		retStatus = MspSecHshSHA1Blk ( pData,
					       &hashResult,
					       length,
					       &chainingVars);
	}
    
	if (retStatus != MSP_SUCCESS)
		return(retStatus);

	if (length % 8) {
		MspSecBuildChain(&chainId,
				 length,
				 pData,
				 pData);

		MspSecBuildChain(&chainId,
				 secdLength,
				 PDesPad,
				 PDesPad);

		retStatus = MspSec3DESDecryptChainBlk (chainId,
						       &keys,
						       iV,
						       mode);
	} else {
		retStatus = MspSec3DESDecryptBlk(pData,
						 pData,
						 &keys,
						 iV,
						 length,
						 mode);
	}

	return(retStatus);

}


void JrrTestPerform() 
{
	U8      *JBuf;
	U8      *tempAddr;
	U32     i;

	JBuf = (U8 *)malloc(64);

	tempAddr = JBuf;

	for (i=0;i<64;i++)
		*tempAddr++ = (i & 0xFF);

	tempAddr = JBuf;

	printf("  Contents of pData is...\n");
	for (i=0;i<64;i++) {
		printf("  0x%x,",*tempAddr++);
		if ((i % 8) == 7)
			printf("\n");
	}

	MspSecTestPerform(JBuf, 64, 99);

}

void JrrTestPerformBlk() 
{
	U8      *JBuf;
	U8      *tempAddr;
	U32     i;
	U32     retStatus;

	JBuf = (U8 *)malloc(128);

	tempAddr = JBuf;

	for (i=0;i<126;i++)
		*tempAddr++ = (i & 0xFF);

	tempAddr = JBuf;

	printf("  Contents of pData is...\n");
	for (i=0;i<126;i++) {
		printf("  0x%x,",*tempAddr++);
		if ((i % 8) == 7)
			printf("\n");
	}
	printf("\n");

	retStatus = MspSecTestPerformBlk(JBuf, 62);

	tempAddr = JBuf;

	printf("  Finished with status:  0x%x\n",retStatus);
	printf("  Contents of pData is...\n");
	for (i=0;i<126;i++) {
		printf("  0x%x,",*tempAddr++);
		if ((i % 8) == 7)
			printf("\n");
	}
	printf("\n");

}
#endif

struct tlist {
	void (*fn)(void) ;
	char *name ;
	int enable ;
} testlist[] = {
	{ MspSecTestPtDes, "MspSecTestPtDes", 1 }, 
	{ MspSecTestEcbDesBlk, "MspSecTestEcbDesBlk", 1 },
	{ MspSecTestDesNist, "MspSecTestDesNist", 1 },
	{ MspSecTestEcbDesSer, "MspSecTestEcbDesSer", 1 },
	{ MspSecTestEcbDesChainSer, "MspSecTestEcbDesChainSer", 1 },
	{ MspSecTestBigDesChain, "MspSecTestBigDesChain", 1 },
	{ MspSecTest3DesChain, "MspSecTest3DesChain", 1 },
	{ MspSecTest3DesStress, "MspSecTest3DesStress", 1 },
	{ MspSecTest3DesChainUnser, "MspSecTest3DesChainUnser", 1 },
	{ MspSecTestMd5Blk, "MspSecTestMd5Blk", 1 },
	{ MspSecTestSha1Blk, "MspSecTestSha1Blk", 1 },
	{ MspSecTestHshSer, "MspSecTestHshSer", 1 },
	{ MspSecTestHMACChains, "MspSecTestHMACChains", 1 },
	{ MspSecTestHshChains, "MspSecTestHshChains", 1 },
	{ MspSecTestHshChainSer, "MspSecTestHshChainSer", 1 },
	{ MspSecTest3DESENC, "MspSecTest3DESENC", 1 },
	{ MspSecTest3DESDEC, "MspSecTest3DESDEC", 1 },
	{ MspSecTest3DES, "MspSecTest3DES", 1 },
	{ MspSecTestDES, "MspSecTestDES", 1 }
} ;
int numtests = sizeof(testlist) / sizeof(struct tlist) ;


int
main(int argc, char **argv)
{
	int i ;
	int exclude = 0 ;
	int forever = 0 ;
	extern int optind ;
	
#if 0
	SEC() ;
	secTest() ;
#endif

	while ( (i = getopt(argc, argv, "fxl")) != -1 )
	{
		switch(i) {
		case 'f':
			forever = 1 ;
			break ;

		case 'x':
			exclude = 1 ;
			break ;

		case 'l':
			/* list tests */
			printf("Test list:\n") ;
			for(i = 0 ; i < numtests; i++)
			{
				printf("%d. %s\n", i+1, testlist[i].name) ;
			}
			exit(0) ;
			break ;

		default:
			printf("Usage: %s -l\n   %s [-x] [-f] [testnum...]\n",
			       argv[0], argv[0]) ;
			printf("   -l list tests and exit\n") ;
			printf("   -x exclude listed tests (else run listed)\n") ;
			printf("   -f loop forever (else one pass)\n") ;
			printf("   [testnum...] tests to run (default all)\n") ;
			exit(0) ;
		}

	}

	if (optind < argc)
	{
		if(exclude) {
			for(i = 0 ; i < numtests ; i++)
				testlist[i].enable = 1 ;
		} else {
			for(i = 0 ; i < numtests ; i++)
				testlist[i].enable = 0 ;
		}
	}
	
	while (optind < argc)
	{
		i = strtol(argv[optind++],0,0) ;
		if (i > 0 && i <= numtests)
		{
			if (exclude)
				testlist[i-1].enable = 0 ;
			else
				testlist[i-1].enable = 1 ;
		}
	}


	do {
		for (i = 0 ; i < numtests ; i++)
		{
			if (! testlist[i].enable)
				continue ;
			printf("******************************\n") ;
			printf("  %-2d. %s\n", i+1, testlist[i].name) ;
			printf("******************************\n") ;
			testlist[i].fn() ;
		}
		
		printf("\n\n============== Total errors: %d\n\n", ErrorCount) ;
	} while (forever) ;
	return ErrorCount ? 1 : 0 ;

}
