
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdlib.h>

#include <brecis/msp_sec.h>

#include "libdes/des.h"

void dump(char *addr, int len) ;

int secfd ;

#define PASSES 200000

#define MAX_DESC 4
#define DESC_SZ 256 


char initiv[] = {
	0x01, 0x02, 0x03, 0x04,
	0xfe, 0xfd, 0xfc, 0xfb
} ;

char keys[3][8] = {
	{ 0xEE, 0x11, 0xFF, 0x22,   0xCC, 0xDD, 0xAA, 0xBB },
	{ 0x32, 0x10, 0x76, 0x54,   0xBA, 0x98, 0xFE, 0xDC },
	{ 0xEE, 0x11, 0xFF, 0x22,   0xCC, 0xDD, 0xAA, 0xBB }
} ;

/* compare libdes output with brecis hardware output */

int
main(int argc, char **argv)
{
	int i ;
#if 0
	time_t t1, t2 ;
	struct timeval tv1, tv2 ;
	unsigned char hash[20], hash1[20] ;
	unsigned char *secret = "secret" ;
#endif
	static unsigned char bufr[544] ;
	static unsigned char obufr[544] ;
	static unsigned char obuf2[544] ;
	unsigned char *buf = bufr + 16 ;
	unsigned char *obuf = obufr + 16 ;
	sec_ioctl secparm ;
	sec_cbuf  contbuf[3] ;
	int fragtotal ;
	int verbose = 0 ;

	int l1 ;
	int l2 = 0, l3 = 0 ;
	int ncont = 0 ;

	des_key_schedule ks1, ks2, ks3;
	des_cblock iv ;

	if (!strcmp(argv[1], "verbose"))
		verbose = 1 ;

	printf("opening security device\n") ;

	secfd = open(SECDEV, O_RDWR) ;

	if(secfd < 0)
	{
		perror(SECDEV) ;
   		printf("failed to open %s\n", SECDEV) ;
		fflush(stdout) ;
		exit(1) ;
	}

	printf("sec device opened\n") ;


	printf("Buffer address is 0x%x\n", (unsigned int)buf) ;

	for(fragtotal = 1; fragtotal < 25; fragtotal++)
	{
		for (l3 = 0 ; l3 <fragtotal; l3++)
		{
			l2 = fragtotal - l3 ;
			l1 = 512 - fragtotal ;


			if (1 || verbose)
			{
				printf("Using buffer sizes of %d, %d, and %d                \r", l1, l2, l3) ;
				fflush(stdout) ;
				usleep(20000) ;
			}
			if (l2 == 0)
				ncont = 0 ;
			else if (l3 == 0)
				ncont = 1 ;
			else
				ncont = 2 ;

			/* fill buffer with something */
			for (i = 0 ; i < 512; i++)
				buf[i] = i & 0xff ;
			memset(obuf, 0, 512) ;

			/* fill in the security ioctl structure */
			/* this time do a DES encryption */
			secparm.type = MSP_SEC_DES ;
			secparm.options = 0 ;
			secparm.srcaddr = buf ;
			secparm.dstaddr = obuf ;
			secparm.cbuflist = contbuf ;

			secparm.cbufcount = ncont ;
			secparm.buflen = l1 ;

			contbuf[0].srcaddr = buf + l1 ;
			contbuf[0].dstaddr = obuf + l1 ;
			contbuf[0].buflen = l2 ;

			contbuf[1].srcaddr = buf + (l1 + l2) ;
			contbuf[1].dstaddr = obuf + (l1 + l2) ;
			contbuf[1].buflen = l3 ;

			secparm.mode = DMC_3DES | DMC_MOD_ENC | DMC_MOD_CBC ;
			secparm.mode |= DMC_K1_ENC | DMC_K2_DEC | DMC_K3_ENC ;
	
			secparm.ivhigh = ((int *)initiv)[0] ;
			secparm.ivlow  = ((int *)initiv)[1] ;

			secparm.desc_key1high = *( (int *) (&keys[0][0]) ) ;
			secparm.desc_key1low  = *( (int *) (&keys[0][4]) ) ;
			secparm.desc_key2high = *( (int *) (&keys[1][0]) ) ;
			secparm.desc_key2low  = *( (int *) (&keys[1][4]) ) ;
			secparm.desc_key3high = *( (int *) (&keys[2][0]) ) ;
			secparm.desc_key3low  = *( (int *) (&keys[2][4]) ) ;

			if (verbose) printf("doing first ioctl\n") ;

			ioctl(secfd, MSP_SEC_CTL, &secparm) ;
			memset(obuf2, 0, 512) ;
			memcpy(iv, initiv, sizeof(initiv)) ;
			i  = des_key_sched((C_Block *)keys[0], ks1) ;
			i |= des_key_sched((C_Block *)keys[1], ks2) ;
			i |= des_key_sched((C_Block *)keys[2], ks3) ;
			if (i)
				printf("WARNING: key sched returned bad\n") ;

			des_ede3_cbc_encrypt((C_Block *)buf, (C_Block *)obuf2, 512,
					     ks1, ks2, ks3, &iv, 1) ;
			/* des_ncbc_encrypt((C_Block *)buf, (C_Block *)obuf2, 512,
			   ks1, &iv, 1) ; */


			if (!memcmp(obuf, obuf2, 512))
			{
				if (verbose)
					printf("%d, %2d, %2d compare OK\n",
					       l1, l2, l3) ;
			}
			else
			{
				printf("%d, %2d, %2d compare FAIL*****                                           \n",
				       l1, l2, l3) ;

				if (verbose)
				{
					printf("encrypted message:\n") ;
					dump(obuf, 512) ;
					printf("\n\n") ;

					printf("des encrypted message:\n") ;
					dump(obuf2, 512) ;
					printf("\n\n") ;
				}
			}

		}
	}

	exit(0) ;

	/* fill in the security ioctl structure */
	/* this time do a DES decryption */
	secparm.type = MSP_SEC_DES ;
	secparm.options = 0 ;
	secparm.cbufcount = 0 ;
	secparm.cbuflist = NULL ;
	secparm.buflen = 512 ;
	secparm.srcaddr = buf ;
	secparm.dstaddr = obuf ;

	secparm.mode = DMC_3DES | DMC_MOD_DEC | DMC_MOD_CBC ;
	secparm.mode |= DMC_K1_DEC | DMC_K2_ENC | DMC_K3_DEC ;
	
	secparm.ivhigh = ((int *)initiv)[0] ;
	secparm.ivlow  = ((int *)initiv)[1] ;

	secparm.desc_key1high = *( (int *) (&keys[2][0]) ) ;
	secparm.desc_key1low  = *( (int *) (&keys[2][4]) ) ;
	secparm.desc_key2high = *( (int *) (&keys[1][0]) ) ;
	secparm.desc_key2low  = *( (int *) (&keys[1][4]) ) ;
	secparm.desc_key3high = *( (int *) (&keys[0][0]) ) ;
	secparm.desc_key3low  = *( (int *) (&keys[0][4]) ) ;

	printf("doing first ioctl\n") ;

	ioctl(secfd, MSP_SEC_CTL, &secparm) ;

	printf("decrypted message:\n") ;
	dump(obuf, 512) ;
	printf("\n Resulting IV: \n") ;
	dump((char *) &secparm.ivhigh, 8) ;
	printf("\n\n") ;

	memset(obuf2, 0, 512) ;
	memcpy(iv, initiv, sizeof(initiv)) ;
	i  = des_key_sched((C_Block *)keys[0], ks1) ;
	i |= des_key_sched((C_Block *)keys[1], ks2) ;
	i |= des_key_sched((C_Block *)keys[2], ks3) ;
	if (i)
		printf("WARNING: key sched returned bad\n") ;

	des_ede3_cbc_encrypt((C_Block *)buf, (C_Block *)obuf2, 512,
	   ks1, ks2, ks3, &iv, 0) ;
	/* des_ncbc_encrypt((C_Block *)buf, (C_Block *)obuf2, 512,
	   ks1, &iv, 1) ; */

	printf("des decrypted message:\n") ;
	dump(obuf2, 512) ;
	printf("\n Resulting IV: \n") ;
	dump((char *) &iv, 8) ;
	printf("\n\n") ;

	return 0 ;
}

void
dump(char *addr, int len)
{
	char *p;
	int n,i,a;
	a=0;
	while(len > 0) {
		n = (len < 16) ? len : 16;
		printf("%08x  ",a);
		p = addr;
		for(i=0; i<n; i++,p++) {
			printf("%02X ",*p & 0xff);
			if(i == 7) printf("- ");
		}
		if(i == 7) printf("  ");
		while(i++ < 16) {
			printf("   ");
			if(i == 7) printf("  ");
		}
		printf("   ");
		p = addr;
		for(i=0; i<n; i++,p++) {
			if((*p < 0x7f) && (*p > 0x1f)) 
				printf("%c",*p);
			else
				printf(".");
		}
		printf("\n");
		addr += 16;
		a += 16;
		len -= n;
	}
}
