/*
 $Header: /proj/software/pub/CVSROOT/uClinux/brecis/pe_api/mspPed.h,v 1.1 2002/01/25 17:12:44 prakity Exp $
 */



/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/

/* 
------------------------------------------------------------------------

  Module Name:
  MspPed.h
  
	Abstract:
	This file contains definitions and literals used for the direct
	API to the PE.
	
	  Since the host is Big Endian and the ZSP is Little Endian, structure fields
	  which are less than 32 bits in size may not be shareable. 
	  
		Author:
		Dave Lim
		
		  Revision:
		  Dave Lim		Initial Release
		  ------------------------------------------------------------------------
*/

#ifndef __mspPedH__
#define __mspPedH__

/* Possible values in FE interrupt mailbox */
#define MSP_PED_INT_MAILBOX_EVT    1

/* Hardware register definition:  Command Queue Base */
#define MSP_PED_BASE                0xB8200000
#define MSP_PED_COMMAND_Q_BASE      (MSP_PED_BASE+0x40000)

/*
 * Definitions related to events.
 */

/*  Event id values */
#define MSP_PED_CMD_RSP_EVT				1
#define MSP_PED_TX_COMPLETE_EVT			2
#define MSP_PED_RX_COMPLETE_EVT			3
#define MSP_PED_NOK_TXEOC_COMPLETE_EVT 	4
#define MSP_PED_NOK_RXEOC_COMPLETE_EVT 	5
#define MSP_PED_CID_ENCODING_TYPE_EVT 	6
#define MSP_PED_CID_ACTIVATED_EVT	 	7
#define MSP_PED_CID_DEACTIVATED_EVT	 	8

/* valid bit indicates event recently written by FE */
#define MSP_PED_VALID_EVT		0x80000000


/* RetHandle contains valid data only for ADDVC and ADDCID commands.
 * For ADDVC, RetHandle contains a "handle" which should be used
 * for all subsequent commands to a VC.
 * For ADDCID, RetHandle should be passed to the voice engine.
 */
typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32	    EvtData1;           
    U32	    EvtData2;          
	U32     EvtData3;         
	U32     EvtData4;         
	U32	    EvtId;           
} msp_ped_gen_rsp;


/* RspParm1 and RspParm2 are used for ADD_CID.
 * RspParm1 contains the Cid Handle.  RspParm2 contains
 * the frame length.
 */
typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32	    CmdId;              /* Id of completed command */

    U32	    CmdStatus;             /* Return Status */

	U32     RspParm1;            /* Response parameter */
	U32     RspParm2;            /* Response parameter */

	U32	    EvtId;              /* Contains MSP_PED_CMD_RSP_EVT */
} msp_ped_cmd_rsp;


typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	TxStatus;
#define MSP_PED_TXSTATUS_OK			1	 
#define MSP_PED_TXSTATUS_INVALID_BD	2 

	U32     Reserved2;            
    U32     Reserved3;
    U32     Reserved4;
	U32	    EvtId;              /* Contains MSP_PED_TX_COMPLETE_EVT */
} msp_ped_tx_complete;



typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
    U32	    RxStatus;             
#define MSP_PED_RXSTATUS_OK			1	 
#define MSP_PED_RXSTATUS_INVALID_BD	2
#define MSP_PED_RXSTATUS_NO_BD		3 
	U32     Reserved2;            
    U32     Reserved3;
    U32     Reserved4;
	U32	    EvtId;              /* Contains MSP_PED_RX_COMPLETE_EVT */
} msp_ped_rx_complete;



typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
    U32	    Reserved1;             
	U32     Reserved2;            
    U32     Reserved3;
    U32     Reserved4;
	U32	    EvtId;              /* Contains MSP_PED_NOK_TXEOC_COMPLETE_EVT */
} msp_ped_nokia_txeoc_complete;



typedef struct {
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
    U32	    RxFrameBSize;   /* Number of bytes received */          
	U32     Reserved1;            
    U32     Reserved2;
    U32     Reserved3;
	U32	    EvtId;              /* Contains MSP_PED_NOK_RXEOC_COMPLETE_EVT */
} msp_ped_nokia_rxeoc_complete;

typedef struct {
	U32		HsHandle;	  /* Cid handle.  Used to identify Cid in host memory */
    U32	    EncodingType;             
#define MSP_PED_ENC_TYPE_G711_64      0
#define MSP_PED_ENC_TYPE_G726_32      0
#define MSP_PED_ENC_TYPE_G726_16      0
#define MSP_PED_ENC_TYPE_G726_40      0
#define MSP_PED_ENC_TYPE_G726_24      0

    U32	    Reserved1;   
	U32     Reserved2;            
	U32     Reserved3;            
	U32	    EvtId;            /* Contains MSP_PED_CID_ENCODING_TYPE_EVT */
} msp_ped_cid_encoding;


typedef struct {
	U32		HsCidHandle1;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle2;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle3;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle4;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle5;	  /* Cid handle.  Used to identify Cid in host memory */
	U32	    EvtId;            /* Contains MSP_PED_CID_ACTIVATED_EVT */
} msp_ped_cid_activated;


typedef struct {
	U32		HsCidHandle1;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle2;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle3;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle4;	  /* Cid handle.  Used to identify Cid in host memory */
	U32		HsCidHandle5;	  /* Cid handle.  Used to identify Cid in host memory */
	U32	    EvtId;			  /* Contains MSP_PED_CID_DEACTIVATED_EVT */
} msp_ped_cid_deactivated;


/* Max number of commands the host can issue before waiting for a command
* completion event.
*/
#define MSP_PED_CMD_DEPTH	4


/* 
 * Buffer descriptor related definitions. 
 */

/* TxBD structure. */ 
typedef struct {
	U32		BufAddr;        /* Pointer to buffer */

	U16		Flags;
#define MSP_PED_TXBD_READY_FLAG			0x8000
#define MSP_PED_TXBD_INTERRUPT_FLAG		0x4000
#define MSP_PED_TXBD_LAST_FLAG		    0x2000
#define MSP_PED_TXBD_CONTINUE		    0x1000

	U16		BufLen;         /* Byte length of buffer */
} msp_ped_txbd;


/* RxBD structure. */ 
typedef struct {
	U32		BufAddr;
	
	U16		Flags;
#define MSP_PED_RXBD_READY_FLAG			0x8000
#define MSP_PED_RXBD_INTERRUPT_FLAG	    0x4000
#define MSP_PED_RXBD_LAST_FLAG          0x2000

#define MSP_PED_RXBD_ERROR_FLAGS 		0x003f
#define MSP_PED_RXBD_LEN_ERROR_FLAG	    0x0001
#define MSP_PED_RXBD_CRC_ERROR_FLAG	    0x0002
#define MSP_PED_RXBD_ABORT_ERROR_FLAG	0x0004
#define MSP_PED_RXBD_CPI_ERROR_FLAG		0x0008
#define MSP_PED_RXBD_OVERRUN_ERROR_FLAG	0x0010
	/* RxSize is the bytes size of the data received. */
	U16		RxSize;
} msp_ped_rxbd;

/* 
 * Definitions used for statistics.
 */

/* VC Stats structure */
typedef struct {
	msp_pe_vc_stats_atm_com		ComFlds;
} msp_ped_vc_stats_atm;


/* VC Frame Relay Stats structure */
typedef struct {
	msp_pe_vc_stats_fr_com		ComFlds;
} msp_ped_vc_stats_fr;


/* VC HDLC Stats structure */
typedef struct {
	msp_pe_vc_stats_hdlc_com	ComFlds;
} msp_ped_vc_stats_hdlc;


/* Cid Stats structure */
typedef struct {
	/* Number of voice payload bytes (ie. excluding headers)
	 * Tx/Rx'd.
	 */
	U32			TxBytes;
	U32			RxBytes;
	
	/* Number of AAL2 packets received with an invalid sequence
	 * number or parity bit.
	 */
	U32			RxSeqNumErrs;
	U32			RxParityErrs;

	/* Number of AAL2 header errors	(ie. invalid values in the
	 * length or offset fields.
	 */
	U32			RxInvAal2HdrErrs;
} msp_ped_cid_stats;



/* 
 * Command definitions
 */

/* Basic command id values */
/* These are commands which fit in the generic command struct. */
#define MSP_PED_PING_CMD				0
#define MSP_PED_EXT_CMD			    	1
#define MSP_PED_ENABLE_VC_CMD	    	2
#define MSP_PED_DEL_VC_CMD				3
#define MSP_PED_DISABLE_VC_CMD		    4
#define MSP_PED_TXBD_UPDATE_CMD			5
#define MSP_PED_RXBD_UPDATE_CMD			6
#define MSP_PED_DEL_CID_CMD				7
#define MSP_PED_GET_VC_STATS_CMD		8
#define MSP_PED_GET_CID_STATS_CMD		9
#define MSP_PED_ENABLE_PHY_CMD			10
#define MSP_PED_DISABLE_PHY_CMD			11
#define MSP_PED_GET_PHY_STATS_CMD		12
#define MSP_PED_GET_PE_STATS_CMD		13
#define MSP_PED_BASECMD_MAX				MSP_PED_GET_PE_STATS_CMD

/* debug commands. */
#define MSP_PED_READ_MEM_DBGCMD			1000

typedef struct {
	U32		CmdId;			/* Contains MSP_PED_READ_MEM_DBGCMD  */
	U32		PeDramWAddr;    /* Pe addr to read from. */
	U32		BufAddr;	    /* Address of buffer in host. */
	U32 	BufWSize;	    /* Word size of buffer. */
} msp_ped_read_mem_dbg;

/* Extended commands.  These are commands which are too long to fit in the
* generic command struct.
*/
#define MSP_PED_EXTCMD_MIN				100
#define MSP_PED_CFG_CMD					100
#define MSP_PED_UTOPIA_CFG_CMD		    101
#define MSP_PED_NOKIA_CFG_CMD		    102
#define MSP_PED_SERIAL_ATM_CFG_CMD		103
#define MSP_PED_HDLC_CFG_CMD		    104
#define MSP_PED_WAN_CFG_CMDS			105
#define MSP_PED_ADD_VC_CMD				105
#define MSP_PED_ADD_CID_CMD				106
#define MSP_PED_MOD_CID_CMD				107
#define MSP_PED_MOD_VC_CMD				108
#define MSP_PED_UPDATE_PHY_LINESPEED	109 
#define MSP_PED_NOKIA_TXEOC_CMD			110
#define MSP_PED_BIND_HDLCL2_CMD			111
#define MSP_PED_EXTCMD_MAX				MSP_PED_BIND_HDLCL2_CMD

/* Generic Cmd struct */
typedef struct {
	U32	CmdId;				/* Identifies command */
	U32	CmdParm1;			  
	U32 CmdParm2;		
	U32	CmdParm3;		
} msp_ped_cmd;


/* 
 * Basic command structures
 */
typedef struct {
	U32		CmdId;				/* Contains MSP_PED_TXBD_UPDATE_CMD  */
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedVcHandle;		/* PE handle.  Used to identify VC in PE memory */
	U32		TxBdPtr;			/* Ptr to next free TxBd in host memory. */
} msp_ped_txbd_update;



typedef struct {
	U32		CmdId;				/* Contains MSP_PED_RXBD_UPDATE_CMD */
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedVcHandle;		/* PE handle.  Used to identify VC in PE memory */
	U32		RxBdPtr;			/* Ptr to next free RxBd in host memory. */
} msp_ped_rxbd_update;



/* Del Cid Cmd struct */
typedef struct {
	U32		CmdId;				/* Contains MSP_PED_DEL_CID_CMD */
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedCidHandle;		/* Cid handle.  Used to identify Cid in PE memory */
    U32     Reserved;
} msp_ped_del_cid;



/* Generic Cmd struct */
/* Used for the following commands:
MSP_PED_ENABLE_VC_CMD
MSP_PED_DEL_VC_CMD
MSP_PED_DISABLE_VC_CMD	
*/ 
typedef struct {
	U32		CmdId;				
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedVcHandle;		/* PE handle.  Used to identify VC in PE memory */
	U32		Reserved;			/* Reserved */
} msp_ped_gen_cmd;



typedef struct {
	U32		CmdId;			    /* Contains MSP_PED_GET_VC_STATS_CMD */	
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedVcHandle;		/* PE handle.  Used to identify VC in PE memory */
	msp_pe_vc_stats_fr		*StatBufPtr;			/* Ptr to statistics buffer in host memory. */
} msp_ped_get_vc_stats;



/*MSP_PED_GET_CID_STATS */
typedef struct {
	U32		CmdId;				/* Contains MSP_PED_GET_CID_STATS_CMD */
	U32		HsHandle;		    /* Host handle.  Used to identify VC in host memory */
	U32 	PedCidHandle;		/* Cid handle.  Used to identify Cidin PE memory */
	U32		StatBufPtr;			/* Ptr to statistics buffer in host memory. */
} msp_ped_get_cid_stats;


/* Extended Cmd struct */
typedef struct {
	U32		CmdId;				/* Contains MSP_PED_EXT_CMD  */
	U32		ExtCmdBufPtr;		/* Ptr to buffer which contains extended command */
	U32		ExtCmdBufLen;		/* Byte size of extended command buffer */
	U32		Reserved;
} msp_ped_extcmd;


typedef struct {
	U32		CmdId;					/* Contains MSP_PED_ENABLE_PHY_CMD */
	U32		HsHandle;		   		/* Host handle.  Used to identify VC in host memory */
	msp_pe_phy_device	PhyDevice;  /* Wan interface to enable */
} msp_ped_enable_phy; 


typedef struct {
	U32		CmdId;					/* Contains MSP_PED_DISABLE_PHY_CMD */
	U32		HsHandle;		    	/* Host handle.  Used to identify VC in host memory */
	msp_pe_phy_device	PhyDevice;  /* Wan interface to disable */
} msp_ped_disable_phy; 

typedef struct {
	U32		CmdId;					/* Contains MSP_PED_GET_PHY_STATS_CMD */
	msp_pe_phy_stats	*StatBufPtr;				/* Ptr to statistics buffer in host memory. */
	msp_pe_phy_device	PhyDevice;  /* Wan interface to get stats from */
} msp_ped_get_phy_stats; 

typedef struct {
	U32					CmdId;			    /* Contains MSP_PE_GET_PE_STATS_CMD */	
	msp_pe_stats		*StatBufPtr;			/* Ptr to statistics buffer in host memory. */
	U32		Reserved1;
	U32		Reserved2;
} msp_ped_get_pe_stats;


/* 
 * Extended command structures
 */

/* These commands are larger than the generic command size.  So
* the PE will DMA these commands into PE memory. 
*/
typedef struct {
	U32					CmdId;				/* Contains  MSP_PED_CFG_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32					HsHandle;		

	msp_ped_gen_rsp		*evtBufAddr;			/* Base address of event buffer */
	U32					MaxNumEvts;				/* Maximum number of events in event buffer */
	U32					ZspCycleSpeed;			/* In Nanoseconds * 10 */

	msp_pe_cfg_com		ComFlds;
			
} msp_ped_cfg;

typedef struct {
	U32		CmdId;				/* Contains  MSP_PED_UTOPIA_CFG_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

	msp_pe_utopia_cfg_com	ComFlds;
			
} msp_ped_utopia_cfg;


typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_SERIAL_ATM_CFG_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

	msp_pe_serial_atm_cfg_com
			ComFlds;
} msp_ped_serial_atm_cfg;


typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_NOKIA_CFG_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		
	U32     RxEocBufAddr[MSP_PE_NOKIA_MAX_PHYS];
	msp_pe_nokia_cfg_com ComFlds;
} msp_ped_nokia_cfg;


typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_HDLC_CFG_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

	msp_pe_hdlc_cfg_com
			ComFlds;
} msp_ped_hdlc_cfg;


typedef struct {
	U32		CmdId;			/* Contains MSP_PED_UPDATE_PHY_LINESPEED_CMD */
    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		
	msp_pe_phy_device	PhyDevice;  /* Wan interface to update */
	msp_pe_line_speed	PhyLineSpeed; 
} msp_ped_update_phy_linespeed; 

typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_ADD_VC_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

	/* TxBd ring related fields. */
	U32		TxBdBaseAddr;
	U32		TxBdSize;			/* Byte size of TxBd ring. */
								
	/* RxBd ring related fields. */
	U32		RxBdBaseAddr;
	U32		RxBdSize;			/* Byte size of RxBd ring. */

	U32		PeakCellEmissionTime;
	U32		SustainedCellEmissionTime;
	U32		BurstThreshold;

	msp_pe_add_vc_atm_com
			ComFlds;
} msp_ped_add_vc_atm;


typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_ADD_VC_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

    /* TxBd ring related fields. */
	U32		TxBdBaseAddr;
	U32		TxBdSize;			/* Byte size of TxBd ring. */

								
	/* RxBd ring related fields. */
	U32		RxBdBaseAddr;
	U32		RxBdSize;			/* Byte size of RxBd ring. */

	msp_pe_add_vc_fr_com
			ComFlds;
} msp_ped_add_vc_fr;

typedef struct {
	U32		CmdId;			/* Contains  MSP_PED_ADD_VC_CMD */

    /* Host handle.  Used to identify cmd in host memory */
    U32		HsHandle;		

    /* TxBd ring related fields. */
	U32		TxBdBaseAddr;
	U32		TxBdSize;			/* Byte size of TxBd ring. */

								
	/* RxBd ring related fields. */
	U32		RxBdBaseAddr;
	U32		RxBdSize;			/* Byte size of RxBd ring. */

	msp_pe_add_vc_hdlc_com
			ComFlds;
} msp_ped_add_vc_hdlc;

typedef struct {
	U32		CmdId;				/* Contains MSP_PED_ADD_CID_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	U32		PedVcHandle;
	U32     VpmdPortHandle;

	msp_pe_add_cid_com ComFlds;
} msp_ped_add_cid;


typedef struct {
	U32		CmdId;				/* Contains MSP_PED_MOD_VC_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	U32		PedVcHandle;
    U32     VpmdPortHandle;

	U32		PeakCellEmissionTime;
	U32		SustainedCellEmissionTime;
	U32		BurstThreshold;

	msp_pe_mod_vc_atm_com ComFlds;
} msp_ped_mod_vc_atm;



typedef struct {
	U32		CmdId;				/* Contains MSP_PED_MOD_VC_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	U32		PedVcHandle;

	msp_pe_mod_vc_fr_com ComFlds;
} msp_ped_mod_vc_fr;


typedef struct {
	U32		CmdId;				/* Contains MSP_PED_MOD_CID_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	U32		PedCidHandle;
	U32     VpmdPortHandle;

	msp_pe_mod_cid_com ComFlds;
} msp_ped_mod_cid;


typedef struct {
	U32		CmdId;			/* Contains MSP_PED_BIND_HDLCL2_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	msp_pe_phy_device	PhyDevice;  /* Wan interface to bind */
	U32		L2Intf;
#define L2INTF_FRAME_RELAY						1
#define L2INTF_FRAME_RELAY_COPPERMOUNTAIN		2
#define L2INTF_RAW								3
#define L2INTF_PPP								4

} msp_ped_bind_hdlcl2; 


/* MSP_PED_NOKIA_TXEOC_CMD*/
typedef struct {
	U32		CmdId;				/* Contains MSP_PED_NOKIA_TXEOC_CMD */
	U32		HsHandle;		    /* Handle to use when sending evts to
								 * host concerning this VC. */
	msp_pe_phy_device	PhyDevice;  /* Wan interface to bind */
	U8		*EocBufPtr;			/* Ptr to Eoc buffer in host memory. */
	U32		EocBufBSize;        /* Byte size of Eoc buffer. */
} msp_ped_nokia_txeoc;

typedef struct MSP_PED_EXTCMDS {
	union {
		msp_ped_cfg						ped_cfg;
		msp_ped_utopia_cfg				utopia_cfg;
		msp_ped_serial_atm_cfg			serial_atm_cfg;
		msp_ped_nokia_cfg				nokia_cfg;
		msp_ped_hdlc_cfg				hdlc_cfg;
		msp_ped_update_phy_linespeed	update_phy_linespeed; 
		msp_ped_add_vc_atm				add_vc_atm;
		msp_ped_add_vc_fr				add_vc_fr;
		msp_ped_add_vc_hdlc				add_vc_hdlc;
		msp_ped_add_cid					add_cid;
		msp_ped_mod_vc_atm				mov_vc_atm;
		msp_ped_mod_vc_fr				mod_vc_fr;
		msp_ped_mod_cid					mod_cid;
		msp_ped_bind_hdlcl2				bind_hdlcl2; 
		msp_ped_nokia_txeoc				nokia_txeoc;
	} extcmds_st;
} msp_ped_extcmds;

/* size of largest ext command in words.  Used to allocate a ext cmd buffer. */
#define MAX_EXT_CMD_SIZE   sizeof(msp_ped_extcmds)
#endif



