#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <sys/signal.h>
#include <sys/wait.h>
#include <unistd.h>

/* ------------------------------------------------------------------------ */
static pid_t mypid;
static struct sigaction siga;
static sigset_t sigset;

/* ------------------------------------------------------------------------ */
static void test_handler(int signo) 
{
    fprintf(stderr, "caught SIGCHLD\n"); sleep(1);
}


/* ------------------------------------------------------------------------ */
static void test1(void)
{
    /* Setup a child process to exercise the sig handling for us */
    mypid = getpid();
    if (vfork() == 0) {
	int i;

	fprintf(stderr, "child, running\n"); sleep(1);
	for (i=0; i < 3; i++) {
	    fprintf(stderr, "child, sleep #%d\n", i);
	    sleep(2);
	    fprintf(stderr, "child, kill SIGCHLD #%d\n", i); sleep(1);
	    kill(mypid, SIGCHLD);
	    fprintf(stderr, "child, after kill\n"); sleep(1);
	}
	fprintf(stderr, "child, exiting\n"); sleep(1);
	_exit(EXIT_SUCCESS);
    }

    fprintf(stderr, "parent, running\n"); sleep(1);

    /* Wait for signals */
    for(;;) {
	fprintf(stderr, "parent waiting for a SIGCHLD, sleep 10)\n");
	sleep(10);
	if (waitpid(-1, NULL, WNOHANG | WUNTRACED) > 0) {
	    fprintf(stderr, "parent waitpid returned > 0\n"); sleep(1);
	    break;
	}
	fprintf(stderr, "parent after sleep\n"); sleep(1);
    }
    fprintf(stderr, "parent, test 1 done\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
static char arg_number[10];
static char *argv_kill1[4] = { "kill", "-CHLD", arg_number, NULL };
static char * envp_init[3] = { "HOME=/", "TERM=linux", NULL };

/* ------------------------------------------------------------------------ */
static void test2(void)
{
    /* Setup a child process to exercise the sig handling for us */
    if (vfork() == 0) {
	fprintf(stderr, "child, running\n"); sleep(1);
	sprintf(arg_number, "%d", mypid);
	fprintf(stderr, "child, execve(/bin/kill)\n"); sleep(1);
	execve("/bin/kill", argv_kill1, envp_init);
	fprintf(stderr, "execve failed\n"); sleep(1);
	_exit(EXIT_FAILURE);
    }

    fprintf(stderr, "parent, running\n");
    /* Wait for signals */
    for(;;) {
	fprintf(stderr, "parent waiting for a SIGCHLD, sleep 10)\n");
	sleep(10);
	if (waitpid(-1, NULL, WNOHANG | WUNTRACED) > 0) {
	    fprintf(stderr, "parent waitpid returned > 0\n"); sleep(1);
	    break;
	}
	fprintf(stderr, "parent after sleep\n"); sleep(1);
    }
    fprintf(stderr, "parent, test 2 done\n"); sleep(1);
}

/* ------------------------------------------------------------------------ */
int main(void) 
{
    /* Set up sighandling */
    sigfillset(&sigset);
    siga.sa_handler = test_handler;
    siga.sa_mask = sigset;
    siga.sa_flags = 0;
    if (sigaction(SIGCHLD, &siga, (struct sigaction *)NULL) != 0) {
	fprintf(stderr, "sigaction choked: %s!", strerror(errno)); sleep(1);
	exit(EXIT_FAILURE);
    }
    mypid = getpid();
    
    test1();
    test2();

    fprintf(stderr, "Bye-bye!  All done!\n"); sleep(1);
    exit(0);
}

/* ------------------------------------------------------------------------ */
