#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <termios.h>

#define N_PTRS 1000
/* #define N_ALLOCS 10000 */
#define N_ALLOCS 20000
#define MAX_SIZE 0x10000
/* #define MAX_SIZE 0x8000 */

#define random_size()	((random()%MAX_SIZE)+1)
#define random_ptr()	(random()%N_PTRS)

void            test1(void);
void            test2(void);

int             main(int argc, char *argv[])
{
write(2, "init#1\n", 7);
sleep(1);
  test1();
write(2, "init#2\n", 7);
sleep(1);
  test2();
write(2, "done!!\n", 7);
sleep(1);
  return 0;
}

void            test1(void)
{
  void          **ptrs;
  int             i,
                  j;
  int             size;

write(2, "init#3\n", 7);
sleep(1);
  srandom(0x19730929);

  ptrs = malloc(N_PTRS * sizeof(void *));

  for (i = 0; i < N_PTRS; i++) {
    size = random_size();
#ifndef PRINT
    if ((i % 200) == 0) {
      fprintf(stderr, "ptrs[%d]=%d\n", i, size);
      tcdrain(STDERR_FILENO);
    }
#endif
    ptrs[i] = malloc(size);
    if (ptrs[i] == NULL) {
      printf("malloc failed! %d\n", i);
    } else {
      memset(ptrs[i], '3', size);
    }
  }
write(2, "init#4\n", 7);
sleep(1);
  for (i = 0; i < N_ALLOCS; i++) {
    j = random_ptr();
    free(ptrs[j]);

    size = random_size();
    ptrs[j] = malloc(size);
#ifndef PRINT
    if ((i % 200) == 0) {
      fprintf(stderr, "loop %d %d %d\n", i, j, size);
      tcdrain(STDERR_FILENO);
    }
#endif
    if (ptrs[j] == NULL) {
      printf("malloc failed! %d, %d, size=%d\n", i, j, size);
    } else {
      memset(ptrs[j], '3', size);
    }
  }
write(2, "init#5\n", 7);
sleep(1);
  for (i = 0; i < N_PTRS; i++) {
    free(ptrs[i]);
  }
}

void            test2(void)
{
  void           *ptr = NULL;

write(2, "init#6\n", 7);
sleep(1);
  ptr = realloc(ptr, 100);
  if (!ptr) {
    printf("couldn't realloc() a NULL pointer\n");
  } else {
    free(ptr);
  }

write(2, "init#7\n", 7);
sleep(1);
  ptr = malloc(100);
write(2, "init#8\n", 7);
sleep(1);
  ptr = realloc(ptr, 0);
  if (ptr) {
    printf("realloc(,0) failed\n");
    free(ptr);
  }
write(2, "init#9\n", 7);
}
