/* #define SLOWDOWN */
/* #define PRINT */
#ifdef PRINT
static char     debugbuf[256];
#endif

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <termios.h>

#define N_PTRS 250
#define N_ALLOCS 10000
#define MAX_SIZE 0x8000
#define random_size()	(random()%MAX_SIZE)
#define random_ptr()	(random()%N_PTRS)

void            test1(void);
void            test2(void);

int             main(int argc, char *argv[])
{
  test1();
  test2();
  write(2, "done\n", 5);
  tcdrain(STDERR_FILENO);
  return 0;
}

void            test1(void)
{
  void          **ptrs;
  int            *sizes;
  int             i, j;
  int             size;
  int             total_size = 0;

  srandom(0x19730929);

  total_size += N_PTRS * sizeof(void *);
  ptrs = (void **) malloc(N_PTRS * sizeof(void *));
  if (!ptrs) {
    tcdrain(STDERR_FILENO);
    printf("malloc failed!  totalsize=%d\n", total_size);
    tcdrain(STDERR_FILENO);
    exit(1);
  }
#ifdef PRINT
  (void) snprintf(debugbuf, 256, "%p\n", ptrs);
  write(2, debugbuf, strlen(debugbuf));
#ifdef SLOWDOWN
  tcdrain(STDERR_FILENO);
#endif
#endif
  total_size += N_PTRS * sizeof(int);
  sizes = (int *) malloc(N_PTRS * sizeof(int));
  if (!sizes) {
    tcdrain(STDERR_FILENO);
    printf("malloc failed!  totalsize=%d\n", total_size);
    tcdrain(STDERR_FILENO);
    exit(1);
  }
#ifdef PRINT
  (void) snprintf(debugbuf, 256, "%p\n", sizes);
  write(2, debugbuf, strlen(debugbuf));
#ifdef SLOWDOWN
  tcdrain(STDERR_FILENO);
#endif
#endif

  for (i = 0; i < N_PTRS; i++) {
    size = random_size();
    total_size += size;
    sizes[i] = size;
    ptrs[i] = malloc(size);
#ifdef PRINT
    (void) snprintf(debugbuf, 256, "init #%d  %p (%d)\n", i, ptrs[i], size);
    write(2, debugbuf, strlen(debugbuf));
    tcdrain(STDERR_FILENO);
#endif
    if (!ptrs[i]) {
      tcdrain(STDERR_FILENO);
      printf("malloc failed! #%d, totalsize=%d\n", i, total_size);
      total_size -= sizes[i];
      sizes[i] = 0;
      tcdrain(STDERR_FILENO);
/* exit(1); */
    } else {
      memset(ptrs[i], '1', size);
    }
  }
  for (i = 0; i < N_ALLOCS; i++) {
    j = random_ptr();
#ifdef PRINT
    (void) snprintf(debugbuf, 256, "loop #%d #%d %p ", i, j, ptrs[j]);
    write(2, debugbuf, strlen(debugbuf));
#ifdef SLOWDOWN
    tcdrain(STDERR_FILENO);
#endif
#endif
    free(ptrs[j]);
    total_size -= sizes[j];

    size = random_size();
    sizes[j] = size;
    total_size += size;
    ptrs[j] = malloc(size);
#ifdef PRINT
    (void) snprintf(debugbuf, 256, "-- new  %p (%d)\n", ptrs[j], size);
    write(2, debugbuf, strlen(debugbuf));
#ifdef SLOWDOWN
    tcdrain(STDERR_FILENO);
#endif
#endif
    if (!ptrs[j]) {
      tcdrain(STDERR_FILENO);
      printf("malloc failed! %d / %d  size=%d totalsize=%d\n", i, j, size, total_size);
      total_size -= sizes[j];
      sizes[j] = 0;
      tcdrain(STDERR_FILENO);
/* exit(1); */
    } else {
      memset(ptrs[j], '2', size);
    }
  }
  for (i = 0; i < N_PTRS; i++) {
#ifdef PRINT
    (void) snprintf(debugbuf, 256, "free #%d %p\n", i, ptrs[i]);
    write(2, debugbuf, strlen(debugbuf));
#ifdef SLOWDOWN
    tcdrain(STDERR_FILENO);
#endif
#endif
    free(ptrs[i]);
  }
}

void            test2(void)
{
  void           *ptr = NULL;

  ptr = realloc(ptr, 100);
  if (!ptr) {
    tcdrain(STDERR_FILENO);
    printf("couldn't realloc() a NULL pointer\n");
    tcdrain(STDERR_FILENO);
    exit(1);
  } else {
    free(ptr);
  }

  ptr = malloc(100);
  ptr = realloc(ptr, 0);
  if (ptr) {
    tcdrain(STDERR_FILENO);
    printf("realloc(,0) failed\n");
    free(ptr);
    tcdrain(STDERR_FILENO);
    exit(1);
  }
}
