#include <sys/types.h>
#include <sys/param.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

extern void bcopy(const void *, void *, size_t);
extern void bzero(void *, size_t);


/* ------------------------------------------------------------------------ */
#define MMAP_FD (-1)
/* Macro for mmap */
#define MMAP(size) \
	mmap((void *)0, (size), PROT_READ|PROT_WRITE, MAP_ANON|MAP_PRIVATE, \
	    MMAP_FD, (off_t)0);

/* ------------------------------------------------------------------------ */
static struct novm_free {
  struct novm_free *next_free;
  struct novm_free *prev_free;
  size_t size;
} *free_memory = NULL;

/* ------------------------------------------------------------------------ */

void *malloc(size_t size)
{
  void *r;
  size_t nsize;
  struct novm_free *n = free_memory;
  struct novm_free *Mclose = NULL;

  if (size < sizeof(struct novm_free)) {
    nsize = sizeof(struct novm_free) + sizeof(size_t);
  } else {
    nsize = size + sizeof(size_t);
  }
  while (n != NULL) {
    if (n->size == nsize) {
      Mclose = n;
      break;
    }
    n = n->next_free;
  }
  if (Mclose != NULL) {			/* use the one that is "close" */
    r = Mclose;
/* Pull it out of list */
    if (Mclose->prev_free != NULL) {	/* in middle, or end */
      Mclose->prev_free->next_free = Mclose->next_free;
      if (Mclose->next_free != NULL) {	/* if in middle of list */
	Mclose->next_free->prev_free = Mclose->prev_free;
      }
    } else {				/* first of list */
      free_memory = Mclose->next_free;
      if (free_memory != NULL) {
	free_memory->prev_free = NULL;
      }
    }
    bzero(r, size);
  } else {				/* Nothing on free list */
    r = (void *)MMAP(nsize);
    if (r == NULL) {
      fprintf(stderr, "out of memory.\n");
      return(NULL);
    }
    *(size_t *)r = nsize;
    (void *)r = (size_t *)r + 1;
  }
  return (r);
}

/* ------------------------------------------------------------------------ */
void free(void *ptr)
{
  struct novm_free *a = (struct novm_free *)ptr;
/*   int i; */

  if (ptr == NULL) {
    return;				/* do nothing if null. */
  }
  a->size = *((size_t *)ptr - 1);	/* size in word before memory */
  a->next_free = free_memory;
  a->prev_free = NULL;
  if (free_memory != NULL) {
    free_memory->prev_free = a;
  }
/*   for (i = sizeof(struct novm_free)/4; i< a->size/4; i++) { */
/*     *((int *)ptr + i) = 0xbabababa; */
/*   } */
  free_memory = a;			/* put on head of list */
  return;
}

/* ------------------------------------------------------------------------ */
void *realloc(void *ptr, size_t size)
{
  void *r;
  size_t s;
  size_t os;

  r = malloc(size);
  if (ptr == NULL) {
    return(r);
  }
  os = *((size_t *)ptr - 1);		/* size in word before memory */
  os = os - sizeof(size_t);
  if (os > size) {
    s = size;
  } else {
    s = os;
  }
  bcopy((char *)ptr, (char *) r, s);
  free(ptr);
  return(r);
}

/* ------------------------------------------------------------------------ */
