/* #include <features.h> */
#include "iostream.h"

class TestGlobal  
{
    public: 
	TestGlobal::TestGlobal()
	{
	    std::cout << "hello from a global constructor\n";
	    initialized_flag = 42;
	}
	TestGlobal::~TestGlobal()
	{
	    std::cout << "goodbye from a global destructor\n";
	}
	void hello(char *msg)
	{
	    std::cout << "hello from " << msg << "\n"; 
	};
    public:
	int initialized_flag;
};

class Test 
{
    public: 
	Test::Test()
	{
	    std::cout << "hello from a normal constructor\n";
	    initialized_flag = 42;
	}
	Test::~Test()
	{
	    std::cout << "goodbye from a normal destructor\n";
	}
	void hello(char *msg)
	{
	    if (initialized_flag != 42) {
		std::cout << "normal contructor failed to execute!\n";
		exit(1);
	    }
	    std::cout << "hello from " << msg << "\n"; 
	};
    public:
	int initialized_flag;
};

// A nice test global
TestGlobal b;

// Another test global
int flag = 0;

class Test2 
{
    public: 
	template <class T, class U> Test2(T, U) {flag = 1;}
	template <class T, class U> Test2(T, U*) {flag = 2;}
	template <class T, class U> Test2(T*, U) {flag = 3;}
	template <class T, class U> Test2(T*, U*) {flag = 4;}
};



int main(void) 
{
    TestGlobal *c;
    c = &b;

    if (c->initialized_flag != 42) {
	std::cout << "Global contructor failed to execute!\n";
	exit(1);
    }


    Test a;
    a.hello("test 1"); 
    b.hello("test 2"); 
    c->hello("test 3");


    int* p = 0;
    flag = 0;
    new Test2(p, 0);
    if (flag != 3) {
	std::cout << "bug 1"; 
	exit(1);
    }

    flag = 0;
    new Test2(0, p);
    if (flag != 2) {
	std::cout << "bug 2"; 
	exit(2);
    }

    flag = 0;
    new Test2(p, p);
    if (flag != 4) {
	std::cout << "bug 3"; 
	exit(3);
    }

    flag = 0;
    new Test2(0, 0);
    if (flag != 1) {
	std::cout << "bug 4"; 
	exit(4);
    }

    std::cout << "Cool, things seem to be working!\n"; 
    return(0);
}

