/*************************************************************
 * File: lib/vstrlen.c
 * Purpose: compute length of printf fmt string.
 * Author: Phil Bunce (pjb@carmel.com)
 *	Actaully this was written by the RAP folks. But I decided
 *	that it was such a good idea I decided to adopt it.
 * Revision History:
 *	980420	Created.
 */

#include <varargs.h>
#include <string.h>
#include <strfmt.h>

#define strNcpy(x,y,z)	strncpy(x,y,z),(x)[z]=0

/*************************************************************
*  int vstrlen(s,ap)
*/
int vstrlen(s,ap)
char *s;
va_list ap;
{
char *t,*p,tmp[40];
unsigned int n;
int trunc,haddot,width,base = 0,length;
#ifdef FLOATINGPT
double dbl;
#endif

length = 0;
for (;*s;) {
	if (*s == '%') {
		s++;
		width = trunc = haddot = 0;
		for (;*s;s++) {
			if (strchr("dobxXuscefg%",*s)) break;
			else if (*s == '*') {
				if (haddot) trunc = va_arg(ap,int);
				else width = va_arg(ap,int);
				}
			else if (*s >= '1' && *s <= '9') {
				for (t=s;isdigit(*s);s++) ;
				strNcpy(tmp,t,s-t);
				atob(&n,tmp,10);
				if (haddot) trunc = n;
				else width = n;
				s--;
				}
			else if (*s == '.') haddot = 1;
			}
		if (*s == '%') {
			length += 1;
			}
		else if (*s == 's') {
			p = va_arg(ap,char *);
			if (p) length += (width>strlen(p))?width:strlen(p);
			else length += (width>strlen("(null)"))?width:strlen("(null)");
			}
		else if (*s == 'c') {
			n = va_arg(ap,int);
			length += 1;
			}
		else {
			if (strchr("dobxXu",*s)) {
				if (*s == 'd' || *s == 'u') base = 10;
				else if (*s == 'x' || *s == 'X') base = 16;
				else if (*s == 'o') base = 8;
				else if (*s == 'b') base = 2;
				btoa(tmp,va_arg(ap,int),base);
				length += (width>strlen(tmp))?width:strlen(tmp);
				}
#ifdef FLOATINGPT
			else if (strchr("efg",*s)) {
				dbl = va_arg(ap,double);
				dbl_to_ascii(&dbl,tmp);
				if (trunc) trunc_fp(*s,tmp,trunc);
				else trunc_fp(*s,tmp,6);
				length += (width>strlen(tmp))?width:strlen(tmp);
				trunc = 0;
				}
#endif
			}
		s++;
		}
	else if ( *s == '\n') {
	  length += 2;
	  s++;
	}
	else { s++; length += 1; }
	}
return(length);
}

