/*************************************************************
 * File: start of kernel
 */

#include <mips.h>
#include <defines.h>

	.globl _start
	.ent _start
_start:
	move s0, a0			# save calling arguments to kernel
	move s1, a1
	move s2, a2
	move s3, a3

	jal	cpdata		
	jal	clrbss

	# set the global data pointer
	la	gp,_gp

	/* unpack the kernel */
	la	a0, fromkernel
	la	a1, framkernel
	la	t0, unzip
	jal	t0

1: 	# call the main C routine
	move a0, s0			# restore calling arguments to kernel
	move a1, s1
	move a2, s2
	move a3, s3
	la	t0, kernel_entry
	j	t0
_exit:
	b	1b
	.end _start		
