# File: pmon/target.mk
# Purpose: builds a single target type
# Author: Phil Bunce (pjb@carmel.com)
# Revision History:
#	970826	Started Revision history
#	970826	Added date.c dependency
#	980616	Removed devinfo.o from DYNOBJS

include $(LSIPKG)/defines.mk
include ../files.mk

OBJS = $(ASFILES:.s=.o) $(CFILES:.c=.o) 
DYNOBJS = date.o vers.o
# PROM = -T $(FTEXT) -D $(FDATA)
FLIB = -L$(LSIPKG)/$(FPEM_DIR)/$(ENDIAN)
MON  = $(LSIPKG)/mon/$(ENDIAN)
CLIB = $(LSIPKG)/lib/$(ENDIAN)/lib$(NMOD)c.a
LIBS = -L$(MON) $(FLIB)
OFILE = -o pmon
SLIB = $(LIBF) -lxmon -lxc -lxmon

all : pmon
	@echo pmon/$(ENDIAN) is now up to date

pmon: ../rules.mk ../pmon.lk ../date.c ../vers.c $(OBJS) $(DYNOBJS) $(CLIB) $(MON)/lib$(NMOD)mon.a $(FPEM_DEP)
	$(LD) -N -M -Ttext $(PMON_TEXT_ORIGIN) -T ../pmon.lk $(LDFLAGS) $(LIBS) $(OFILE) $(OBJS) $(DYNOBJS) $(SLIB) > $@.map
	rm -f pmon.bin
	$(OBJCOPY) -O binary --gap-fill 0 --set-start 0 \
		--change-addresses 0 pmon pmon.bin
	$(OBJCOPY) -O ihex --gap-fill 0 --set-start 0 \
		--change-addresses 0x100000000 pmon pmon.hex
	@if [ ! -d /tftpboot/${USER} ]; then\
		mkdir /tftpboot/${USER}; \
	fi
	cp pmon.bin /tftpboot/${USER}

../date.c : $(MON)/lib$(NMOD)mon.a $(CLIB)
	@echo "char date[] = \"$$(date)\";" > ../date.c

../vers.c : ../full-version
	@echo "char vers[] = \"$$(cat ../full-version)\";" > ../vers.c

../full-version : ../version ../minor-version
	@echo $$(cat ../version)$$(cat ../minor-version) > ../full-version

../minor-version : $(MON)/lib$(NMOD)mon.a $(CLIB)
	@if [ ! -e ../minor-version ] ; then echo 0 > ../minor-version; fi
#	@echo $$(expr $$(cat ../minor-version) + 1) > ../minor-version

clean:
	@$(RMFOBJS) pmon pmon.rec pmon.map *.o

reduce:
	@$(RMFOBJS) $(DYNOBJS)

include ../rules.mk

# These are created manually because makedepend doesn't like to
# parse .s files (prob with cl).
mips.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
mips.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
mips.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
mips.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
mips.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
mips.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
mips.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
mips.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
mips.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
mips.o: $(LSIPKG)/include/lr64363.h

# DO NOT DELETE THIS LINE -- make depend depends on it.
main.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
main.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
main.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
main.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
main.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
main.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
main.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
main.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
main.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
main.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
main.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
main.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
main.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
main.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
main.o: $(LSIPKG)/include/utypes.h
memtst.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
memtst.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
memtst.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
memtst.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
memtst.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
memtst.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
memtst.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
memtst.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
memtst.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
memtst.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
memtst.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
memtst.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
memtst.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
memtst.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
memtst.o: $(LSIPKG)/include/utypes.h
load.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
load.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
load.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
load.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
load.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
load.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
load.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
load.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
load.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
load.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
load.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
load.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
load.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
load.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
load.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
sbrk.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sbrk.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sbrk.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
sbrk.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
sbrk.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
sbrk.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
sbrk.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
sbrk.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
sbrk.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
sbrk.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
sbrk.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
sbrk.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
sbrk.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
sbrk.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
sbrk.o: $(LSIPKG)/include/utypes.h
ioctl.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
ioctl.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
ioctl.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
ioctl.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
ioctl.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
ioctl.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
ioctl.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
ioctl.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
ioctl.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
ioctl.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
ioctl.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mipsmon.h
ioctl.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/pmon.h
ioctl.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
ioctl.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
ioctl.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
