/*************************************************************
 * File: pmon/sbrk.c
 * Purpose: Part of the Prom Monitor (PMON)
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <pmon.h>

extern char BSS_END;
char *allocp1 = &BSS_END;

char *getheaptop()
{
  char *heaptop, *t;

  t = getMonEnv("heaptop");
  if (t == 0) heaptop = (char *)CLIENTPC;
  else {
	if (!atob(&heaptop,t,16)) {
	  heaptop = (char *)CLIENTPC;
	}
  }
  return heaptop;
}

char *sbrk(n)
int n;
{
  char *heaptop = getheaptop();

if (allocp1 + n <= heaptop) {
	allocp1 += n;
	return(allocp1 - n);
	} 
else return(0);
}

