/******************************************************************/
/* Copyright (c) 2001 BRECIS Communications                       */
/*      This software is the property of BRECIS Communications    */
/*      and may not be copied or distributed in any form without  */
/*      a prior licensing arrangement.                            */
/*                                                                */
/* BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND      */
/* FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS      */
/* SOFTWARE.                                                      */
/*                                                                */
/******************************************************************/
/*************************************************************
 * File: lib/r5000romcfl.s
 * Purpose: Part of C runtime library
 * Revision History:
 */

#ifndef BRECIS5000
#define BRECIS5000
#endif
#include <mips.h>
#include <brecis.h>

/*************************************************************
*  Invalidate the BRECIS mips caches
*
*/


/*************************************************************
*  r5000rom_flush(type,adr)
*	Invalidate the designated BRECIS5000 cache.
*	Note that this isn't a real subroutine, it just transfers
*	control to the appropriate flush routine.
*/
	.globl r5000rom_flush
	.ent r5000rom_flush
r5000rom_flush:
	bne	a0,ICACHEI,1f
	j	r5000rom_iflush

1:	bne	a0,ICACHE,1f
	j	r5000rom_iflush

1:	bne	a0,DCACHE,1f
	j	r5000rom_dflush

1:	bne	a0,DCACHEI,1f
	j	r5000rom_dflush

1:	move	a0,a1
	j	r5000rom_iflush
	.end r5000rom_flush

/*************************************************************
*  r5000rom_iflush()
*	Invalidate the BRECIS5000 Instruction cache.
*/
	.globl r5000rom_iflush
	.ent r5000rom_iflush
r5000rom_iflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0
1:

	.set noreorder

	li	t1,0x80000000
	addu	t0,t1,(ICACHESIZE)	# cache size

1: 	
	icache_indinv(r_t1)
	nop
	bne	t0,t1,1b
	addu	t1,ICACHELINESIZE	# line size

	nop	
	mtc0	t7,C0_SR	# restore SR
	nop
	.set reorder
	j	ra
	.end r5000rom_iflush

/*************************************************************
*  r5000rom_dflush()
*	Invalidate the BRECIS5000 Data cache.
*	o disable ints
*	o switch to kseg1
*	o invalidate the cache
*/
	.globl r5000rom_dflush
	.ent r5000rom_dflush
r5000rom_dflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0
1:
	.set noreorder

	# invalidate the Dcache
	li	t0,0x80000000
	addu	t1,t0,(DCACHESIZE)

1:	
	dcache_indinv(r_t0)
	nop
	bne	t0,t1,1b
	addu	t0,DCACHELINESIZE	# line size

	nop
	mtc0	t7,C0_SR	# restore SR
	nop
	.set reorder
	j	ra
	.end r5000rom_dflush

