/*************************************************************
 * File: imon/memtst.c
 * Purpose: Part of the Ice Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970318	Updated and added FASTMODE switch.
 *	980811	Don't use sizemem() if MEMSIZE is defined.
 */

#include <pmon.h>

#define FASTMODE	/* don't use read_target and write_target */

Optdesc mt_opts[] = {
	{"[-c][adr [siz] [printf-address-offset]]","memory test"},
	{"-c","continuous test"},
	{0}};

#ifdef TEST 
#define memtst main
int tikcnt;
dotik(a,b) 
{
tikcnt--;
if (tikcnt > 0) return;
tikcnt = 256000;
printf(".");
}
long memorysize = 8*1024*1024;

get_rsa(sp,p)
long *sp;
char *p;
{
sscanf(p,"%x",sp);
return(1);
}
#endif

/*************************************************************
*  memtst(ac,av)
*	The 'mt' memory test command 
*/
memtst(ac,av)
int ac;
char *av[];
{
int i,j,cnt,cflag,err;
unsigned long adr,siz,offset;
extern Ulong topClientMem;
extern Ulong topRealMem;

cflag = 0; cnt = 0;
adr = getheaptop()|K1BASE;
siz = 0;
offset = 0x4000;

for (i=1;i<ac;i++) {
	if (av[i][0] == '-') {
		for (j=1;av[i][j];j++) {
			if (av[i][j] == 'c') cflag |= 1;
			else printf("%c: bad option\n");
			}
		}
	else {
		switch (cnt) {
			case 0 : 
				if (!get_rsa(&adr,av[i])) return; 
				cnt++;
				break;
			case 1 :
				if (!get_rsa(&siz,av[i])) return;
				cnt++;
				break;
			case 2 :
				if (!get_rsa(&offset,av[i])) return;
				cnt++;
				break;
			default :
				printf("%s: Unknown argument\n",av[i]);
			}
		}
	}

/* make sure the address is word aligned */
adr = adr & ~0x3;
offset = offset & ~0x3;

#ifdef MEMSIZE /* 980811 */
if (!siz) siz = MEMSIZE;
#else
if (!siz) siz = (topClientMem | K1BASE) - adr;
printf("First/Last Client addr <0x%08x, 0x%08x>, Last physical addr 0x%08x\n",
	   getheaptop() | K1BASE, topClientMem | K1BASE, topRealMem | K1BASE);
printf("0x%08x bytes found at 0x%08x\n",siz,adr);
#endif

siz &= ~0x3;	/* make sure it's an exact number of words */

ioctl_cbreak(STDIN);

printf("Testing 0x%08x to 0x%08x printf-address-offset 0x%08x %s\n",
	   adr,adr+siz, offset, (cflag&1)?"continuous":"");
printf("Memory test running..  ");

if (cflag) while(! (err=domt(adr,siz, offset))) ;
else err = domt(adr,siz, offset);

if (err) printf("\b\nThere were %d errors.\n",err);
else printf("\b\nTest passed with no errors.\n");
}

/*************************************************************
*  domt(adr,siz)
*	This is not an exhaustive memory test. The intent is to provide
*	a test that completes within a reasonable time, that checks that
*	none of the address or data lines are stuck or shorted together.
*/
domt(adr,siz,offset)
unsigned int *adr,siz,offset;
{
int i,j,err,temp;
unsigned int w,r;
volatile unsigned int *p;

err = 0;

printf("\nwalking ones test\n");

/* walking ones test */
for (p=adr,i=0;i<siz;i+=4,p++) {
	w = 1;
	if ((i % offset) == 0 || (i + 4) == siz) printf("\r0x%08x",p);
	for (j=0;j<32;j++) {
#ifdef FASTMODE
		*p = w;
		temp = 0;
		r = *p;
#else
		write_target(XT_MEM,p,w,4);
		temp = 0;
		r = read_target(XT_MEM,p,4);
#endif
		if (r != w) {
			err++;
			printf("\b\nerror: addr=0x%08x read=0x%08x expected=0x%08x\n",
				p,r,w);
			}
		w <<= 1;
		}
	}

printf("\nstore address in each address\n");

/* store the address in each address */
for (p=adr,i=0;i<siz;i+=4,p++) {
	if ((i % offset) == 0 || (i + 4) == siz) printf("\r0x%08x",p);
#ifdef FASTMODE
	*p = (unsigned int)p;
#else
	write_target(XT_MEM,p,p,4);
#endif
	}

printf("\ncheck each address contains its address\n");

/* check that each address contains its address */
for (p=adr,i=0;i<siz;i+=4,p++) {
	if ((i % offset) == 0 || (i + 4) == siz) printf("\r0x%08x",p);
#ifdef FASTMODE
	r = *p;
#else
	r = read_target(XT_MEM,p,4);
#endif
	if (r != (unsigned int)p) {
		err++;
		printf("\b\nerror: adr=0x%08x read=0x%08x expected=0x%08x\n",p,r,p);
		}
	}
return(err);
}

