/*************************************************************
 * File: lib/cptext.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	971231	Added ifdef for GHS
 */

#include "mips.h"
#include <brecis.h>

#define icache_indinv(r)	.word	(0xbc000000|((r)<<21))

/*
 * Copy data from ROM to RAM, used in ROM-based applications.
 */

	.globl cptext
	.ent cptext
cptext: # copy .data to RAM
	# s0 = address to flush mips caches
	# src=ftext dst=eromtext stop=edata

	la		t0, cptexthandler
	la		t1, ecptexthandler
	la		t2, 0x80000000
		
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	icache_indinv(r_t2)
	sw		t3, (t2)
	sw		t4, 4(t2)
	sw		v0, 8(t2)
	sw		v1, 12(t2)			
	addu	t0, 16
	addu	t2, 16
	blt		t0, t1, 1b

	.set push
	.set mips3
	sync
	.set pop
	ld		v0, MEM_CNFG_REG	/* force memory controller to finish writes */

	la	t0,ltext
	la	t2,etext
 	la	t1,ftext

	move	t8, ra		
	la		v0, 0x80000000
	jalr	v0

	la	t0,ldata
	la	t2,edata
 	la	t1,fdata

	move	ra, t8		
	la		v0, 0x80000000
	j		v0

cptexthandler:	
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	sw		t3, (t1)
	sw		t4, 4(t1)
	sw		v0, 8(t1)
	sw		v1, 12(t1)			
	addu	t0, 16
	addu	t1, 16
	blt		t1, t2, 1b

	j	ra
	nop
ecptexthandler:		
	.end cptext
