# File: mon/target.mk
# Purpose: slave "Makefile" for mon target builds
# Author: Phil Bunce (pjb@carmel.com)
# Revision History:
#	970303	Fixed probs with vers.c etc...
#	970317	Moved monvers from OBJ def

include $(LSIPKG)/defines.mk
include ../files.mk

# keep OBJ simple to make dos conversion easier
OBJS = $(CFILES:.c=.o)
OBJ = lib$(NMOD)mon.a $(EXTRA_MON_OBJS)

all : $(OBJ)
	@echo mon/$(ENDIAN) is now up to date

lib$(NMOD)mon.a: $(OBJS) monvers.o
	@$(RMF) lib$(NMOD)mon.a
	$(AR) lib$(NMOD)mon.a $(OBJS) monvers.o

clean:
	@$(RMFOBJS) $(OBJ) lib$(NMOD)mon.a monvers.o

reduce:
	@$(RMFOBJS) monvers.o

include ../rules.mk

lib$(NMOD)mon_mips2.a : lib$(NMOD)mon.a
	cp lib$(NMOD)mon.a lib$(NMOD)mon_mips2.a 

# DO NOT DELETE THIS LINE -- make depend depends on it.
go.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
go.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
go.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
go.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
go.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
go.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
go.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
go.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
go.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
go.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
go.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
go.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
go.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
go.o: $(LSIPKG)/include/utypes.h
cli.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
cli.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
cli.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
cli.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
cli.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
cli.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
cli.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
cli.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
cli.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
cli.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/malloc.h
cli.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
cli.o: $(LSIPKG)/include/queue.h $(LSIPKG)/include/setjmp.h
cli.o: $(LSIPKG)/include/signal.h $(LSIPKG)/include/stdio.h
cli.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
cli.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
hist.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
hist.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
hist.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
hist.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
hist.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
hist.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
hist.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
hist.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
hist.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
hist.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
hist.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
hist.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
hist.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
hist.o: $(LSIPKG)/include/utypes.h
more.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
more.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
more.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
more.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
more.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
more.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
more.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
more.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
more.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
more.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
more.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
more.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
more.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
more.o: $(LSIPKG)/include/utypes.h
sload.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sload.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sload.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
sload.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
sload.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
sload.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
sload.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
sload.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
sload.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
sload.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
sload.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
sload.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
sload.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
sload.o: $(LSIPKG)/include/utypes.h
fload.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
fload.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
fload.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
fload.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
fload.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
fload.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
fload.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
fload.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
fload.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
fload.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
fload.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
fload.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
fload.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
sym.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sym.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sym.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
sym.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
sym.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
sym.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
sym.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
sym.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
sym.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
sym.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
sym.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
sym.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
sym.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
sym.o: $(LSIPKG)/include/utypes.h
set.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
set.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
set.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
set.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
set.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
set.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
set.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
set.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
set.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
set.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
set.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
set.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
set.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
regs.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
regs.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
regs.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
regs.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
regs.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
regs.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
regs.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
regs.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
regs.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
regs.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
regs.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
regs.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
regs.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
regs.o: $(LSIPKG)/include/utypes.h
machine.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/ctype.h
machine.o: $(LSIPKG)/include/dbxcore.h $(LSIPKG)/include/defines.h
machine.o: $(LSIPKG)/include/ernicore.h $(LSIPKG)/include/l9a0084.h
machine.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
machine.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
machine.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
machine.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
machine.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
machine.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
machine.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
machine.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
machine.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
machine.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
machine.o: $(LSIPKG)/include/utypes.h
bsocmds.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
bsocmds.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
bsocmds.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
bsocmds.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
bsocmds.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
bsocmds.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
bsocmds.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
bsocmds.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
bsocmds.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
bsocmds.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
bsocmds.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
bsocmds.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
bsocmds.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
bsocmds.o: $(LSIPKG)/include/utypes.h
bsoload.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
bsoload.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
bsoload.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
bsoload.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
bsoload.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
bsoload.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
bsoload.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
bsoload.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
bsoload.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
bsoload.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
bsoload.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
bsoload.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
bsoload.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
bsoload.o: $(LSIPKG)/include/utypes.h
debug.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
debug.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
debug.o: $(LSIPKG)/include/fcntl.h $(LSIPKG)/include/l9a0084.h
debug.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
debug.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
debug.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
debug.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
debug.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
debug.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
debug.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
debug.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
debug.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
debug.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
debug.o: $(LSIPKG)/include/utypes.h
regdefs.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
regdefs.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
regdefs.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
regdefs.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
regdefs.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
regdefs.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
regdefs.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
regdefs.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
regdefs.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
regdefs.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
regdefs.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
regdefs.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
regdefs.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
mxops.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
mxops.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
mxops.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
mxops.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
mxops.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
mxops.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
mxops.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
mxops.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
mxops.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
mxops.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
mxops.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
mxops.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
mxops.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
transp.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
transp.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
transp.o: $(LSIPKG)/include/fcntl.h $(LSIPKG)/include/l9a0084.h
transp.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
transp.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
transp.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
transp.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
transp.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
transp.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
transp.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
transp.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
transp.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
transp.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
transp.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
sdump.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
sdump.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
sdump.o: $(LSIPKG)/include/fcntl.h $(LSIPKG)/include/l9a0084.h
sdump.o: $(LSIPKG)/include/lr3000.h $(LSIPKG)/include/lr33000.h
sdump.o: $(LSIPKG)/include/lr33020.h $(LSIPKG)/include/lr33300.h
sdump.o: $(LSIPKG)/include/lr4001.h $(LSIPKG)/include/lr4002.h
sdump.o: $(LSIPKG)/include/lr4010.h $(LSIPKG)/include/lr4101.h
sdump.o: $(LSIPKG)/include/lr4102.h $(LSIPKG)/include/lr64008.h
sdump.o: $(LSIPKG)/include/lr64360.h $(LSIPKG)/include/lr64363.h
sdump.o: $(LSIPKG)/include/lr64364.h $(LSIPKG)/include/lr64388.h
sdump.o: $(LSIPKG)/include/mips.h $(LSIPKG)/include/mon.h
sdump.o: $(LSIPKG)/include/setjmp.h $(LSIPKG)/include/stdio.h
sdump.o: $(LSIPKG)/include/string.h $(LSIPKG)/include/string2.h
sdump.o: $(LSIPKG)/include/termio.h $(LSIPKG)/include/utypes.h
stty.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
stty.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
stty.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
stty.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
stty.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
stty.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
stty.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
stty.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
stty.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
stty.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
stty.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
stty.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
stty.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/termio.h
stty.o: $(LSIPKG)/include/utypes.h
dis.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
dis.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
dis.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
dis.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
dis.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
dis.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
dis.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
dis.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
dis.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
dis.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
dis.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
dis.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
dis.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
dump.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
dump.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
dump.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
dump.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
dump.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
dump.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
dump.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
dump.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
dump.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
dump.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
dump.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
dump.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
dump.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
fill.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
fill.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
fill.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
fill.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
fill.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
fill.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
fill.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
fill.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
fill.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
fill.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
fill.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
fill.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
fill.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
copy.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
copy.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
copy.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
copy.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
copy.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
copy.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
copy.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
copy.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
copy.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
copy.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
copy.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
copy.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
copy.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
search.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
search.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
search.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
search.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
search.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
search.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
search.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
search.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
search.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
search.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
search.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
search.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
search.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
modify.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
modify.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
modify.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
modify.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
modify.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
modify.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
modify.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
modify.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
modify.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
modify.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
modify.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
modify.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
modify.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
call.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
call.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
call.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
call.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
call.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
call.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
call.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
call.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
call.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
call.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
call.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
call.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
call.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
dis16.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
dis16.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
dis16.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
dis16.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
dis16.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
dis16.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
dis16.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
dis16.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
dis16.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
dis16.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
dis16.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
dis16.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
dis16.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
compare.o: $(LSIPKG)/include/cobrcore.h $(LSIPKG)/include/dbxcore.h
compare.o: $(LSIPKG)/include/defines.h $(LSIPKG)/include/ernicore.h
compare.o: $(LSIPKG)/include/l9a0084.h $(LSIPKG)/include/lr3000.h
compare.o: $(LSIPKG)/include/lr33000.h $(LSIPKG)/include/lr33020.h
compare.o: $(LSIPKG)/include/lr33300.h $(LSIPKG)/include/lr4001.h
compare.o: $(LSIPKG)/include/lr4002.h $(LSIPKG)/include/lr4010.h
compare.o: $(LSIPKG)/include/lr4101.h $(LSIPKG)/include/lr4102.h
compare.o: $(LSIPKG)/include/lr64008.h $(LSIPKG)/include/lr64360.h
compare.o: $(LSIPKG)/include/lr64363.h $(LSIPKG)/include/lr64364.h
compare.o: $(LSIPKG)/include/lr64388.h $(LSIPKG)/include/mips.h
compare.o: $(LSIPKG)/include/mon.h $(LSIPKG)/include/setjmp.h
compare.o: $(LSIPKG)/include/stdio.h $(LSIPKG)/include/string.h
compare.o: $(LSIPKG)/include/string2.h $(LSIPKG)/include/utypes.h
