/*************************************************************
 * File: mon/search.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mon.h>

Optdesc search_opts[] = {
	{"from to {val|-s str}..","search memory"},
	{"from","start address of search"},
	{"to","non inclusive end of search"},
	{"val","byte value(s) to find"},
	{"-s str","string value to find"},
	{0}};

char *searching = "searching..  ";

/*************************************************************
*  search(ac,av)
*	the search command 
*/
search(ac,av)
int ac;
char *av[];
{
Ulong adr, i;
Ulong from,to,a;
char *s, *d, c;
char pat[PATSZ];
int patsiz,siz,ln;

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

if (!atob(&siz,getMonEnv("moresz"),10)) {
	printf("%s: bad moresz value\n",getMonEnv("moresz"));
	return(1);
	}
ln = siz;
ioctl_cbreak(0L);

if(!get_rsa(&from,av[1]) || !get_rsa(&to,av[2])) return(1);
for(d=pat,i=3; i < ac; i++){
	if (strequ(av[i],"-s")) {
		i++;
		if (i >= ac) printf("bad arg count\n");
		else for (s=av[i];*s;s++) *d++ = *s;
		}
	else {
			if(!get_rsa(&a,av[i])) return(1);
			c = a;
			*d++ = c;
		}
	}

if (to <= from) {
	printf("'to' address too small\n");
	return(1);
	}

patsiz = d - pat;

printf("%s",searching);
if (from < to) { /* forward search */
	to -= d - pat - 1;
	while (from <= to) {
		s = pat;
		adr = from++;
		while (s < d) {
			if(*s != read_target(XT_MEM,adr,1)) break;
			s++; adr++;
			}
		if (d <= s) {
			era_line(searching);
			dispmem(prnbuf,from - 1,patsiz, 1, 0); 
			if (more(prnbuf,&ln,siz)) break;
			printf("%s",searching);
			}
		else dotik(1,0);
		}
	if (from > to) era_line(searching);
	}
else { /* backward search */
	from -= d - pat - 1;
	while (from > to) {
		s = pat;
		adr = from--;
		while (s < d) {
			if(*s != read_target(XT_MEM,adr,1)) break;
			s++; adr++;
			}
		if(d <= s) {
			era_line(searching);
			dispmem(prnbuf,from - 1,patsiz, 1, 0); 
			if (more(prnbuf,&ln,siz)) break;
			printf("%s",searching);
			}
		}
	if (to > from) era_line(searching);
	}
return(0);
}
