/*************************************************************
 * File: mon/sdump.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *  010609  Add binary transfer to target
 */

#include <termio.h>
#include <fcntl.h>
#include <mon.h>

Optdesc sdump_opts[] = {
	{"[-Bv] addr size","send srecs/binary to hostport"},
#ifdef ETHERNET
	{"-v","verbose mode"},
	{"-B","select binary"},
#endif
	{0}};

/*************************************************************
*  sdump(ac,av)
*	the 'dump' command 
*/
sdump(ac,av)
int ac;
char *av[];
{
Ulong adr,siz,len,i,j,a;
char tmp[4];
char *uleof,*ulcr,*hostport;
int fd,cs,v,flags,count;
struct termio tbuf;

count = 0;
flags = 0;

vflag = 0;
for (i=1;i<ac;i++) {
  if (av[i][0] == '-') {
	for (j=1;av[i][j];j++) {
#ifdef ETHERNET
	  if (av[i][j] == 'B') flags |= 1;
	  else if (av[i][j] == 'v') vflag = 1;
	  else
#endif
		printf("%c: unrecognized option\n", av[i][j]);
	}
  }
  else {
	switch (count) {
	case 0:
	  if (!get_rsa(&adr,av[i])) return(1);
	  count++;
	  break;
	case 1:
	  if (!get_rsa(&siz,av[i])) return(1);
	  count++;
	  break;
	default:
	  printf("extra argument %s, ignored\n", av[i]);
	}
  }
}

if (count != 2) {
  printf("%s not specified\n", 
		 count == 0 ? "neither address nor size" : "size");
  return(1);
}

hostport = getMonEnv("hostport");
if (!hostport) {
	printf("ERROR: hostport not defined\n");
	return(1);
	}

#ifdef ETHERNET
if (flags&1 || strequ(hostport, "ethernet")) {
  if (!(flags&1)) printf("CAUTION: ethernet host forces dump -B (binary)\n");
  printf("Uploading to %s, ^C to abort\n",hostport);
  
  ether_upload(adr,siz);
  return; 
}
#endif

if (!regChain) {
	printf("Target description driver not loaded\n");
	return(1);
	}

fd = open(hostport,O_RDWR);
if (fd == -1) {
	printf("ERROR: can't open %s\n",hostport);
	return(1);
	}

ioctl(fd,TCGETA,&tbuf);
tbuf.c_iflag &= ~IXANY; 
ioctl(fd,TCSETAF,&tbuf);

uleof = getMonEnv("uleof");
if (!uleof) {
	printf("ERROR: uleof not defined\n");
	return(1);
	}
ulcr = getMonEnv("ulcr");
if (!ulcr) {
	printf("ERROR: ulcr not defined\n");
	return(1);
	}

while (siz > 0) {
	if (siz < 32) len = siz;
	else len = 32;
	cs = len+5;
	for (i=0;i<4;i++) cs += (adr>>(i*8))&0xff;
	sprintf(line,"S3%02X%08X",len+5,adr);
	for (a=adr,i=0;i<len;a++,i++) {
		v = read_target(XT_MEM,a,1);
		cs += v;
		sprintf(tmp,"%02X",v);
		strcat(line,tmp);
		}
	sprintf(tmp,"%02X\n",(~cs)&0xff);
	strcat(line,tmp);
	if (strequ(ulcr,"on")) line[strlen(line)-1] = '\r';
	write(fd,line,strlen(line));
	adr += len;
	siz -= len;
	}
strcpy(line,"S70500000000FA\n");
if (strequ(ulcr,"on")) line[strlen(line)-1] = '\r';
write(fd,line,strlen(line));
*line = 0;
write(fd,uleof,strlen(uleof));
return(0);
}
