/*************************************************************
 * File: mon/regdefs.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */


#include <mon.h>

/*************************************************************
*  regdefs.c
*	This file contains the register definitions for some
*	of the core MIPS registers. 
*/

RegSpec mips_sr_def[] = {
	{4,28,"CU",2,0,0},
	{1,27,"RP",2,0,0},
	{1,26,"-",2,0,1},
	{1,25,"RE",2,0,0},
	{2,23,"-",2,0,1},
	{1,22,"BEV",2,0,0},
	{1,20,"SR",2,0,0},
	{1,19,"NMI",2,0,0},
	{3,16,"-",2,0,1},
	{8,8,"IM",2,0,0},
	{3,5,"-",2,0,1},
	{1,4,"UM",2,0,0},
	{1,3,"-",2,0,1},
	{1,2,"ERL",2,0,0},
	{1,1,"EXL",2,0,0},
	{1,0,"IE",2,0,0},
	{0}};

RegSpec mips_cause_def[] = {
	{1,31,"BD",2,0,1},
	{1,30,"-",2,0,1},
	{2,28,"CE",10,0,1},
	{4,24,"-",2,0,1},
	{1,23,"IV",2,0,0},
	{1,22,"WP",2,0,0},
	{6,16,"-",2,0,1},
	{6,10,"IP",2,0,1},
	{2,8,"SW",2,0,0},
	{2,6,"-",2,0,1},
	{4,2,"EXCODE",0,excodes,1},
	{2,0,"-",2,0,1},
	{0}};

RegSpec mips_prid_def[] = {
	{8,8,"IMP",10,0,1},
	{8,0,"Rev",10,0,1},
	{0}};

RegSpec mips_config_def[] = {
	{1,31,"M",2,0,1},
	{3,28,"K23",2,0,0},
	{3,25,"KU",2,0,0},
	{4,21,"-",2,0,0},
	{1,20,"MDU",2,0,1},
	{1,19,"-",2,0,0},
	{2,17,"MM",2,0,1},
	{1,16,"BM",2,0,1},
	{1,15,"BE",2,0,1},
	{2,13,"AT",2,0,1},
	{3,10,"AR",2,0,1},
	{3,7,"MT",2,0,1},
	{4,3,"-",2,0,1},
	{3,0,"K0",2,0,1},  
	{0}};

