/*************************************************************
 * File: mon/mxops.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mon.h>
#ifndef PMCC
#include "../bsps/defs.h"
#endif

/*************************************************************
*  RegVal mXpc(int mode,int reg,int size,RegVal value)
*/
RegVal mXpc(int mode,int reg,int size,RegVal value)
{
if (mode) write_target(XT_PC,0,value,0);
else return read_target(XT_PC,0,0);
}

/*************************************************************
*  RegVal mXgpr(int mode,int reg,int size,RegVal value)
*/
RegVal mXgpr(int mode,int reg,int size,RegVal value)
{
if (mode) putGpr(reg,value);
else return getGpr(reg);
}

/*************************************************************
*  RegVal mXmem(int mode,Ulong adr,int size,RegVal value)
*	size={8,16,32,64}
*/
RegVal mXmem(int mode,Ulong adr,int size,RegVal value)
{
int sz;

if (size) sz = size/8;
else sz = 4;
if (mode) write_target(XT_MEM,adr,value,sz);
else return read_target(XT_MEM,adr,sz);
}

/*************************************************************
*  RegVal mXc0(int mode,int reg,int size,RegVal value)
*/
RegVal mXc0(int mode,int reg,int size,RegVal value)
{
 
if (mode) write_target(XT_CP0,reg,value,0);
else return read_target(XT_CP0,reg,0);
}

/*************************************************************
*  RegVal mXc1(int mode,int reg,int size,RegVal value)
*/
RegVal mXc1(int mode,int reg,int size,RegVal value)
{
 
if (mode == 0) /* read */ return read_target(XT_CP1,reg,0);
else write_target(XT_CP1,reg,value,0);
}
 
/*************************************************************
*  RegVal cXc1(int mode,int reg,int size,RegVal value)
*/
RegVal cXc1(int mode,int reg,int size,RegVal value)
{
 
if (mode == 0) /* read */ return read_target(XT_CP1C,reg,0);
else write_target(XT_CP1C,reg,value,0);
}

/*************************************************************
*  RegVal mXc2(int mode,int reg,int size,RegVal value)
*/
RegVal mXc2(int mode,int reg,int size,RegVal value)
{

if (mode == 0) /* read */ return read_target(XT_CP2,reg,0);
else write_target(XT_CP2,reg,value,0);
}

/*************************************************************
*  RegVal cXc2(int mode,int reg,int size,RegVal value)
*/
RegVal cXc2(int mode,int reg,int size,RegVal value)
{

if (mode == 0) /* read */ return read_target(XT_CP2C,reg,0);
else write_target(XT_CP2C,reg,value,0);
}

/*************************************************************
*  RegVal mXdbx(int mode,int reg,int size,RegVal value)
*/
RegVal mXdbx(int mode,int reg,int size,RegVal value)
{

if (mode) write_target(XT_DBX,reg,value,0);
else return read_target(XT_DBX,reg,0);
}

