/*************************************************************
 * File: mon/fill.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mon.h>

Optdesc fill_opts[] = {
	{"from to {val|-s str}..","fill memory"},
	{"from","start address of fill"},
	{"to","non inclusive end address"},
	{"val","byte values.."},
	{"-s str","fill with string"},
	{0}};

/*************************************************************
*  fill(ac,av)
*	the fill command 
*/
fill(ac,av)
int ac;
unsigned char *av[];
{
Ulong from,to,i,a,w;
unsigned char *s, *d, c;
unsigned char pat[PATSZ],*p;
int len;

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

if (!get_rsa(&from,av[1]) || !get_rsa(&to,av[2])) return(1);
if (to < from) {
	printf("fill: to_address must be larger than from_address\n");
	return(1);
	}

for(d=pat,i=3; i < ac; i++){
	if (strequ(av[i],"-s")) {
		i++;
		if (i >= ac) printf("bad arg count\n");
		else for (s=av[i];*s;s++) *d++ = *s;
		}
	else {
		if(!get_rsa(&a,av[i])) return(1);
		c = a;
		*d++ = c;
		}
	}

len = d-pat; p = pat;
if ((len==1 || len==2 || len==4) && (from&3)==0 && (to&3)==0) {
	/* do special cases using word writes (faster) */
	w = *p++;
	switch (len) {
		case 1 :
			w = (w<<8)+w;
			w = (w<<16)+w;
			break;
		case 2 :
			w = (w<<8)+(*p++);
			w = (w<<16)+w;
			break;
		case 4 :
			w = (w<<8)+(*p++);
			w = (w<<8)+(*p++);
			w = (w<<8)+(*p++);
			break;
		}
	for (;from < to;from+=4) write_target(XT_MEM,from,w,4);
	return(0);
	}

/* all other cases */
for (s = pat;from < to; from++) {
	write_target(XT_MEM,from,*s,1);
	if (++s >= d) s = pat;
	}
return(0);
}
