/*************************************************************
 * File: mon/eload.c
 * Purpose: elf-record loader
 */

#include <eload.h>
#include <stdio.h>
#include <termio.h>
#include <string.h>
#include <mon.h>

/*************************************************************
*  eload(ptr)
*	load elf records
*	returns:
*		-1 on error
*		0  at end
*		N  for data records (N = bytes transferred)
*/
eload(ptrp,linep,flags)
Uchar **ptrp;
int *linep,flags;
{
Uchar *ptr;
Elf32_Ehdr *ehdr;
Elf32_Phdr *phdr;
Elf32_Shdr *shdr;
Elf32_Shdr *strhhdr;
Elf32_Shdr *strhdr;
Elf32_Sym *sym;
int i, j, count, error;

ptr = *ptrp;

if (*linep == 0)
  {
	/* validate elf identification */

	if (ptr[EI_MAG0] == ELFMAG0 && 
		ptr[EI_MAG1] == ELFMAG1 && 
		ptr[EI_MAG2] == ELFMAG2 && 
		ptr[EI_MAG3] == ELFMAG3)
	  {
		/* we have elf identification, insure for this architecture */

		if (ptr[EI_CLASS] != ELFCLASS32) return ELFERR_BADCLASS;	

		if (ptr[EI_DATA] != ELFDATA2MSB) return ELFERR_BADENDIEN;

		if (ptr[EI_VERSION] != EV_CURRENT) return ELFERR_BADHVERSION;	

		ehdr = (Elf32_Ehdr *) ptr;

		/* we only support executable at this moment, add others later */
		if (ehdr->e_type != ET_EXEC) return ELFERR_UNSUPPORTEDOBJ;

		if (ehdr->e_machine != EM_MIPS) return ELFERR_NOTMIPS;

		if (ehdr->e_version != EV_CURRENT) return ELFERR_BADVERSION;

		strhhdr = (Elf32_Shdr *) &ptr[ehdr->e_shoff +
									 ehdr->e_shstrndx * ehdr->e_shentsize];
#if 0
		printf("e_shoff %x, e_shstrndx %x, e_shentsize %x, e_shnum %x\n",
			   ehdr->e_shoff, ehdr->e_shstrndx,
			   ehdr->e_shentsize, ehdr->e_shnum);
#endif

		for (i = 0; i < ehdr->e_shnum; i++)
		  {
			shdr = (Elf32_Shdr *) &ptr[ehdr->e_shoff + i * ehdr->e_shentsize];

#if 0
			printf("%d) section %s, type %x, flags %x\n    addr %x, size %x, offset %x, link %x\n",
				   i, 
				   &ptr[strhhdr->sh_offset + shdr->sh_name],
				   shdr->sh_type, shdr->sh_flags, shdr->sh_addr, 
				   shdr->sh_size, shdr->sh_offset, shdr->sh_link);
#endif

			/* if section occupies no allocation memory or no address */
			if (!(shdr->sh_flags & SHF_ALLOC) || shdr->sh_addr == 0)
			  {
				if (flags&DL_SFLAG) continue;			/* dont load symbols */

				if (shdr->sh_type == SHT_SYMTAB || shdr->sh_type == SHT_DYNSYM)
				  {
					printf("section %d) %s, processing global symbols\n",
						   i, &ptr[strhhdr->sh_offset + shdr->sh_name]);

					strhdr = 
					  (Elf32_Shdr *) &ptr[ehdr->e_shoff + 
										 shdr->sh_link * ehdr->e_shentsize];

					sym = (Elf32_Sym *) &ptr[shdr->sh_offset];

					count = 0;
					error = 0;

					for (j = shdr->sh_info; 
						 j < (shdr->sh_size/shdr->sh_entsize); 
						 j++)
					  {
						if (ELF32_ST_BIND(sym[j].st_info) != STB_GLOBAL)
						  continue;		/* ignore non-global symbols */

						count++;

						if (!newsym(&ptr[strhdr->sh_offset+sym[j].st_name],
									sym[j].st_value)) {
						  if (error == 0)
							printf("\r        No more memory for symbols beginning with symbol %s\n",
								   &ptr[strhdr->sh_offset+sym[j].st_name]);
						  error++;
						}
					  }
					printf("\r        %d symbols of %d symbols loaded\n",
						   count - error, count);
				  }
				continue;
			  }

			switch (shdr->sh_type)
			  {
			  case SHT_NULL:	/* inactive section */
				break;			/* ignore */

			  case SHT_PROGBITS:/* information defined by the program */
				printf("section %d) %s, copying %x to %x, len %x\n",
					   i, 
					   &ptr[strhhdr->sh_offset + shdr->sh_name],
					   &ptr[shdr->sh_offset], shdr->sh_addr, shdr->sh_size);
				bcopy(&ptr[shdr->sh_offset], shdr->sh_addr, shdr->sh_size);
				break;

			  case SHT_NOBITS:	/* occupies no space in file */
				printf("section %d) %s, clearing %x, len %x\n",
					   i, 
					   &ptr[strhhdr->sh_offset + shdr->sh_name],
					   shdr->sh_addr, shdr->sh_size);

				memset((char *) shdr->sh_addr, 0, shdr->sh_size);
				break;
				
			  case SHT_SYMTAB:	/* symbol table */
			  case SHT_STRTAB:	/* string table */
			  case SHT_RELA:	/* relocations entries, explicit addends */
			  case SHT_HASH:	/* symbol hash table */
			  case SHT_DYNAMIC:	/* dynamic linking information */
			  case SHT_NOTE:	/* info that marks files in some way */
			  case SHT_REL:		/* relocation entries, no explicit addends */
			  case SHT_SHLIB:	/* reserved, unspecified */
			  case SHT_DYNSYM:	/* symbol table */
			  default:
				printf("section %d) %s, type %x, not implemented\n",
					   i, 
					   &ptr[strhhdr->sh_offset + shdr->sh_name],
					   shdr->sh_type);
			  }
		  }

		if (ehdr->e_entry != 0)
		  {
			printf("Setting pc to %x\n", ehdr->e_entry);
			putPc(ehdr->e_entry);
		  }
	  }
	else return ELFERR_NOTELF;
  }

return ELFNORMAL_EOF;
}
