/*************************************************************
 * File: mon/dis.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970507	Added mips16 disassembly
 */

#include <mon.h>

Optdesc l_opts[] = {
	{"[-bct][adr [cnt]]","list (disassemble) memory"},
        {"-b","list only branches"},
        {"-c","list only calls"},
        {"-t","list trace buffer"},
        {"-T","assume TinyRISC instrs"},
	{0}};

/* used by -b option, list only branches */
char *brlst[] = {
        "j","jr","jal","jalr","break","syscall","rfe","beq","bne",
        "bltzal","bltz","blez","bgtz","bgezal","bgez",
        "bc0t","bc0f","bc1t","bc1f","bc2t","bc2f","bc3t","bc3f",
        "blezl","bgtzl","bltzl","bgezl","bltzall","bgezall",
        "bc0tl","bc0fl","bc1tl","bc1fl","bc2tl","bc2fl","bc3tl","bc3fl",
        "beql","bnel",
        0};

/* used by -c option, list only calls */
char *cllst[] = {"jal","jalr","bgezal","bltzal","bgezall","bltzall",0};


/*************************************************************
*  dis(ac,av)
*	the 'l' (disassemble) command
*/
dis(ac,av)
int ac;
char *av[];
{
Ulong adr, siz, l;
char v;
char instr[20],*p,**q;
int bflag,cflag,i,j,n,tflag,Tflag;

bflag = cflag = n = tflag = Tflag = 0;

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

if (!atob(&siz,getMonEnv("moresz"),10)) {
	printf("%s: bad moresz value\n",getMonEnv("moresz"));
	return(1);
	}

adr = getPc();

for (i=1;i<ac;i++) {
	if (av[i][0] == '-') {
		for (j=1;av[i][j] != 0;j++) {
			switch (av[i][j]) {
				case 'b' : bflag=1; break;
				case 'c' : cflag=1; break;
				case 't' : tflag=1; n++; break;
				case 'T' : Tflag=1; break; /* mips16 */
				default  : 
					printf("%c: unknown option\n",av[i][j]);
				}
			}
		}
	else {
		switch (n) {
			case 0 :
				if(!get_rsa(&adr,av[i])) return(1);
				break;
			case 1 :
				if(!get_rsa(&siz,av[i])) return(1);
				break;
			default :
				printf("%s: unknown option\n",av[i]);
				return(1);
			}
		n++;
		}
	}

ioctl_cbreak(0L);

if (tflag) {
	dispchist(n,siz);
	return(0);
	}

l = siz;

if (Tflag) adr |= 1; /* set the LS bit */

*prnbuf = 0;
if (cflag || bflag) printf("%s",searching);
while (1) {
	adr = disasm(prnbuf,adr,read_target(XT_MEM,adr,4));
        if (bflag || cflag) {
                for (p=prnbuf,i=0;p != 0 && i < 3;i++) p = getword(instr,p);
                if (cflag) q = cllst;
                else q = brlst;
                for (i=0;q[i] != 0;i++) {
                        if (strequ(instr,q[i])) break;
                        }
                if (q[i] == 0) {
                        dotik(128,0);
                        continue;
                        }
                else era_line(searching);
                }
        if (more(prnbuf,&l,(n>1)?0:siz)) break;
        if (cflag || bflag) printf("%s",searching);
	}
}

/*************************************************************
*  dispchist(args,siz)
*	display the pc history (trace buffer)
*/
dispchist(args,siz)
int args,siz;
{
int i,l;
unsigned long adr;

l = siz;
for (i=0;;i++) {
	adr = getpchist(i);
	if (adr == 0) break;
	disasm(prnbuf,adr,read_target(XT_MEM,adr,4));
	if (more(prnbuf,&l,(args>1)?0:siz)) break;
	}
}
