/*************************************************************
 * File: mon/copy.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980406	Added blksz.
 */

#include <mon.h>

Optdesc copy_opts[] = {
	{"[-fFp] from to siz","copy memory"},
	{"from","source of copy"},
	{"to","destination of copy"},
	{"cnt","copy cnt bytes"},
	{"-f","write to flash"},
	{"-F","force write to flash"},
	{"-p","preserve manufacturing record"},
	{0}};

/*************************************************************
*  copy(ac,av)
*	the 'copy' command 
*/
copy(ac,av)
int ac;
char *av[];
{
Ulong from, to, n;
int i,j,fflag,forceflag,preservemanufflag,blksz,slot;
char buf[100];

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

preservemanufflag = forceflag = fflag = 0;
for (i=1;i<ac;i++) {
	if (av[i][0] == '-') {
	  for (j=01;av[i][j] != 0;j++) {
		switch (av[i][j]) {
		case 'f' : fflag++; break;
		case 'F' : fflag++; forceflag++; break;
		case 'p' : fflag++; preservemanufflag++; break;
		default:
		  printf("%s: bad option\n",av[i]);
		  return(1);
		}
	  }
	}
	else
	  break;
}

if (ac-i != 3) {
	printf("bad argument count\n");
	return(1);
	}

if(!get_rsa(&from,av[i]) || !get_rsa(&to,av[i+1]) || !get_rsa(&n,av[i+2]))
	return(1);

if (fflag) {
#ifdef NVRAM
  if ( preservemanufflag )
	{
	  if ( ! validateManufWrite(from, to, n))
		{
		  preservemanufflag = 0; /* no manuf record, no need to preserve */
		}
	  forceflag++;
	}

  if (! forceflag && validateManufWrite(from, to, n))
	{
	  printf("Are you sure that you want to overwrite the manufacturing record (y/n)?");
	  gets(buf);
	  if (!strequ(buf,"y")) return;
	}

	if (fflag < 2) {
	   /* use 2 -f flags to skip this warning */
	   printf("Are you sure that you want to write to the flashes (y/n)?");
		gets(buf);
		if (!strequ(buf,"y")) return;
		}

	slot = findFlashSlot(to);
	
	if (slot < 0)
	{
		printf("error: to address %x is not a flash address.\n", to);
		return 1;
	}
 
	if (!writeSectorsFlash(from, to, n, preservemanufflag))
	  {
		printf("error: either not flash chip or flash chip not recognized or other error\n");
	  }

	return(0);
#else
	printf("write to NVRAM not supported with this configuration.\n");
	return(1);
#endif
	}

bcopy(from,to,n);
}
