/*************************************************************
 * File: mon/compare.c
 * Purpose: Part of core Monitor
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980725	Created
 */

#include <mon.h>

Optdesc compare_opts[] = {
	{"addr1 addr2 bytes","compare memory"},
	{"addr1","start address of 1st area"},
	{"addr2","start address of 2nd area"},
	{"bytes","length in bytes"},
	{0}};

/*************************************************************
*  compare_cmd(int ac,char *av[])
*	the compare command 
*/
compare_cmd(int ac,char *av[])
{
int i,len,errcnt;
Ulong addr1,addr2,x1,x2;

if (!regChain) {
	printf("Target Description Driver not loaded\n");
	return(1);
	}

if (ac != 4) {
	printf("usage: compare <addr1> <addr2> <bytes>\n");
	return(1);
	}

if (!get_rsa(&addr1,av[1]) || !get_rsa(&addr2,av[2]) || 
    !get_rsa(&len,av[3])) return(1);


for (i=errcnt=0;i<len;i++,addr1++,addr2++) {
	x1 = read_target(XT_MEM,addr1,1);
	x2 = read_target(XT_MEM,addr2,1);
	if (x1 != x2) {
		printf("%08x=%02x %08x=%02x\n",addr1,x1&0xff,addr2,x2&0xff);
		errcnt++;
		}
	if (errcnt > 20) {
		printf("Too many errors. Exiting.\n");
		break;
		}
	}
printf("Test completed with %d errors.\n",errcnt);
}



