/*************************************************************
 * File: lib/vfprintf.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980618	Removed fudge factor calc for fmt length. Now using vstrlen.
 */

#include <varargs.h>
#include <stdio.h>

#ifndef PMCC
#define vfprintf xvfprintf
#define vsprintf xvsprintf
char outputbuffer[1000];
#endif

char errmsg[] = "vfprintf: out of memory";

/*************************************************************
*  int vfprintf(fp,fmt,ap)
*/
int vfprintf(fp,fmt,ap)
FILE *fp;
char *fmt;
va_list ap;
{
char *p,buf[100];
int n;

n = vstrlen(fmt,ap);
if (n > 99) {
	p = (char *)malloc(n);
	if (p) {
		n = vsprintf(p,fmt,ap);
		fputs(p,fp);
#ifndef PMCC
		if (strlen(outputbuffer)+strlen(p)<1000) strcat(outputbuffer,p);
#endif
		free(p);
		}
	else fputs(errmsg,fp);
	}
else {
	n = vsprintf(buf,fmt,ap);
	fputs(buf,fp);
#ifndef PMCC
	if (strlen(outputbuffer)+strlen(buf)<1000) strcat(outputbuffer,buf);
#endif
	}
return(n);
}

