/*************************************************************
 * File: lib/strncpy.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "string.h"

/** char *strncpy(dst,src,n) copy n chars from src to dst */
char *strncpy(dst,src,n)
char *dst,*src;
int n;
{
char *d;

if (!dst || !src) return(dst);
d = dst;
for (;*src && n;d++,src++,n--) *d = *src;
*d = 0;
return(dst);
}

#ifdef CYGNUS
char *strcpy(dst,src)
char *dst,*src;
{
while (*src) *dst++ = *src++;
*dst = 0;
}
#endif

