/*************************************************************
 * File: lib/strequ.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "string.h"

/*************************************************************
*  int strequ(s1,s2) 
*	return 1 if s1 matches s2 else returns 0 
*/
int strequ(str1,str2)
char *str1,*str2;
{

if (!str1 || !str2) return(0);

while (*str1) if (*str1++ != *str2++) return(0);
if (*str2 == 0) return(1);
return(0);
}

#if 0 /*HTML*/
$NAME=strequ;
$SYNOPSIS= <<EOF;
#include <string.h>
int strequ(char *s1, char *s2)
EOF
$DESCRIPTION= <<EOF;
strequ() compares  its  arguments  and  returns  an  integer equal to
one or 0, depending whether s1 is equal to, or not equal to s2.
EOF
$SEEALSO="strcmp striequ strncmp";
$CATAGORY=string;
#endif

#if 0 /*DOCUMENTATION*/
NAME: strequ
SYNOPSIS:
#include <string.h>
int strequ(char *s1, char *s2)
DESCRIPTION:
strequ() compares  its  arguments  and  returns  an  integer equal to
one or 0, depending whether s1 is equal to, or not equal to s2.
SEEALSO: strcmp striequ strncmp
CATAGORY: string
#endif
