/*************************************************************
 * File: lib/stdio.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	980113	Added (Uchar *) cast to malloc
 */

#include "varargs.h"
#include "stdio.h"
#include <fcntl.h>
#include <malloc.h>

/*************************************************************
*
*   fprintf --\    putchar ------ putc --\
*             |                          |
*    printf --+-- vfprintf --+-- fputs --+-- write
*                            |           |
*      		      puts --/  fwrite --/
*
*
*  getchar ----- getc --+-- fgetc ----- read
*		        |
*     gets ---- fgets --/
*
*************************************************************/

FILE _iob[OPEN_MAX] = {
	{0,1},{1,1},{2,1}
	};

/*************************************************************
*  FILE *fopen(fname,mode) 
*	open stream
*/
FILE *fopen(fname,mode)
char *fname;
char *mode;
{
int i,fd,flags;

for (i=0;i<OPEN_MAX && _iob[i].valid;i++) ;
if (i == OPEN_MAX) return(0);
if (mode == 0) mode = "r";

if (strequ(mode,"r")) fd = open(fname,O_RDONLY,0);
else if (strequ(mode,"w")) fd = creat(fname,0666);
else return(0);

if (fd == -1) return(0);
_iob[i].fd = fd;
_iob[i].valid = 1;
_iob[i].buf = (unsigned char *) malloc(MAXLN+1); /* 980113 */
_iob[i].cnt = 0;
_iob[i].eof = 0;
_iob[i].err = 0;
return(&_iob[i]);
}

