/*************************************************************
 * File: util/setupenv.c
 * Purpose: set up the environment variables
 * Copyright: BRECIS Communications Corporation
 * Revision History:
 *	200205	Start of revision history
 */

#include <mips.h>
#include <defines.h>
#include <string.h>
#include <flashconfig.h>

#define MAXETHER		3

extern unsigned char FLASH_CONFIG_ADDRESS;

static char *etherAddrName[MAXETHER] = {
		"ethaddr0",
		"ethaddr1",
		"ethaddr2",
};

static unsigned char etherAddrIndex[MAXETHER] = {
		FLASHCONFIG_ETHERMAC0,
		FLASHCONFIG_ETHERMAC1,
		FLASHCONFIG_ETHERMAC2
};

static char *phyAddrName[MAXETHER] = {
		"phyaddr0",
		"phyaddr1",
		"phyaddr2",
};

static unsigned char phyAddrIndex[MAXETHER] = {
		FLASHCONFIG_ETHERPHY0,
		FLASHCONFIG_ETHERPHY1,
		FLASHCONFIG_ETHERPHY2
};

static int getFlashConfigString(flashConfigPtr *flashConfig, 
								flashConfigKey key,
								char *buf)
{
		flashConfigLength		valuelength;
		flashConfigValue		*valuep;

		if (getFlashConfigValue(flashConfig, key, &valuep, &valuelength))
		{
				return 0;		/* not found */
		}

		strcpy(buf, valuep);

		return 1;				/* found */
}

static int getEtherAddr(flashConfigPtr *flashConfig, int interface, char *buf)
{
		flashConfigLength		valuelength;
		flashConfigValue		*valuep;

		if (interface >= MAXETHER ||
			getFlashConfigValue(flashConfig,
								etherAddrIndex[interface],
								&valuep,
								&valuelength) ||
			valuelength != 6)
		{
				return 0;		/* not found */
		}

		sprintf(buf, "%02x:%02x:%02x:%02x:%02x:%02x",
				valuep[0], valuep[1], valuep[2],
				valuep[3], valuep[4], valuep[5]);

		return 1;				/* found */
}

void addDynamicDefaultEnvps()
{
		int				i;
		char			buf[80];
		char			cbuf[80];
		flashConfigPtr	*flashConfig;
#ifdef BRECISNOFLASH
		flashConfig = NULL;
#else
		flashConfig = validateFlashConfig(&FLASH_CONFIG_ADDRESS);
#endif

		if (flashConfig == NULL)
		{
				printf("\nNo manufacturing flash config at %lx\n", 
						(unsigned long) &FLASH_CONFIG_ADDRESS);
		}

		if (flashConfig != NULL)
		{
				for (i = 0; i < MAXETHER; i++)
				{
						if (getEtherAddr(flashConfig, i, buf))
						{
								sprintf(cbuf, "set %s %s", 
										etherAddrName[i], buf);
								do_cmd(cbuf);
						}
				}

				for (i = 0; i < MAXETHER; i++)
				{
						if (getFlashConfigString(flashConfig, 
												 phyAddrIndex[i], buf))
						{
								sprintf(cbuf, "set %s %s", 
										phyAddrName[i], buf);
								do_cmd(cbuf);
						}
				}

				if (getFlashConfigString(flashConfig, FLASHCONFIG_SERIAL, buf))
				{
					sprintf(cbuf, "set %s %s", "serialno", buf);
					do_cmd(cbuf);
				}
		}
}


