/******************************************************************
 * Copyright (c) 2001,2003 BRECIS Communications
 *      This software is the property of BRECIS Communications
 *      and may not be copied or distributed in any form without
 *      a prior licensing arrangement.
 *
 * BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 *
 ******************************************************************/
/*************************************************************
 * File: lib/r5000cfl.s
 * Purpose: Part of C runtime library
 * Revision History:
 */

#ifndef BRECIS5000
#define BRECIS5000
#endif
#include <mips.h>
#include <brecis.h>

/*************************************************************
*  Invalidate the BRECIS mips caches
*
*/


/*************************************************************
*  r5000_flush(type,adr)
*	Invalidate the designated BRECIS5000 cache.
*	Note that this isn't a real subroutine, it just transfers
*	control to the appropriate flush routine.
*/
	.globl r5000_flush
	.ent r5000_flush
r5000_flush:
	bne	a0,ICACHEI,1f
	j	r5000_iflush

1:	bne	a0,ICACHE,1f
	j	r5000_iflush

1:	bne	a0,DCACHE,1f
	j	r5000_dflush

1:	bne	a0,DCACHEI,1f
	j	r5000_dflush

1:	move	a0,a1
	j	r5000_iflush
	.end r5000_flush

/*************************************************************
*  r5000_iflush()
*	Invalidate the BRECIS5000 Instruction cache.
*/
	.globl r5000_iflush
	.ent r5000_iflush
r5000_iflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0
1:

	.set noreorder

	li	t1,0x80000000
	addu	t0,t1,(ICACHESIZE)	# cache size

1:
	icache_indinv(r_t1)
	nop
	bne	t0,t1,1b
	addu	t1,ICACHELINESIZE	# line size

	nop
	mtc0	t7,C0_SR	# restore SR
	nop
	.set reorder
	j	ra
	.end r5000_iflush

/*************************************************************
*  r5000_dflush()
*	Invalidate the BRECIS5000 Data cache.
*	o disable ints
*	o switch to kseg1
*	o invalidate the cache
*/
	.globl r5000_dflush
	.ent r5000_dflush
r5000_dflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0
1:
	.set noreorder

	# invalidate the Dcache
	li	t0,0x80000000
	addu	t1,t0,(DCACHESIZE)

1:
	dcache_indinv(r_t0)
	nop
	bne	t0,t1,1b
	addu	t0,DCACHELINESIZE	# line size

	nop
	mtc0	t7,C0_SR	# restore SR
	nop
	.set reorder
	j	ra
	.end r5000_dflush

/*************************************************************
*   HitInvDCache()
*	Invalidate BRECIS 5000 Data cache entries.
*	o disable ints
*	o switch to kseg1
*	o invalidate the cache
*/
	.globl HitInvDCache
	.ent HitInvDCache
HitInvDCache:
	lw	v0, MEM_CNFG_REG	/* force memory controller to finish writes */

	.set noreorder
	addu a1, DCACHELINESIZE-1

1:
	# invalidate the Dcache entry
	subu a1, DCACHELINESIZE
	dcache_hitinv(r_a0)
	nop
#	.set push
#	.set mips4
#	pref 0,0(a0)		/* try to prefetch data to cache */
#	.set pop
	bgtz a1, 1b
	addu a0,DCACHELINESIZE

	.set reorder
	sync
	j	ra
	.end HitInvDCache

	.globl Sync
	.ent Sync
Sync:
	.set push
	.set mips3
	sync
	.set pop
	lw	v0, MEM_CNFG_REG	/* force memory controller to finish writes */
	j	ra
	.end Sync
