/*************************************************************
 * File: lib/r33kcfl.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#ifndef LR33000
#define LR33000
#endif
#include <mips.h>

/*************************************************************
*  Note that once the DCIC_I or DCIC_D have been set, you won't
*  be able to single step, or do anything complicated until you
*  have cleared them again.
*************************************************************/


/*************************************************************
*  r33k_flush(type,adr)
*	Flush the designated LR33000 cache.
*	Note that this isn't a real subroutine, it just transfers
*	control to the appropriate flush routine.
*/
	.globl r33k_flush
	.ent r33k_flush
r33k_flush:
	bne	a0,ICACHEI,1f
	j	r33k_iflush

1:	bne	a0,ICACHE,1f
	j	r33k_iflush

1:	bne	a0,DCACHE,1f
	j	r33k_dflush

1:	bne	a0,DCACHEI,1f
	j	r33k_dflush

1:	move	a0,a1
	j	r33k_iaflush
	.end r33k_flush


/*************************************************************
*  r33k_iflush()
*	Flush the LR33000 Instruction cache.
*/
	.globl r33k_iflush
	.ent r33k_iflush
r33k_iflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0

1:	li	t0,K0BASE
	addu	t4,t0,511*16
	li	t2,DCIC_I

	.set noreorder
	mfc0	t8,C0_DCIC
	nop
	mtc0	t2,C0_DCIC
	nop
	nop
	.set reorder

1:	sw	zero,(t0)
	addu	t0,16
	bne	t4,t0,1b

	.set noreorder
	nop
	nop
	nop
	mtc0	t8,C0_DCIC	# restore DCIC
	mtc0	t7,C0_SR	# restore SR
	.set reorder
	j	ra
	.end r33k_iflush

/*************************************************************
*  r33k_dflush()
*	Flush the LR33000 Data cache.
*/
	.globl r33k_dflush
	.ent r33k_dflush
r33k_dflush:
	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0

1:	li	t0,K0BASE
	addu	t4,t0,63*16
	li	t2,DCIC_D

	.set noreorder
	mfc0	t8,C0_DCIC
	nop
	mtc0	t2,C0_DCIC
	nop
	nop
	.set reorder

1:	sw	zero,(t0)
	addu	t0,16
	bne	t4,t0,1b

	.set noreorder
	nop
	nop
	nop
	mtc0	t8,C0_DCIC
	mtc0	t7,C0_SR	# restore SR
	.set reorder
	j	ra
	.end r33k_dflush

/*************************************************************
*  r33k_iaflush(addr)
*	Flush a single entry in the LR33000 Instruction cache.
*/
	.globl r33k_iaflush
	.ent r33k_iaflush
r33k_iaflush:
	# a0=addr
	# word align the address
	li	t0,~3
	and	a0,t0

	# disable ints
	.set noreorder
	mfc0	t7,C0_SR
	nop
	and	t0,t7,~SR_IEC
	mtc0	t0,C0_SR
	.set reorder

	# switch to Kseg1
	la	t0,1f
	li	t1,K1BASE
	or	t0,t1
	j	t0

1:	li	t2,DCIC_I

	.set noreorder
	mfc0	t8,C0_DCIC
	nop
	mtc0	t2,C0_DCIC
	nop
	nop
	.set reorder

	sw	zero,(a0)	# THE FLUSH

	.set noreorder
	nop
	nop
	nop
	mtc0	t8,C0_DCIC	# restore DCIC
	mtc0	t7,C0_SR	# restore SR
	.set reorder
	j	ra
	.end r33k_iaflush

