/*************************************************************
 * File: lib/ptty.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include "terms.h"
/* 
 * memory-mapped pseudo tty device
 *
 */

ptty(op,siodat,chan,ch)
int op,chan,ch;
struct pttyinfo *siodat;
{
int i,cha,c;

switch (op) {
	case OP_RXRDY :
		if (siodat->rx->sr) return(1);
		break;
	case OP_RX :
		c = siodat->rx->hr;
		siodat->rx->sr = 0;
		return(c);
		break;
	case OP_TXRDY :
		if (siodat->tx->sr == 0) return(1);
		break;
	case OP_TX :
		siodat->tx->hr = ch;
		siodat->tx->sr = 1;
		break;
	case OP_INIT :
		if (chan) { /* Dte */
			siodat->rx = (struct pttyRec *)(siodat->siobase+8);
			siodat->tx = (struct pttyRec *)siodat->siobase;
			siodat->rx->sr = 0;
			siodat->tx->sr = 0;
			}
		else { /* Dce */
			siodat->rx = (struct pttyRec *)siodat->siobase;
			siodat->tx = (struct pttyRec *)(siodat->siobase+8);
			}
		break;
	case OP_BAUD :
		return(1);
		break;
	case OP_CLKINIT :
		return(0); /* no clock present */
		break;
	case OP_DELAY :
		return(0); /* no clock present */
		break;
	default :
		return(-1);
	}
return(0); /* successful return */
}

