/*************************************************************
 * File: lib/perror.c
 * Purpose: Print error message.
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980623	Created
 */
#include <errno.h>
#include <stdio.h>

char *_sys_errlist[] = {
	"",
	"Invalid argument",
	"No such file or directory",
	"Too many open files",
	"","","","","",
	"Bad file descriptor",
	"","","",
	"Permission denied",
	"","","","","",
	"No such device",
	};
int _sys_nerr = 20; /* number of items in errlist */

/*************************************************************
*  void perror(const char *msg)
*	Performs the same function as the CLIB function of 
*	the same name.
*/
void perror(const char *msg)
{
char *p;

if (errno < 0 || errno >= _sys_nerr) p = "unknown errno";
else p = _sys_errlist[errno];
if (msg && *msg) fprintf(stderr,"%s: %s.\n",msg,p);
else fprintf(stderr,"%s.\n",p);
}

