/*************************************************************
 * File: lib/led4102.c
 * Purpose: Driver for 7-segment led display on the bdmr4102
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981129	Created
 */

#include <utypes.h>

#define outw(a,v)	(*((volatile Ulong *)(a))=(v))
#define LED_BASE	0xbe000020

static int ledseq[] = {1,2,4,8,0x10,0x20,0};

static int ledval[] = {
	~(1|2|4|8|0x10|0x20),		/* 0 */
	~(2|4),				/* 1 */
	~(1|2|0x40|8|0x10),		/* 2 */
	~(1|2|4|8|0x40),		/* 3 */
	~(2|4|0x40|0x20),		/* 4 */
	~(1|4|8|0x40|0x20),		/* 5 */
	~(1|4|8|0x10|0x20|0x40),	/* 6 */
	~(1|2|4),			/* 7 */
	~(1|2|4|8|0x10|0x20|0x40),	/* 8 */
	~(1|2|4|8|0x20|0x40),		/* 9 */
	~(1|2|4|0x10|0x20|0x40),	/* A */
	~(4|8|0x10|0x20|0x40),		/* B */
	~(1|8|0x10|0x20),		/* C */
	~(2|4|8|0x10|0x40),		/* D */
	~(1|8|0x10|0x20|0x40),		/* E */
	~(1|0x10|0x20|0x40)		/* F */
	};

/* decimal point = 0x80 */
/* g ~(1|2|0x40|0x20|4|8); */
/* H ~(0x20|0x10|0x40|2|4); */
/* j ~(2|4|8); */
/* L ~(0x20|0x10|8); */
/* P ~(1|2|0x40|0x20|0x10); */
/* U ~(0x20|0x10|8|4|2); */
/* Z ~(1|2|0x40|0x10\8); */

wrledhex_4102(int n)
{
outw(LED_BASE,ledval[n&0xf]);
}

#ifdef TEST
main()
{
int i;

for (i=0;;i++) {
	if (i>15) i = 0;
	wrled_4102(i);
	delay();
	}
}

walk()
{
int i;

for (i=0;;i++) {
	if (ledseq[i] == 0) i = 0;
	outw(LED_BASE,~ledseq[i]);
	delay();
	}
}

delay()
{
int i;

for (i=0;i<10000000;i++) ;
}
#endif
