/*************************************************************
 * File: lib/iceport.c
 * Purpose: PMON/IMON Driver for SerialICE port
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	970828	Tested on 4101 RevB eval bd.
 *	980806	Fixed to take base adr from siodat.
 */

#include <mips.h>
/* 
 * Polled I/O routines for the LSI  ICEport
 *
 */

#include <terms.h>
#include <utypes.h>


#define inb(a)      (*((volatile Uchar *)(a)))
#define inh(a)      (*((volatile Ushort *)(a)))
#define inw(a)      (*((volatile Ulong *)(a)))
#define outb(a,v)      (*((volatile Uchar *)(a))=(v))
#define outh(a,v)      (*((volatile Ushort *)(a))=(v))
#define outw(a,v)      (*((volatile Ulong *)(a))=(v))

#define UART_RXS        0x0     /* rx status */
#define UART_RXC        0x0     /* rx control */
#define UART_RXHR       0x4     /* rx holding reg */
#define UART_TXS        0x8     /* tx status */
#define UART_TXHR       0xc     /* tx holding reg */
 
#define RXS_RXRDY       (1<<0)  /* rx ready */
#define RXS_OVR         (1<<1)  /* rx overrun */
#define RXC_IE          (1<<0)  /* interrupt enable */
#define TXS_TXRDY       (1<<0)  /* tx ready */

/*************************************************************
*  iceport(op,siodat,chan,ch)
*/
iceport(op,siodat,chan,ch)
int op,chan,ch;
void *siodat;
{
struct iceportinfo *info = siodat;
Ulong uart_base = info->siobase;

switch (op) {
	case OP_RXRDY : 
		if (inw(uart_base+UART_RXS)&RXS_RXRDY) return(1);
		break;

	case OP_RX :
		return inw(uart_base+UART_RXHR)&0xff;

	case OP_TXRDY :
		if (inw(uart_base+UART_TXS)&TXS_TXRDY) return(1);
		break;

	case OP_TX :
		return outw(uart_base+UART_TXHR,ch);
		break;

	case OP_INIT : 
		/* no init required */
		break;
	case OP_BAUD : 
		/* baud rate generator is not programmable */
		break;
	case OP_CLKINIT : break;
	case OP_DELAY : return(0); break;
	case OP_BAUDRATES: return(0); break;
	}
return(0);
}

