/*************************************************************
 * File: lib/ic4011.c
 * Purpose: C startup file for 4011
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	981014	Created from c4101.c
 */

/*
 * DEFBAUD, ETHERNET, ETHERHWADDR, ETHERIPADDR, are determined 
 * by the values in include/defines.h.
 */

#include <terms.h>
#include <termio.h>

#ifdef R4KEXCEPTIONS
#undef GEN_VECT
#define GEN_VECT 0x80000180
#endif

int p2681();
static struct p2681info tty1dat = {0xbe000000,3,4};
Func *clkinit_2681();
void *sonic_driver();

Func *_clkfunc;
extern fFunc *clkinit_ptr;
vpFunc *ether_driver_ptr;
extern void *_clkinfo;
int _ehandler(),_ehandler_end();
int vflag;

struct {
	char *name;
	char *value;
	} envlist[] = {
#ifdef ETHERNET
	{"etheraddr",ETHERHWADDR},
	{"ipaddr",   ETHERIPADDR},
#endif
	{0}};

/*************************************************************
*/
void cstartup(void)
{
addDevice((Addr)&tty1dat,0,p2681,1024,DEFBAUD);
addDevice((Addr)&tty1dat,1,p2681,1024,DEFBAUD);
clkinit_ptr = clkinit_2681;
_clkinfo = &tty1dat;
#ifdef ETHERNET
#ifdef MIPSEB
re_ether = 1;
#endif
ether_driver_ptr = sonic_driver;
#endif
memcpy((void *)GEN_VECT,_ehandler,((Ulong)_ehandler_end)-((Ulong)_ehandler));
flush_cache(DCACHE);
flush_cache(ICACHE);
mtc0(C0_SR,mfc0(C0_SR)&~SR_BEV);
}

/*************************************************************
*/
flush_cache(int mode) 
{
r4010_flush(mode); 
}

/*************************************************************
*  Stubs and pass-throughs
*/
int open(char *name,int mode){return _open(name,mode);}
int close(int fd) {return _close(fd);}
int read(int fd,char *buf,int len) {return _read(fd,buf,len);}
int write(int fd,char *buf,int len) {return _write(fd,buf,len);}


#ifndef ETHERNET
ether_open(){return(-1);} /* called by _open */
ether_close() {} /* called by _close */
ether_read() {} /* called by _read */
#endif


/***********************************************************************
*/
char *getMonEnv(char *name)
{
int i;

for (i=0;envlist[i].name;i++) {
	if (strequ(name,envlist[i].name)) return(envlist[i].value);
	}
return(0);
}

