/*************************************************************
 * File: lib/gputc.c
 * Purpose: A graphical putc for use with the LR33120 and font.c
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <screen.h>

#define FOREGROUND 1		/* foreground color */
#define BACKGROUND 0		/* background color */

extern char chlist[][11];

#define pixel(x,y,color)  (*((char *)(SCRN_BASE+(x)+(SCRN_WIDTH*(y)))) = color)

/*************************************************************
*  gputs(x,y,p)
*/
gputs(x,y,p)
int x,y;
char *p;
{

for (;*p;p++,x += 8) gputc(x,y,*p);
}

/*************************************************************
*  gputc(x,y,c)
*/
gputc(x,y,c)
int x,y,c;
{
int j,k;
char b,*p;


p = chlist[c];
for (j=10;j>=0;j--) {
	b = p[j];
	for (k=7;k>=0;k--) {
		if ((b & 1) == 1) pixel(x+k,y+j-9,FOREGROUND);
		else pixel(x+k,y+j-9,BACKGROUND);
		b = b>>1;
		}
	}
}

