/*************************************************************
 * File: lib/fileno.c
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <stdio.h>

#undef fileno
#undef clearerr
#undef ferror

/*************************************************************
*  fileno(fp)
* 	convert an fp to an fd
*/
fileno(fp)
FILE *fp;
{
return(fp->fd);
}

/*************************************************************
*  clearerr(fp)
*	Clear file read error. Provided as a stub to aid in porting
*	customer applications to run under PMON.
*/
clearerr(fp)
FILE *fp;
{
fp->eof = 0;
fp->err = 0;
}

/*************************************************************
*  ferror(fp)
*	Return file read error status. Provided as a stub to aid in 
*	porting	customer applications to run under PMON.
*/
ferror(fp)
FILE *fp;
{
return(fp->err);
}

