/*************************************************************
 * File: lib/disolate.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

/*
 * Support routines for the ATMizer
 *
 */

/*************************************************************
*  Ulong read_Disolated(adr)
*	read with the Dcache isolated
*	used when accessing the IRAM
*/
	.globl read_Disolated
	.ent read_Disolated
read_Disolated:
        .set noreorder
        mfc0 t0,C0_SR
        nop
        or   t0,SR_ISC
        mtc0 t0,C0_SR
        nop
	nop
	lw	v0,(a0)
	nop
        mfc0 t0,C0_SR
        nop
        and   t0,~SR_ISC
        mtc0 t0,C0_SR
        nop
        .set reorder
	j	ra
	.end read_Disolated

/*************************************************************
*  write_Disolated(adr,v)
*	write with the Dcache isolated
*	used when accessing the IRAM
*/
	.globl write_Disolated
	.ent write_Disolated
write_Disolated:
        .set noreorder
        mfc0 t0,C0_SR
        nop
        or   t0,SR_ISC
        mtc0 t0,C0_SR
        nop
	nop
	sw	a1,(a0)
	nop
        mfc0 t0,C0_SR
        nop
        and   t0,~SR_ISC
        mtc0 t0,C0_SR
        nop
        .set reorder
	j	ra
	.end write_Disolated

