/*************************************************************
 * File: lib/ctime.c
 * Purpose: time conversion routines
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	980628	Created
 *	981220	Fixed decl for ctime, localtime, and gmtime.
 */

/*
 * WARNING -- This module contains a number of non-reentrant routines
 */

#include <time.h>

static int monlen[] = {31,28,31,30,31,30,31,31,30,31,30,31};
static char *wdays[] = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
static char *mons[] = {"Jan","Feb","Mar","Apr","May","Jun",
                       "Jul","Aug","Sep","Oct","Nov","Dec"};

static long timezone; /* in seconds */
static int daylight;

/*************************************************************
*  static int isleap(int year)
*	This is rather basic. The real algorithm is more complicated.
*	1972 was the first leap year after 1970.
*/
static int isleap(int year)
{
year -= 1972;
if ((year%4) == 0) return(1);
return(0);
}

/*************************************************************
*  char *ctime(time_t *clock)
*	Convert 'clock' to a 26-character string.
*/
char *ctime(time_t *clock)
{
return asctime(gmtime(clock));
}

/*************************************************************
*  struct tm *localtime(time_t *clock)
*	Convert 'clock' to a tm struct.
*	Use TZ info to convert to local time.
*/
struct tm *localtime(time_t *clock)
{
time_t here;

here = *clock+timezone;
return gmtime(&here);
}

/*************************************************************
*  struct tm *gmtime(time_t *clock)
*	Convert 'clock' to a tm struct.
*	Time starts on Thu 1st Jan 1970
*/
struct tm *gmtime(time_t *pClock)
{
time_t secs,clock;
static struct tm ts;
int wday,leap,len;

clock = *pClock;
wday = 4; /* Jan 1st 1970 was a Thursday */
for (ts.tm_year=0;;ts.tm_year++) {
	secs = 365*24*60*60;
	if ((leap=isleap(1970+ts.tm_year))) secs += 24*60*60;
	if (clock-secs > clock) break;
	clock -= secs;
	wday++;
	if (leap) wday++;
	if (wday > 6) wday -= 7;
	}
ts.tm_year += 70;

ts.tm_yday = clock/(24*60*60);
wday += ts.tm_yday%7;
if (wday > 6) wday -= 7;
for (ts.tm_mon=0;;ts.tm_mon++) {
	len = monlen[ts.tm_mon];
	if (ts.tm_mon == 1 && isleap(ts.tm_year+1900)) len++;
	secs = len*24*60*60;
	if (clock-secs > clock) break;
	clock -= secs;
	}
ts.tm_mday = (clock/(24*60*60))+1;
clock %= 24*60*60;
ts.tm_hour = clock/(60*60);
clock %= 60*60;
ts.tm_min = clock/60;
clock %= 60;
ts.tm_sec = clock;
ts.tm_isdst = daylight;
ts.tm_wday = wday;
return(&ts);
}

/*************************************************************
*  char *asctime(struct tm *tm)
*	Convert tm struct to a 26-character string.
*/
char *asctime(struct tm *ts)
{
static char tstr[30];

sprintf(tstr,"%s %s %02d %02d:%02d:%02d %d\n",
	wdays[ts->tm_wday],mons[ts->tm_mon],
	ts->tm_mday,ts->tm_hour,ts->tm_min,
	ts->tm_sec,1900+ts->tm_year);
return(tstr);
}

/*************************************************************
*  int tzset(char *name)
*/
int tzset(char *name)
{
return(0);
}

/*************************************************************
*  time_t mktime(int yr,int mon,int day,int hr,int min)
*	mktime on win32 converts a struct to a time_t. Perhaps
*	I should too.
*/
time_t mktime(int yr,int mon,int day,int hr,int min)
{
int i,len;
time_t clock;

if (yr < 70) yr += 2000;
else yr += 1900;
yr -= 1970;
clock = 0;
for (i=0;i<yr;i++) {
	clock += 365*24*60*60;
	if (isleap(1970+i)) clock += 24*60*60;
	}
mon--; /* convert to zero-based value */
for (i=0;i<mon;i++) {
	len = monlen[i];
	if (i == 1 && isleap(yr+1970)) len++;
	clock += len*24*60*60;
	}
day--; /* convert to zero-based value */
clock += day*24*60*60;
clock += hr*60*60;
clock += min*60;
return(clock);
}

