/*************************************************************
 * File: lib/crt3.s
 * Purpose: Start-up code for an IMON Target Description Driver
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970225	Added disasm as offset 18.
 *	970303	Changed _dvrInit to _start.
 *	970305	Added get_rsa as offset 19.
 *	970311	Added is_gdbmode as offset 20.
 *	970409	Added addEnvRec as offset 21.
 */

#include <mips.h>
#include <imon.h>

#define TBLBASE 0xbfc00500

#define TBLENTRY(n,m) 			\
	.globl m; 			\
	.ent m;				\
m:	li	t0,TBLBASE+(4*n);	\
	lw	t0,(t0);		\
	j	t0;			\
	.end m

	# this table must be in the text section
	.globl dvrtbl
dvrtbl:
	.set noreorder
	j	_start
	nop
	.set reorder
	.word	DVRIF_VERS
	.word	_cputype
	.word	_drivername
	.word	read_target
	.word	write_target
	.word	run_target
	.word	setbp_target
	.word	clrbp_target
	.word	flush_target
	.word	0
	.word	is_writeable_target

	.globl _start
	.ent _start
_start:
	subu	sp,24
	sw	ra,20(sp)
	jal clrbss
	jal	dvrInit
	lw	ra,20(sp)
	addu	sp,24
	j	ra
	.end _start



TBLENTRY(0,read)
TBLENTRY(1,write)
TBLENTRY(2,open)
TBLENTRY(3,close)
TBLENTRY(4,ioctl)
TBLENTRY(5,printf)
TBLENTRY(6,addRegRec)
TBLENTRY(7,malloc)
/* TBLENTRY(8,cpuInit) */
TBLENTRY(9,getMonEnv)
TBLENTRY(11,flush_cache)
TBLENTRY(12,stop)
TBLENTRY(13,getBpid)

	.globl is_xvwmode
	.ent is_xvwmode
is_xvwmode:
	li	t0,TBLBASE+(4*14)
	lw	t0,(t0)
	lw	v0,(t0)
	j	ra
	.end is_xvwmode

TBLENTRY(15,gdbstop)
TBLENTRY(16,setTrcbp)
TBLENTRY(17,addCmdRec)
TBLENTRY(18,disasm) /* 970225 */
TBLENTRY(19,get_rsa) /* 970305 */

	/* 970311 */
	.globl is_gdbmode
	.ent is_gdbmode
is_gdbmode:
	li	t0,TBLBASE+(4*20)
	lw	t0,(t0)
	lw	v0,(t0)
	j	ra
	.end is_gdbmode

TBLENTRY(21,addEnvRec) /* 970409 */

	.ent flush_target
flush_target:
	lw	t0,flush_target_ptr
	j	t0
	.end flush_target

/* this stub is needed by filbuf */
	.globl exit
	.ent exit
exit:	b	exit
	.end exit

