/*************************************************************
 * File: lib/cp3supp.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

/*
** Support for coprocessor 3
**
**	value = cfc3(reg)
**	ctc3(value,reg)
**	value = mfc3(reg)
**	mtc3(value,reg)
*/

	.data
cfc3L:	.word cfc30, cfc31, cfc32, cfc33, cfc34, cfc35, cfc36, cfc37
	.word cfc38, cfc39, cfc310, cfc311, cfc312, cfc313, cfc314
	.word cfc315, cfc316, cfc317, cfc318, cfc319, cfc320, cfc321
	.word cfc322, cfc323, cfc324, cfc325, cfc326, cfc327, cfc328
	.word cfc329, cfc330, cfc331

	.text
	.globl std_cfc3
	.ent std_cfc3
std_cfc3: 	# value = cfc3(reg)
	la	t0,cfc3L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

cfc30:	cfc3	v0,$0; b	1f
cfc31:	cfc3	v0,$1; b	1f
cfc32:	cfc3	v0,$2; b	1f
cfc33:	cfc3	v0,$3; b	1f
cfc34:	cfc3	v0,$4; b	1f
cfc35:	cfc3	v0,$5; b	1f
cfc36:	cfc3	v0,$6; b	1f
cfc37:	cfc3	v0,$7; b	1f
cfc38:	cfc3	v0,$8; b	1f
cfc39:	cfc3	v0,$9; b	1f
cfc310:	cfc3	v0,$10; b	1f
cfc311:	cfc3	v0,$11; b	1f
cfc312:	cfc3	v0,$12; b	1f
cfc313:	cfc3	v0,$13; b	1f
cfc314:	cfc3	v0,$14; b	1f
cfc315:	cfc3	v0,$15; b	1f
cfc316:	cfc3	v0,$16; b	1f
cfc317:	cfc3	v0,$17; b	1f
cfc318:	cfc3	v0,$18; b	1f
cfc319:	cfc3	v0,$19; b	1f
cfc320:	cfc3	v0,$20; b	1f
cfc321:	cfc3	v0,$21; b	1f
cfc322:	cfc3	v0,$22; b	1f
cfc323:	cfc3	v0,$23; b	1f
cfc324:	cfc3	v0,$24; b	1f
cfc325:	cfc3	v0,$25; b	1f
cfc326:	cfc3	v0,$26; b	1f
cfc327:	cfc3	v0,$27; b	1f
cfc328:	cfc3	v0,$28; b	1f
cfc329:	cfc3	v0,$29; b	1f
cfc330:	cfc3	v0,$30; b	1f
cfc331:	cfc3	v0,$31
1:	j	ra
	.end std_cfc3

	.data
ctc3L:	.word ctc30, ctc31, ctc32, ctc33, ctc34, ctc35, ctc36, ctc37
	.word ctc38, ctc39, ctc310, ctc311, ctc312, ctc313, ctc314
	.word ctc315, ctc316, ctc317, ctc318, ctc319, ctc320, ctc321
	.word ctc322, ctc323, ctc324, ctc325, ctc326, ctc327, ctc328
	.word ctc329, ctc330, ctc331

	.text
	.globl std_ctc3
	.ent std_ctc3
std_ctc3:	# ctc3(reg,value)
	la	t0,ctc3L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

ctc30:	ctc3	a1,$0; b	1f
ctc31:	ctc3	a1,$1; b	1f
ctc32:	ctc3	a1,$2; b	1f
ctc33:	ctc3	a1,$3; b	1f
ctc34:	ctc3	a1,$4; b	1f
ctc35:	ctc3	a1,$5; b	1f
ctc36:	ctc3	a1,$6; b	1f
ctc37:	ctc3	a1,$7; b	1f
ctc38:	ctc3	a1,$8; b	1f
ctc39:	ctc3	a1,$9; b	1f
ctc310:	ctc3	a1,$10; b	1f
ctc311:	ctc3	a1,$11; b	1f
ctc312:	ctc3	a1,$12; b	1f
ctc313:	ctc3	a1,$13; b	1f
ctc314:	ctc3	a1,$14; b	1f
ctc315:	ctc3	a1,$15; b	1f
ctc316:	ctc3	a1,$16; b	1f
ctc317:	ctc3	a1,$17; b	1f
ctc318:	ctc3	a1,$18; b	1f
ctc319:	ctc3	a1,$19; b	1f
ctc320:	ctc3	a1,$20; b	1f
ctc321:	ctc3	a1,$21; b	1f
ctc322:	ctc3	a1,$22; b	1f
ctc323:	ctc3	a1,$23; b	1f
ctc324:	ctc3	a1,$24; b	1f
ctc325:	ctc3	a1,$25; b	1f
ctc326:	ctc3	a1,$26; b	1f
ctc327:	ctc3	a1,$27; b	1f
ctc328:	ctc3	a1,$28; b	1f
ctc329:	ctc3	a1,$29; b	1f
ctc330:	ctc3	a1,$30; b	1f
ctc331:	ctc3	a1,$31
1:	j	ra
	.end std_ctc3

	.data
mfc3L:	.word mfc30, mfc31, mfc32, mfc33, mfc34, mfc35, mfc36, mfc37
	.word mfc38, mfc39, mfc310, mfc311, mfc312, mfc313, mfc314
	.word mfc315, mfc316, mfc317, mfc318, mfc319, mfc320, mfc321
	.word mfc322, mfc323, mfc324, mfc325, mfc326, mfc327, mfc328
	.word mfc329, mfc330, mfc331

	.text
	.globl std_mfc3
	.ent std_mfc3
std_mfc3:	# value = mfc3(reg)
	la	t0,mfc3L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

mfc30:	mfc3	v0,$0; b	1f
mfc31:	mfc3	v0,$1; b	1f
mfc32:	mfc3	v0,$2; b	1f
mfc33:	mfc3	v0,$3; b	1f
mfc34:	mfc3	v0,$4; b	1f
mfc35:	mfc3	v0,$5; b	1f
mfc36:	mfc3	v0,$6; b	1f
mfc37:	mfc3	v0,$7; b	1f
mfc38:	mfc3	v0,$8; b	1f
mfc39:	mfc3	v0,$9; b	1f
mfc310:	mfc3	v0,$10; b	1f
mfc311:	mfc3	v0,$11; b	1f
mfc312:	mfc3	v0,$12; b	1f
mfc313:	mfc3	v0,$13; b	1f
mfc314:	mfc3	v0,$14; b	1f
mfc315:	mfc3	v0,$15; b	1f
mfc316:	mfc3	v0,$16; b	1f
mfc317:	mfc3	v0,$17; b	1f
mfc318:	mfc3	v0,$18; b	1f
mfc319:	mfc3	v0,$19; b	1f
mfc320:	mfc3	v0,$20; b	1f
mfc321:	mfc3	v0,$21; b	1f
mfc322:	mfc3	v0,$22; b	1f
mfc323:	mfc3	v0,$23; b	1f
mfc324:	mfc3	v0,$24; b	1f
mfc325:	mfc3	v0,$25; b	1f
mfc326:	mfc3	v0,$26; b	1f
mfc327:	mfc3	v0,$27; b	1f
mfc328:	mfc3	v0,$28; b	1f
mfc329:	mfc3	v0,$29; b	1f
mfc330:	mfc3	v0,$30; b	1f
mfc331:	mfc3	v0,$31 
1:	j	ra
	.end std_mfc3

	.data
mtc3L:	.word mtc30, mtc31, mtc32, mtc33, mtc34, mtc35, mtc36, mtc37
	.word mtc38, mtc39, mtc310, mtc311, mtc312, mtc313, mtc314
	.word mtc315, mtc316, mtc317, mtc318, mtc319, mtc320, mtc321
	.word mtc322, mtc323, mtc324, mtc325, mtc326, mtc327, mtc328
	.word mtc329, mtc330, mtc331

	.text
	.globl std_mtc3
	.ent std_mtc3
std_mtc3:	# mtc3(reg,value)
	la	t0,mtc3L
	sll	a0,2
	addu	a0,t0
	lw	t0,(a0)
	j	t0

mtc30:	mtc3	a1,$0; b	1f
mtc31:	mtc3	a1,$1; b	1f
mtc32:	mtc3	a1,$2; b	1f
mtc33:	mtc3	a1,$3; b	1f
mtc34:	mtc3	a1,$4; b	1f
mtc35:	mtc3	a1,$5; b	1f
mtc36:	mtc3	a1,$6; b	1f
mtc37:	mtc3	a1,$7; b	1f
mtc38:	mtc3	a1,$8; b	1f
mtc39:	mtc3	a1,$9; b	1f
mtc310:	mtc3	a1,$10; b	1f
mtc311:	mtc3	a1,$11; b	1f
mtc312:	mtc3	a1,$12; b	1f
mtc313:	mtc3	a1,$13; b	1f
mtc314:	mtc3	a1,$14; b	1f
mtc315:	mtc3	a1,$15; b	1f
mtc316:	mtc3	a1,$16; b	1f
mtc317:	mtc3	a1,$17; b	1f
mtc318:	mtc3	a1,$18; b	1f
mtc319:	mtc3	a1,$19; b	1f
mtc320:	mtc3	a1,$20; b	1f
mtc321:	mtc3	a1,$21; b	1f
mtc322:	mtc3	a1,$22; b	1f
mtc323:	mtc3	a1,$23; b	1f
mtc324:	mtc3	a1,$24; b	1f
mtc325:	mtc3	a1,$25; b	1f
mtc326:	mtc3	a1,$26; b	1f
mtc327:	mtc3	a1,$27; b	1f
mtc328:	mtc3	a1,$28; b	1f
mtc329:	mtc3	a1,$29; b	1f
mtc330:	mtc3	a1,$30; b	1f
mtc331:	mtc3	a1,$31 
1:	j	ra
	.end std_mtc3
	.set noreorder
	nop

