/*************************************************************
 * File: lib/cp2step.s
 * Purpose: C support for LR33020/33120 graphx instructions
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

/* Note that the Algorithmics assembler generates a large number of 
 * warnings for this file. This is because the assembler doesn't know
 * about the special graphx instructions. You can safely ignore the
 * warnings.
 */

#ifndef LR33020
#define LR33020
#endif
#include <mips.h>

/*************************************************************
*  cp2step(Ulong INSTR)
*	execute single cp2 step instruction. Returns 1 if successful,
*	otherwise 0.
*	usage: cp2step(BSTEP_SB)
*/

	.globl cp2step
	.ent cp2step
cp2step:
	la	t3,3f
1:	lw	t0,4(t3)
	beq	t0,zero,2f
	beq	t0,a0,1f
	addu	t3,8
	b	1b

1:	li	v0,1
	j	t3

2:	
	li	v0,0
	j	ra

	.set noreorder
3: 	
	j	ra; sstep
	j	ra; sbstep		
	j	ra; wstep		
	j	ra; wstep_r		
	j	ra; wstep_l		
	j	ra; wstep_s		
	j	ra; bstep		
	j	ra; bstep_r		
	j	ra; bstep_l		
	j	ra; bstep_s		
	j	ra; wstep_bfour	
	j	ra; wstep_four
	j	ra; wstep_l_r	
	j	ra; wstep_s_r	
	j	ra; wstep_s_l	
	j	ra; wstep_s_l_r	
	j	ra; wstep_sb	
	j	ra; wstep_sb_r	
	j	ra; wstep_sb_l	
	j	ra; wstep_sb_l_r	
	j	ra; bstep_bfour	
	j	ra; bstep_l_r	
	j	ra; bstep_s_r	
	j	ra; bstep_s_l	
	j	ra; bstep_s_l_r	
	j	ra; bstep_sb	
	j	ra; bstep_sb_r	
	j	ra; bstep_sb_l	
	j	ra; bstep_sb_l_r	
#ifdef LR33120
	j	ra; wstep_sb_r_i	
	j	ra; wstep_sb_l_i	
	j	ra; wstep_sb_l_r_i	
	j	ra; bstep_bfour_i	
	j	ra; bstep_r_i	
	j	ra; bstep_l_i	
	j	ra; bstep_l_r_i	
	j	ra; bstep_s_i	
	j	ra; bstep_s_r_i	
	j	ra; bstep_s_l_i	
	j	ra; bstep_s_l_r_i	
	j	ra; wstep_r_i	
	j	ra; wstep_i		
	j	ra; bstep_i		
	j	ra; wstep_bfour_i	
	j	ra; wstep_four_i	
	j	ra; wstep_l_i	
	j	ra; wstep_l_r_i	
	j	ra; wstep_s_i	
	j	ra; wstep_s_r_i	
	j	ra; wstep_s_l_i	
	j	ra; wstep_s_l_r_i	
	j	ra; wstep_sb_i	
#endif
	.word	0,0
	.set reorder
	.end cp2step

