#ifndef LR4010
#define LR4010
#endif
#include <mips.h>

#define VALID_BIT (1<<1)

/*************************************************************
*  specialRead401x(addr,cfg)
*/
	.globl specialRead401x
	.ent specialRead401x
specialRead401x:
	la	t0,1f
	or	t0,K1BASE
	j	t0
   1:
	.set noreorder
	mfc0	t8,C0_SR
	nop
	and	t0,t8,~SR_IEC
	mtc0	t0,C0_SR
	nop
	mfc0	t7,C0_CCC
	nop
	mtc0	a1,C0_CCC
	.set reorder

	# read
	lw	v0,(a0)
	.set noreorder;nop;nop;.set reorder

	# restore
	.set noreorder
	mtc0	t7,C0_CCC
	nop;nop
	.set reorder

	.set noreorder
	mtc0	t8,C0_SR
	.set reorder
	j	ra
	.end specialRead401x

/*************************************************************
*  initIsp401x(Ulong addr)
*	Switch the icache set1 to scratchpad mode.
*	Copy real memory bytes to the correct line.
*	Write the correct tag and valid bit.
*	Exit with ISR1 set.
*/
	.globl initIsp401x
	.ent initIsp401x
initIsp401x:
	# switch to kseg1
	la	t0,1f
	or	t0,K1BASE
	j	t0
   1:
	# disable ints
	.set noreorder
	mfc0	t8,C0_SR
	nop
	and	t0,t8,~SR_IEC
	mtc0	t0,C0_SR
	nop

	# read CCC
	mfc0	t7,C0_CCC
	nop
	or	t7,CCC_IE1|CCC_IS8	# t7 = ccc
	and	t6,t7,~(CCC_IE0|CCC_DE0|CCC_DE1|CCC_IE1) # t6 = tmpcfg
	.set reorder

	# setup for loop
	move	t2,a0
	and	t2,~0x1f
	move	t3,t2
	or	t3,K1BASE
	li	t4,8
   1:
	.set noreorder
	mtc0	t7,C0_CCC	# ccc
	nop; nop; nop
	.set reorder
	lw	v0,(t3)

	move	t0,t6		# tmpcfg
	or	t0,CCC_ISC|CCC_IE1
	.set noreorder
	mtc0	t0,C0_CCC
	nop
	.set reorder
	addu	t3,4
	subu	t4,1
	sw	v0,(t2)
	addu	t2,4
	bne	t4,zero,1b

	move	t0,t6		# tmpcfg
	or	t0,CCC_TAG|CCC_ISC|CCC_IE1
	.set noreorder
	mtc0	t0,C0_CCC
	.set reorder
	
	# addrmsk = (0x7<<29)|((8*1024)-1);
	# (addr&~addrmsk)|VALID_BIT;
	and	t2,a0,~((0x7<<29)|((8*1024)-1))
	or	t2,VALID_BIT
	sw	t2,(a0)

	# restore CCC
	move	t0,t7		# ccc
	or	t0,CCC_ISR1|CCC_IE1
	.set noreorder
	mtc0	t0,C0_CCC
	nop;nop
	
	# restore SR
	mtc0	t8,C0_SR
	nop
	nop
	.set reorder

	j	ra
	.end initIsp401x

/*************************************************************
*  wrIsp401x(Ulong addr,Ulong val)
*	Writes one word to the iscratchpad. 
*	Assumes that setupcacheline() has already been called.
*/
	.globl wrIsp401x
	.ent wrIsp401x
wrIsp401x:
	# switch to kseg1
	la	t0,1f
	or	t0,K1BASE
	j	t0
   1:
	# disable ints
	.set noreorder
	mfc0	t8,C0_SR
	nop
	and	t0,t8,~SR_IEC
	mtc0	t0,C0_SR
	nop

	# read CCC
	mfc0	t7,C0_CCC		# t7 = ccc
	nop
	and	t6,t7,~(CCC_IE0|CCC_DE0|CCC_DE1|CCC_ISR1) 
	or	t6,CCC_ISC		# t6 = tmpcfg
	mtc0	t6,C0_CCC
	nop
	.set reorder

	sw	a1,(a0)

	# restore CCC
	move	t0,t7		# ccc
	.set noreorder
	mtc0	t0,C0_CCC
	nop;nop;nop
	
	# restore SR
	mtc0	t8,C0_SR
	nop
	nop
	.set reorder

	j	ra
	.end wrIsp401x

