/*************************************************************
 * File: lib/a33300.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#ifndef LR33300
#define LR33300
#endif
#include <mips.h>

/* for 333xx */
#ifdef TURBORKT 	/* use CpCond lines to determine SDRAM/DRAM/DLP1 */
#define LR333_SDRAM	/* Sync DRAM */
#define LR333_DRAM	/* reg DRAM */
#define LR333_IDRAM	/* DRAM is interleaved */
#endif
	
#if 1 /* use IS0 */
CACHECFG = (BIU_IS1|BIU_IS0|BIU_IBLKSZ4|BIU_DS1|BIU_DBLKSZ8)
#else
CACHECFG = (BIU_IS1|BIU_IBLKSZ4|BIU_DS1|BIU_DBLKSZ8)
#endif

	############# 333xx #################
	.globl a33300init
	.ent a33300init
a33300init:
	beq     a0,zero,1f
	j       c33300init
    1:


	# must be either lr33300 or lr33310
#ifdef TURBORKT
	# need to enable cp2 and cp3. This is needed on the 
	# Turbo Rocket bd to detect whether DRAM or SDRAM has 
	# been enabled.
	.set noreorder
	mfc0	t0,C0_SR
	nop
	or	t0,(SR_CU2|SR_CU3)
	mtc0	t0,C0_SR
	nop		# give it time...
	nop
	nop
	.set reorder

	# SDRAM?
	bc3t	2f	# cpc3 = 1 for DRAM, 0 for SDRAM
#endif

#ifdef LR333_SDRAM
	# yes it is configured for SDRAM
SDRAM_MODE = 0x00023000		/* was 0x00022000 */
DUMMY_LOC  = 0x80021000


	li      t0,(BIU_LDSCH|BIU_BGNT|BIU_NOPAD|BIU_RDPRI|CACHECFG)
	sw	t0,M_BIU
	li	t0,0x446
	sw	t0,M_SPEC2
	li	t0,0x50
	sw	t0,M_SRAM

	# spec0 = flash eprom sockets containing PMON
	lw	t0,M_SPEC0
	and	t0,(SPC_16WIDE|SPC_8WIDE)	/* don't touch these bits */
	or	t0,(SPC_WAITENA|(6<<SPC_WAITSHFT)|SPC_CACHED)
	sw	t0,M_SPEC0
	# spec1 = DUART
	li	t0,(SPC_WAITENA|(6<<SPC_WAITSHFT)|(8<<SPC_RECSHFT))
	sw	t0,M_SPEC1
	# spec3 = SONIC
	li	t0,(SPC_WAITENA|(16<<SPC_WAITSHFT))
	sw	t0,M_SPEC3

	li	t1,M_RTIC	#refresh
	li	t0,400			# 512 rows in 8ms = 15us
	sw	t0,(t1)
	
	/*
	 step1: Set SYNC = 1; in DRAM config reg. and read a location; This
                makes sure that a pre-charge to all banks command is issued 
                to the SDRAM
	 */
	
#if 0
	li	t0,(DRAM_SYNC|DRAM_DMARDY|(3<<DRAM_PGSZSHFT)|DRAM_RFEN)
	or	t0,((3<<DRAM_RFWESHFT)|DRAM_RDYEN|DRAM_PGMW|DRAM_DCE)
	or	t0,(2<<DRAM_CLSHFT|2<<DRAM_DPTHSHFT|DRAM_CS)
#else
	li      s0,0x0a23f815
#endif

	# make DLP1 bit dependent on state of CPC2
	bc2f	1f
	or	s0,DRAM_DLP1
1: 	sw      s0,M_DRAM
	li	t1,DUMMY_LOC
	lw	t0,0(t1)

	/* step2: wait loop for approximately 100 instructions *

	
	li	t0,0x100
1: 	subu	t0,1
	bne	zero,t0,1b	

	/* step3: set SCFG, write mode reg and reset SCFG */

	or	t0,s0,DRAM_SCFG
	sw      t0,M_DRAM
	sw	t0,SDRAM_MODE	
	sw      s0,M_DRAM

	/* step4: wait for a long time to make sure that two CBR
		  refreshes take place */

	li      t0,0xffff
1: 	subu    t0,1
        bne     zero,t0,1b

	b	3f
#endif /* !LR333_SDRAM */

#ifdef LR333_DRAM
	#####################################
2:	# regular DRAM config
        li      t0,(BIU_LDSCH|BIU_BGNT|BIU_NOPAD|BIU_RDPRI|CACHECFG)
	sw      t0,M_BIU

	li	t1,M_RTIC	#refresh
	li	t0,400			# 512 rows in 8ms = 15us
	sw	t0,(t1)

	# dram = 
#ifdef LR333_IDRAM	/* interleaved DRAM */
	li      s0,0x0215f805
#else
	li      s0,0x1205f805
#endif

#ifdef TURBORKT
        # make DLP1 bit dependent on state of CPC2
	bc2f    1f 
	or      s0,DRAM_DLP1
1:
#endif
        sw      s0,M_DRAM

	# spec2 = ??
	li	t0,(SPC_WAITENA|(4<<SPC_WAITSHFT)|SPC_CACHED|SPC_BLKENA)
	sw	t0,M_SPEC2
	# sram = ??
	li	t0,(SPC_WAITENA|(4<<SPC_WAITSHFT)|SPC_CACHED|SPC_BLKENA)
	sw	t0,M_SRAM
	# spec0 = flash eprom sockets containing PMON
	lw	t0,M_SPEC0
	and	t0,(SPC_16WIDE|SPC_8WIDE)	/* don't touch these bits */
	or	t0,(SPC_WAITENA|(6<<SPC_WAITSHFT)|SPC_CACHED)
	sw	t0,M_SPEC0
	# spec1 = DUART
	li	t0,(SPC_WAITENA|(6<<SPC_WAITSHFT)|(8<<SPC_RECSHFT))
	sw	t0,M_SPEC1
	# spec3 = SONIC
	li	t0,(SPC_WAITENA|(16<<SPC_WAITSHFT))
	sw	t0,M_SPEC3

	# delay to allow RAM to stabilize
	li	t0,1000
   1:	subu	t0,1
	bne	t0,zero,1b
#endif /* !LR333_DRAM */

	# select the correct cache flushing routines
#if 1
3:	la	s0,r3330_flush
	beq	v0,33300,1f
	la	s0,r3331_flush
   1: 	j	ra
#else
3:	la	s0,r333_flush
    	j	ra
#endif
	.end a33300init
