/*************************************************************
 * File: lib/a33020.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 */

#include <mips.h>

CACHE_CFG = (CR_IBLK_4|CR_DBLK_4)
WAIT_CFG = ((6<<CR_IOWAITSHFT)|(6<<CR_PWAITSHFT))
MEM_CFG = (CR_RDYGEN|CR_RFSHEN|CR_DRAMEN)

	.globl a33020init
	.ent a33020init
a33020init:
	beq     a0,zero,1f
	j       c33020init
    1:

	# must be a 33020 or 33120
	li	t0,375			# 512 rows in 8ms = 15us
	sw	t0,M_RTIC	# refresh

	# turn on the RAM
	li	t0,(CACHE_CFG|WAIT_CFG|MEM_CFG)
	or	t0,((7<<CR_BANKSHFT)|(5<<CR_PGSZSHFT)|CR_BEN)
	sw	t0,M_CFGREG

	# delay to allow RAM to stabilize
	li	t0,1000
1:	subu	t0,1
	bne	t0,zero,1b

	# select the correct cache flushing routines
	la	s0,r33k_flush
	j	ra
	.end a33020init
